/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.crypt;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.ColumnTransformer;
import org.jetbrains.exposed.v1.crypt.Encryptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/v1/crypt/ByteArrayEncryptionTransformer;", "Lorg/jetbrains/exposed/v1/core/ColumnTransformer;", "", "encryptor", "Lorg/jetbrains/exposed/v1/crypt/Encryptor;", "<init>", "(Lorg/jetbrains/exposed/v1/crypt/Encryptor;)V", "unwrap", "value", "wrap", "exposed-crypt"})
public final class ByteArrayEncryptionTransformer
implements ColumnTransformer<byte[], byte[]> {
    @NotNull
    private final Encryptor encryptor;

    public ByteArrayEncryptionTransformer(@NotNull Encryptor encryptor) {
        Intrinsics.checkNotNullParameter((Object)encryptor, (String)"encryptor");
        this.encryptor = encryptor;
    }

    @NotNull
    public byte[] unwrap(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.encryptor.encrypt(new String(value, Charsets.UTF_8));
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }

    @NotNull
    public byte[] wrap(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = this.encryptor.decrypt(new String(value, Charsets.UTF_8));
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return byArray;
    }
}

