/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.range;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.semver4j.Semver;
import org.semver4j.range.Range;
import org.semver4j.range.RangeList;

@NullMarked
public class RangeExpression {
    private final RangeList rangeList = new RangeList(false);
    private final List<Range> andOperationRanges = new ArrayList<Range>();

    public static RangeExpression eq(String version) {
        return RangeExpression.eq(new Semver(version));
    }

    public static RangeExpression eq(Semver version) {
        return new RangeExpression(new Range(version, Range.RangeOperator.EQ));
    }

    public static RangeExpression greater(String version) {
        return RangeExpression.greater(new Semver(version));
    }

    public static RangeExpression greater(Semver version) {
        return new RangeExpression(new Range(version, Range.RangeOperator.GT));
    }

    public static RangeExpression greaterOrEqual(String version) {
        return RangeExpression.greaterOrEqual(new Semver(version));
    }

    public static RangeExpression greaterOrEqual(Semver version) {
        return new RangeExpression(new Range(version, Range.RangeOperator.GTE));
    }

    public static RangeExpression less(String version) {
        return RangeExpression.less(new Semver(version));
    }

    public static RangeExpression less(Semver version) {
        return new RangeExpression(new Range(version, Range.RangeOperator.LT));
    }

    public static RangeExpression lessOrEqual(String version) {
        return RangeExpression.lessOrEqual(new Semver(version));
    }

    public static RangeExpression lessOrEqual(Semver version) {
        return new RangeExpression(new Range(version, Range.RangeOperator.LTE));
    }

    private RangeExpression(Range range) {
        this.andOperationRanges.add(range);
    }

    public RangeExpression and(RangeExpression rangeExpression) {
        RangeList ranges = rangeExpression.get();
        List<List<Range>> lists = ranges.get();
        for (List<Range> list : lists) {
            this.andOperationRanges.addAll(list);
            if (lists.size() <= 1) continue;
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this;
    }

    public RangeExpression or(RangeExpression rangeExpression) {
        this.flushAndClearAndOperationRangesToRangesList();
        return this.and(rangeExpression);
    }

    RangeList get() {
        if (!this.andOperationRanges.isEmpty()) {
            this.flushAndClearAndOperationRangesToRangesList();
        }
        return this.rangeList;
    }

    private void flushAndClearAndOperationRangesToRangesList() {
        this.rangeList.add(new ArrayList<Range>(this.andOperationRanges));
        this.andOperationRanges.clear();
    }
}

