/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Utils;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;

public class IvyProcessor
implements Processor {
    private static final String LATEST = "latest";
    private static final String LATEST_INTEGRATION = "latest.integration";
    private static final Pattern PATTERN = Pattern.compile("^(\\[|\\]|\\()([0-9]+)?\\.?([0-9]+)?\\.?([0-9]+)?\\,([0-9]+)?\\.?([0-9]+)?\\.?([0-9]+)?(\\]|\\[|\\))$");

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        if (range.equals(LATEST) || range.equals(LATEST_INTEGRATION)) {
            return includePreRelease ? Utils.ALL_RANGE_WITH_PRERELEASE : Utils.ALL_RANGE;
        }
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        String openSign = matcher.group(1);
        int fromMajor = Utils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = Utils.parseIntWithXSupport(matcher.group(3));
        int fromPatch = Utils.parseIntWithXSupport(matcher.group(4));
        int toMajor = Utils.parseIntWithXSupport(matcher.group(5));
        int toMinor = Utils.parseIntWithXSupport(matcher.group(6));
        int toPatch = Utils.parseIntWithXSupport(matcher.group(7));
        String closeSign = matcher.group(8);
        if (Utils.isX(fromMinor)) {
            fromMinor = 0;
        }
        if (Utils.isX(fromPatch)) {
            fromPatch = 0;
        }
        if (Utils.isX(toMinor)) {
            toMinor = 0;
        }
        if (Utils.isX(toPatch)) {
            toPatch = 0;
        }
        boolean openInclusive = this.isInclusiveRange(openSign);
        boolean closeInclusive = this.isInclusiveRange(closeSign);
        if (openInclusive && closeInclusive) {
            if (openSign.equals("[") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("[") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("]") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("]") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
        } else if (closeSign.equals(")")) {
            if (openSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch);
            }
            if (openSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch);
            }
        } else if (openSign.equals("(")) {
            if (closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
        }
        return range;
    }

    private boolean isInclusiveRange(String character) {
        return character.equals("[") || character.equals("]");
    }
}

