/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Tokenizers;
import org.semver4j.internal.Utils;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;

public class HyphenProcessor
implements Processor {
    private static final Pattern PATTERN = Pattern.compile(Tokenizers.HYPHEN);

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        String rangeFrom = this.getRangeFrom(matcher, includePreRelease);
        String rangeTo = this.getRangeTo(matcher, includePreRelease);
        return String.format(Locale.ROOT, "%s %s", rangeFrom, rangeTo);
    }

    private String getRangeFrom(Matcher matcher, boolean includePreRelease) {
        String preRelease;
        String from = matcher.group(1);
        int fromMajor = Utils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = Utils.parseIntWithXSupport(matcher.group(3));
        int fromPatch = Utils.parseIntWithXSupport(matcher.group(4));
        String string = preRelease = includePreRelease ? "-0" : "";
        if (Utils.isX(fromMinor)) {
            return String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.GTE.asString(), fromMajor, preRelease);
        }
        if (Utils.isX(fromPatch)) {
            return String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, preRelease);
        }
        return String.format(Locale.ROOT, "%s%s", Range.RangeOperator.GTE.asString(), from);
    }

    private String getRangeTo(Matcher matcher, boolean includePreRelease) {
        String preRelease;
        int toMajor = Utils.parseIntWithXSupport(matcher.group(8));
        int toMinor = Utils.parseIntWithXSupport(matcher.group(9));
        int toPatch = Utils.parseIntWithXSupport(matcher.group(10));
        String explicitPreRelease = matcher.group(11);
        String string = preRelease = includePreRelease ? "-0" : "";
        if (Utils.isX(toMinor)) {
            return String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.LT.asString(), toMajor + 1, preRelease);
        }
        if (Utils.isX(toPatch)) {
            return String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), toMajor, toMinor + 1, preRelease);
        }
        if (Utils.isNotBlank(explicitPreRelease)) {
            return String.format(Locale.ROOT, "%s%d.%d.%d%s", Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch, "-" + explicitPreRelease);
        }
        return String.format(Locale.ROOT, "%s%d.%d.%d%s", Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch + 1, preRelease);
    }
}

