/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.semver4j.internal.Tokenizers;
import org.semver4j.internal.Utils;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;

public class CaretProcessor
implements Processor {
    private static final Pattern PATTERN = Pattern.compile(Tokenizers.CARET);

    @Override
    public @Nullable String process(String range, boolean includePreRelease) {
        String preReleaseMarker;
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        int major = Utils.parseIntWithXSupport(matcher.group(1));
        int minor = Utils.parseIntWithXSupport(matcher.group(2));
        int patch = Utils.parseIntWithXSupport(matcher.group(3));
        String preRelease = matcher.group(4);
        String string = preReleaseMarker = includePreRelease ? "-0" : "";
        String from = Utils.isX(minor) ? String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.GTE.asString(), major, preReleaseMarker) : (Utils.isX(patch) ? String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.GTE.asString(), major, minor, preReleaseMarker) : (Utils.isNotBlank(preRelease) ? String.format(Locale.ROOT, "%s%d.%d.%d-%s", Range.RangeOperator.GTE.asString(), major, minor, patch, preRelease) : String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GTE.asString(), major, minor, patch)));
        String to = major > 0 ? String.format(Locale.ROOT, "%s%d.0.0%s", Range.RangeOperator.LT.asString(), major + 1, preReleaseMarker) : (minor > 0 ? String.format(Locale.ROOT, "%s%d.%d.0%s", Range.RangeOperator.LT.asString(), major, minor + 1, preReleaseMarker) : String.format(Locale.ROOT, "%s%d.%d.%d%s", Range.RangeOperator.LT.asString(), major, minor, patch + 1, preReleaseMarker));
        return String.format(Locale.ROOT, "%s %s", from, to);
    }
}

