/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.statements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.UpsertStatement;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.InsertBlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/statements/UpsertBlockingExecutable;", "Key", "", "Lorg/jetbrains/exposed/v1/jdbc/statements/InsertBlockingExecutable;", "Lorg/jetbrains/exposed/v1/core/statements/UpsertStatement;", "statement", "<init>", "(Lorg/jetbrains/exposed/v1/core/statements/UpsertStatement;)V", "getStatement", "()Lorg/jetbrains/exposed/v1/core/statements/UpsertStatement;", "prepared", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "sql", "", "exposed-jdbc"})
public class UpsertBlockingExecutable<Key>
extends InsertBlockingExecutable<Key, UpsertStatement<Key>> {
    @NotNull
    private final UpsertStatement<Key> statement;

    public UpsertBlockingExecutable(@NotNull UpsertStatement<Key> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        super((InsertStatement)statement);
        this.statement = statement;
    }

    @Override
    @NotNull
    public UpsertStatement<Key> getStatement() {
        return this.statement;
    }

    @Override
    @NotNull
    public JdbcPreparedStatementApi prepared(@NotNull JdbcTransaction transaction, @NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsOnlyIdentifiersInGeneratedKeys()) {
            return transaction.getConnection().prepareStatement(sql, true);
        }
        return super.prepared(transaction, sql);
    }
}

