/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.vendors.ForUpdateOption;
import org.jetbrains.exposed.v1.jdbc.Query;
import org.jetbrains.exposed.v1.jdbc.SizedIterable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0096\u0002J\b\u0010\u0013\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\b\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000\u0002H\u0016JG\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u000222\u0010\"\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020&0$0#\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030%\u0012\u0004\u0012\u00020&0$H\u0016\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/LazySizedCollection;", "T", "Lorg/jetbrains/exposed/v1/jdbc/SizedIterable;", "_delegate", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/SizedIterable;)V", "delegate", "_wrapper", "", "_size", "", "Ljava/lang/Long;", "_empty", "", "Ljava/lang/Boolean;", "wrapper", "getWrapper", "()Ljava/util/List;", "limit", "count", "", "offset", "start", "iterator", "", "empty", "forUpdate", "option", "Lorg/jetbrains/exposed/v1/core/vendors/ForUpdateOption;", "notForUpdate", "countInternal", "emptyInternal", "copy", "orderBy", "order", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/v1/core/Expression;", "Lorg/jetbrains/exposed/v1/core/SortOrder;", "([Lkotlin/Pair;)Lorg/jetbrains/exposed/v1/jdbc/SizedIterable;", "isLoaded", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nIterableEx.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IterableEx.kt\norg/jetbrains/exposed/v1/jdbc/LazySizedCollection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class LazySizedCollection<T>
implements SizedIterable<T> {
    @NotNull
    private SizedIterable<? extends T> delegate;
    @Nullable
    private List<? extends T> _wrapper;
    @Nullable
    private Long _size;
    @Nullable
    private Boolean _empty;

    public LazySizedCollection(@NotNull SizedIterable<? extends T> _delegate) {
        Intrinsics.checkNotNullParameter(_delegate, (String)"_delegate");
        this.delegate = _delegate;
    }

    @NotNull
    public final List<T> getWrapper() {
        if (this._wrapper == null) {
            this._wrapper = CollectionsKt.toList((Iterable)this.delegate);
        }
        List<? extends T> list = this._wrapper;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @NotNull
    public SizedIterable<T> limit(int count) {
        return new LazySizedCollection<T>(this.delegate.limit(count));
    }

    @Override
    @NotNull
    public SizedIterable<T> offset(long start) {
        return new LazySizedCollection<T>(this.delegate.offset(start));
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getWrapper().iterator();
    }

    @Override
    public long count() {
        List<T> list = this._wrapper;
        return list != null ? (long)list.size() : this.countInternal();
    }

    @Override
    public boolean empty() {
        List<T> list = this._wrapper;
        return list != null ? list.isEmpty() : this.emptyInternal();
    }

    @Override
    @NotNull
    public SizedIterable<T> forUpdate(@NotNull ForUpdateOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        SizedIterable<? extends T> localDelegate = this.delegate;
        if (this._wrapper != null && localDelegate instanceof Query && ((Query)localDelegate).hasCustomForUpdateState() && !((Query)localDelegate).isForUpdate()) {
            throw new IllegalStateException("Impossible to change forUpdate state for loaded data".toString());
        }
        if (this._wrapper == null) {
            this.delegate = this.delegate.forUpdate(option);
        }
        return this;
    }

    @Override
    @NotNull
    public SizedIterable<T> notForUpdate() {
        SizedIterable<? extends T> localDelegate = this.delegate;
        if (this._wrapper != null && localDelegate instanceof Query && ((Query)localDelegate).hasCustomForUpdateState() && ((Query)localDelegate).isForUpdate()) {
            throw new IllegalStateException("Impossible to change forUpdate state for loaded data".toString());
        }
        if (this._wrapper == null) {
            this.delegate = this.delegate.notForUpdate();
        }
        return this;
    }

    private final long countInternal() {
        if (this._size == null) {
            Long l = this._size = Long.valueOf(this.delegate.count());
            long l2 = 0L;
            this._empty = l != null && l == l2;
        }
        Long l = this._size;
        Intrinsics.checkNotNull((Object)l);
        return l;
    }

    private final boolean emptyInternal() {
        if (this._empty == null) {
            this._empty = this.delegate.empty();
            if (Intrinsics.areEqual((Object)this._empty, (Object)true)) {
                this._size = 0L;
            }
        }
        Boolean bl = this._empty;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @Override
    @NotNull
    public SizedIterable<T> copy() {
        return new LazySizedCollection<T>(this.delegate.copy());
    }

    @Override
    @NotNull
    public SizedIterable<T> orderBy(Pair<? extends Expression<?>, ? extends SortOrder> ... order) {
        Intrinsics.checkNotNullParameter(order, (String)"order");
        if (!(this._wrapper == null)) {
            boolean bl = false;
            String string = "Can't order already loaded data";
            throw new IllegalStateException(string.toString());
        }
        this.delegate = this.delegate.orderBy(Arrays.copyOf(order, order.length));
        return this;
    }

    public final boolean isLoaded() {
        return this._wrapper != null;
    }
}

