/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.AbstractQuery;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.v1.jdbc.Intersect;
import org.jetbrains.exposed.v1.jdbc.SetOperation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/Except;", "Lorg/jetbrains/exposed/v1/jdbc/SetOperation;", "firstStatement", "Lorg/jetbrains/exposed/v1/core/AbstractQuery;", "secondStatement", "<init>", "(Lorg/jetbrains/exposed/v1/core/AbstractQuery;Lorg/jetbrains/exposed/v1/core/AbstractQuery;)V", "operationName", "", "getOperationName", "()Ljava/lang/String;", "copy", "Lorg/jetbrains/exposed/v1/jdbc/Intersect;", "withDistinct", "value", "", "prepareStatementSQL", "", "builder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-jdbc"})
public final class Except
extends SetOperation {
    public Except(@NotNull AbstractQuery<?> firstStatement, @NotNull AbstractQuery<?> secondStatement) {
        Intrinsics.checkNotNullParameter(firstStatement, (String)"firstStatement");
        Intrinsics.checkNotNullParameter(secondStatement, (String)"secondStatement");
        super("EXCEPT", firstStatement, secondStatement, null);
    }

    @Override
    @NotNull
    public String getOperationName() {
        return DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect || H2Kt.getH2Mode((DatabaseDialect)DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "MINUS" : "EXCEPT";
    }

    @NotNull
    public Intersect copy() {
        Intersect intersect;
        Intersect it = intersect = new Intersect(this.getFirstStatement(), this.getSecondStatement());
        boolean bl = false;
        this.copyTo(it);
        return intersect;
    }

    @NotNull
    public SetOperation withDistinct(boolean value) {
        return this;
    }

    @Override
    protected void prepareStatementSQL(@NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect && !(DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect)) {
            throw new UnsupportedByDialectException(this.getOperationName() + " is unsupported", DatabaseDialectKt.getCurrentDialect());
        }
        super.prepareStatementSQL(builder);
    }
}

