/*
 * Decompiled with CFR 0.152.
 */
package zmodem.zm.io;

import java.io.IOException;
import java.io.InputStream;
import zmodem.xfer.io.ObjectInputStream;
import zmodem.xfer.util.ByteBuffer;
import zmodem.xfer.util.CRC;
import zmodem.xfer.zm.packet.Cancel;
import zmodem.xfer.zm.packet.DataPacket;
import zmodem.xfer.zm.packet.Finish;
import zmodem.xfer.zm.packet.Format;
import zmodem.xfer.zm.packet.Header;
import zmodem.xfer.zm.proto.Action;
import zmodem.xfer.zm.proto.Escape;
import zmodem.xfer.zm.util.ZMPacket;
import zmodem.xfer.zm.util.ZModemCharacter;

public class ZMPacketInputStream
extends ObjectInputStream<ZMPacket> {
    private final InputStream netIs;
    private CRC dataCRC = new CRC(CRC.Type.CRC16);
    private boolean gotFIN = false;
    private boolean acceptsHeader = true;

    public ZMPacketInputStream(InputStream is) {
        this.netIs = is;
    }

    private boolean ignored(int b) {
        return b == 17 || b == 19 || b == 145 || b == 147;
    }

    private byte implRead() throws IOException {
        int n;
        while (this.ignored(n = this.netIs.read())) {
        }
        if (n == -1) {
            throw new IOException("Closed");
        }
        return (byte)n;
    }

    @Override
    public ZMPacket read() throws IOException {
        ByteBuffer zbuff = ByteBuffer.allocate(10240);
        boolean doread = true;
        Action action2 = Action.ESCAPE;
        int beforeStop = -1;
        int countCan = 0;
        while (doread) {
            byte n = this.implRead();
            if (this.gotFIN && n == 79 && (n = this.implRead()) == 79) {
                return new Finish();
            }
            if (n == ZModemCharacter.ZDLE.value()) {
                n = (byte)this.netIs.read();
                countCan = n == ZModemCharacter.ZDLE.value() ? (countCan += 2) : 0;
                Escape escape = Escape.detect(n, this.acceptsHeader);
                if (escape.action() != Action.ESCAPE && beforeStop < 0) {
                    action2 = escape.action();
                    beforeStop = escape.action() == Action.DATA ? this.dataCRC.size() : escape.len();
                    this.dataCRC.update(n);
                } else {
                    n = Escape.escapeIt(n);
                }
            }
            zbuff.put(n);
            if (beforeStop < 0) {
                this.dataCRC.update(n);
            }
            if (beforeStop == 0) {
                doread = false;
            }
            if (beforeStop > 0) {
                --beforeStop;
            }
            if (countCan < 5) continue;
            doread = false;
            action2 = Action.CANCEL;
        }
        zbuff.flip();
        ZMPacket r = null;
        switch (action2) {
            case HEADER: {
                r = Header.unmarshall(zbuff);
                this.dataCRC = ((Header)r).format() == Format.BIN32 ? new CRC(CRC.Type.CRC32) : new CRC(CRC.Type.CRC16);
                if (((Header)r).type() == ZModemCharacter.ZFIN) {
                    this.gotFIN = true;
                }
                if (((Header)r).type() != ZModemCharacter.ZDATA && ((Header)r).type() != ZModemCharacter.ZFILE) break;
                this.acceptsHeader = false;
                break;
            }
            case DATA: {
                this.dataCRC.finalized();
                r = DataPacket.unmarshall(zbuff, this.dataCRC);
                this.dataCRC = new CRC(this.dataCRC.type());
                if (((DataPacket)r).type() == ZModemCharacter.ZCRCG) {
                    this.acceptsHeader = false;
                    break;
                }
                this.acceptsHeader = true;
                break;
            }
            case CANCEL: {
                r = new Cancel();
                this.dataCRC = new CRC(this.dataCRC.type());
            }
        }
        return r;
    }
}

