/*
 * Decompiled with CFR 0.152.
 */
package zmodem.xfer.zm.packet;

import zmodem.xfer.util.CRC;
import zmodem.xfer.zm.util.ZModemCharacter;

public enum Format {
    BIN32(1, CRC.Type.CRC32, ZModemCharacter.ZBIN32),
    BIN(1, CRC.Type.CRC16, ZModemCharacter.ZBIN),
    HEX(2, CRC.Type.CRC16, ZModemCharacter.ZHEX);

    private int width;
    private CRC.Type crc;
    private ZModemCharacter character;

    public static Format fromByte(byte b) {
        for (Format ft : Format.values()) {
            if (ft.character() != b) continue;
            return ft;
        }
        return null;
    }

    private Format(int bw, CRC.Type crct, ZModemCharacter fmt) {
        this.width = bw;
        this.crc = crct;
        this.character = fmt;
    }

    public CRC.Type crc() {
        return this.crc;
    }

    public byte character() {
        return this.character.value();
    }

    public int width() {
        return this.width;
    }

    public boolean hex() {
        return this == HEX;
    }
}

