/*
 * Decompiled with CFR 0.152.
 */
package app.termora.x11;

import app.termora.x11.ChannelX11;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.session.helpers.AbstractSessionIoHandler;
import org.apache.sshd.common.util.Readable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lapp/termora/x11/X11IoHandler;", "Lorg/apache/sshd/common/session/helpers/AbstractSessionIoHandler;", "x11", "Lapp/termora/x11/ChannelX11;", "<init>", "(Lapp/termora/x11/ChannelX11;)V", "out", "Ljava/io/OutputStream;", "kotlin.jvm.PlatformType", "getOut", "()Ljava/io/OutputStream;", "sessionClosed", "", "ioSession", "Lorg/apache/sshd/common/io/IoSession;", "messageReceived", "session", "message", "Lorg/apache/sshd/common/util/Readable;", "createSession", "Lorg/apache/sshd/common/session/helpers/AbstractSession;", "termora"})
public final class X11IoHandler
extends AbstractSessionIoHandler {
    @NotNull
    private final ChannelX11 x11;

    public X11IoHandler(@NotNull ChannelX11 x11) {
        Intrinsics.checkNotNullParameter((Object)((Object)x11), (String)"x11");
        this.x11 = x11;
    }

    private final OutputStream getOut() {
        return this.x11.getOut();
    }

    public void sessionClosed(@NotNull IoSession ioSession) {
        Intrinsics.checkNotNullParameter((Object)ioSession, (String)"ioSession");
        this.x11.close(true);
    }

    public void messageReceived(@NotNull IoSession session2, @NotNull Readable message) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        byte[] bytes = new byte[Math.min(8192, message.available())];
        if (bytes.length == 0) {
            return;
        }
        while (message.available() > 0) {
            int available = Math.min(message.available(), bytes.length);
            message.getRawBytes(bytes, 0, available);
            this.getOut().write(bytes, 0, available);
        }
        this.getOut().flush();
    }

    @NotNull
    protected AbstractSession createSession(@NotNull IoSession ioSession) {
        Intrinsics.checkNotNullParameter((Object)ioSession, (String)"ioSession");
        Session session2 = this.x11.getSession();
        Intrinsics.checkNotNull((Object)session2, (String)"null cannot be cast to non-null type org.apache.sshd.common.session.helpers.AbstractSession");
        return (AbstractSession)session2;
    }
}

