/*
 * Decompiled with CFR 0.152.
 */
package app.termora.x11;

import app.termora.x11.X11IoHandler;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientConnectionService;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000fH\u0014J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lapp/termora/x11/ChannelX11;", "Lorg/apache/sshd/client/channel/AbstractClientChannel;", "host", "", "port", "", "<init>", "(Ljava/lang/String;I)V", "x11", "Lorg/apache/sshd/common/io/IoSession;", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "open", "Lorg/apache/sshd/client/future/OpenFuture;", "recipient", "", "rwSize", "packetSize", "buffer", "Lorg/apache/sshd/common/util/buffer/Buffer;", "doOpen", "", "connectX11Server", "Lorg/apache/sshd/common/io/IoConnectFuture;", "doWriteData", "data", "", "off", "len", "handleEof", "unregisterSelf", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nChannelX11.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChannelX11.kt\napp/termora/x11/ChannelX11\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class ChannelX11
extends AbstractClientChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    private IoSession x11;
    @NotNull
    private final AtomicBoolean isInitialized;
    @NotNull
    private static final AttributeRepository.AttributeKey<byte[]> X11_COOKIE = new AttributeRepository.AttributeKey();
    @NotNull
    private static final AttributeRepository.AttributeKey<String> X11_COOKIE_HEX = new AttributeRepository.AttributeKey();

    public ChannelX11(@NotNull String host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super("x11");
        this.host = host;
        this.port = port;
        this.isInitialized = new AtomicBoolean(false);
    }

    @NotNull
    public OpenFuture open(long recipient, long rwSize, long packetSize, @NotNull Buffer buffer) {
        DefaultOpenFuture defaultOpenFuture;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        DefaultOpenFuture $this$open_u24lambda_u240 = defaultOpenFuture = new DefaultOpenFuture((Object)this, this.futureLock);
        boolean bl = false;
        this.openFuture = (OpenFuture)$this$open_u24lambda_u240;
        DefaultOpenFuture openFuture = defaultOpenFuture;
        this.connectX11Server().addListener(arg_0 -> ChannelX11.open$lambda$1(this, recipient, rwSize, packetSize, buffer, openFuture, arg_0));
        return (OpenFuture)openFuture;
    }

    protected void doOpen() {
        this.out = (OutputStream)new ChannelOutputStream((AbstractChannel)this, this.getRemoteWindow(), this.log, 94, true);
    }

    private final IoConnectFuture connectX11Server() {
        IoConnector connector = this.getSession().getFactoryManager().getIoServiceFactory().createConnector((IoHandler)new X11IoHandler(this));
        IoConnectFuture future2 = connector.connect((SocketAddress)new InetSocketAddress(this.host, this.port), (AttributeRepository)this.getSession(), null);
        this.addCloseFutureListener(arg_0 -> ChannelX11.connectX11Server$lambda$0(connector, arg_0));
        Intrinsics.checkNotNull((Object)future2);
        return future2;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doWriteData(@NotNull byte[] data, int off, long len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.isInitialized.compareAndSet(false, true)) {
            IoWriteFuture ioWriteFuture;
            byte[] byArray = (byte[])this.getSession().getAttribute(X11_COOKIE);
            if (byArray == null) {
                return;
            }
            byte[] cookie = byArray;
            byte[] foo = ArraysKt.copyOfRange((byte[])data, (int)off, (int)(off + (int)len));
            int s = 0;
            int l = foo.length;
            if (l < 9) {
                return;
            }
            int plen = (foo[s + 6] & 0xFF) * 256 + (foo[s + 7] & 0xFF);
            int dlen = (foo[s + 8] & 0xFF) * 256 + (foo[s + 9] & 0xFF);
            if ((foo[s] & 0xFF) == 108) {
                plen = plen >>> 8 & 0xFF | plen << 8 & 0xFF00;
                dlen = dlen >>> 8 & 0xFF | dlen << 8 & 0xFF00;
            }
            if (l < 12 + plen + (-plen & 3) + dlen) {
                return;
            }
            byte[] bar = new byte[dlen];
            System.arraycopy(foo, s + 12 + plen + (-plen & 3), bar, 0, dlen);
            if (Objects.deepEquals(cookie, bar)) {
                IoSession ioSession = this.x11;
                if (ioSession == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"x11");
                    ioSession = null;
                }
                if (ioSession.isOpen()) {
                    IoSession ioSession2 = this.x11;
                    if (ioSession2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"x11");
                        ioSession2 = null;
                    }
                    ioWriteFuture = ioSession2.writeBuffer((Buffer)new ByteArrayBuffer(foo, s, l));
                    return;
                }
            }
            ioWriteFuture = this.sendEof();
            return;
        }
        IoSession ioSession = this.x11;
        if (ioSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"x11");
            ioSession = null;
        }
        if (!ioSession.isOpen()) return;
        IoSession ioSession3 = this.x11;
        if (ioSession3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"x11");
            ioSession3 = null;
        }
        ioSession3.writeBuffer((Buffer)new ByteArrayBuffer(data, off, (int)len));
    }

    public void handleEof() {
        super.handleEof();
        this.close(true);
    }

    private final void unregisterSelf() {
        block2: {
            try {
                ((ClientConnectionService)this.getSession().getService(ClientConnectionService.class)).unregisterChannel((Channel)this);
                this.close(true);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block2;
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final void open$lambda$1(ChannelX11 this$0, long $recipient, long $rwSize, long $packetSize, Buffer $buffer, DefaultOpenFuture $openFuture, IoConnectFuture it) {
        if (it.isConnected()) {
            IoSession ioSession = it.getSession();
            Intrinsics.checkNotNullExpressionValue((Object)ioSession, (String)"getSession(...)");
            this$0.x11 = ioSession;
            this$0.handleOpenSuccess($recipient, $rwSize, $packetSize, $buffer);
        } else {
            if (it.getException() != null) {
                $openFuture.setException(it.getException());
            } else {
                $openFuture.setValue((Object)false);
            }
            this$0.unregisterSelf();
        }
    }

    private static final void connectX11Server$lambda$0(IoConnector $connector, CloseFuture it) {
        if (it.isClosed()) {
            $connector.close(true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lapp/termora/x11/ChannelX11$Companion;", "", "<init>", "()V", "X11_COOKIE", "Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "", "getX11_COOKIE", "()Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "X11_COOKIE_HEX", "", "getX11_COOKIE_HEX", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeRepository.AttributeKey<byte[]> getX11_COOKIE() {
            return X11_COOKIE;
        }

        @NotNull
        public final AttributeRepository.AttributeKey<String> getX11_COOKIE_HEX() {
            return X11_COOKIE_HEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

