/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tree;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.account.ServerSignedExtension;
import app.termora.account.Team;
import app.termora.database.DatabaseChangedExtension;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import app.termora.tree.HostTreeNode;
import app.termora.tree.SimpleTreeModel;
import app.termora.tree.SimpleTreeNode;
import app.termora.tree.TeamTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003 !\"B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u001d\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u001e\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0016H\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lapp/termora/tree/NewHostTreeModel;", "Lapp/termora/tree/SimpleTreeModel;", "Lapp/termora/Host;", "Lapp/termora/Disposable;", "<init>", "()V", "hostManager", "Lapp/termora/HostManager;", "getHostManager", "()Lapp/termora/HostManager;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "getRoot", "Lapp/termora/tree/HostTreeNode;", "reload", "", "parent", "Ljavax/swing/tree/TreeNode;", "insertNodeInto", "newChild", "Ljavax/swing/tree/MutableTreeNode;", "index", "", "flush", "", "nodeStructureChanged", "node", "removeNodeFromParent", "removeNodeFromParent0", "registerDynamicExtensions", "Companion", "MyDatabaseChangedExtension", "MyAccountAccountExtension", "termora"})
@SourceDebugExtension(value={"SMAP\nNewHostTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewHostTreeModel.kt\napp/termora/tree/NewHostTreeModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n774#2:251\n865#2,2:252\n808#2,11:254\n1#3:265\n*S KotlinDebug\n*F\n+ 1 NewHostTreeModel.kt\napp/termora/tree/NewHostTreeModel\n*L\n59#1:251\n59#1:252,2\n128#1:254,11\n*E\n"})
public final class NewHostTreeModel
extends SimpleTreeModel<Host>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private NewHostTreeModel() {
        super(new HostTreeNode(new Host(null, "\u6240\u6709\u4e3b\u673a", "Folder", null, 0, null, null, null, null, null, null, 0L, null, null, null, "User", false, 0L, 0L, 491513, null)));
        this.reload();
        this.registerDynamicExtensions();
    }

    private final HostManager getHostManager() {
        return HostManager.Companion.getInstance();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    @Override
    @NotNull
    public HostTreeNode getRoot() {
        Object object = super.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.tree.HostTreeNode");
        return (HostTreeNode)object;
    }

    @Override
    public void reload(@NotNull TreeNode parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!(parent instanceof HostTreeNode)) {
            super.reload(parent);
            return;
        }
        ((HostTreeNode)parent).removeAllChildren();
        Set<String> ownerIds = this.getAccountManager().getOwnerIds();
        Iterable $this$filter$iv = this.getHostManager().hosts();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : iterable) {
            Host it = (Host)element$iv$iv;
            boolean bl = false;
            if (!ownerIds.contains(it.getOwnerId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List hosts = (List)destination$iv$iv;
        LinkedHashMap nodes = new LinkedHashMap();
        if (Intrinsics.areEqual((Object)parent, (Object)this.getRoot())) {
            if (this.getAccountManager().hasTeamFeature()) {
                for (Team team : this.getAccountManager().getTeams()) {
                    ((Map)nodes).put(team.getId(), new TeamTreeNode(team));
                }
            }
            Map map = nodes;
            String string = this.getAccountManager().getAccountId();
            destination$iv$iv = I18n.INSTANCE.getString("termora.welcome.my-hosts");
            String $i$f$filterTo22 = this.getAccountManager().getAccountId();
            destination$iv$iv = new HostTreeNode(new Host("0", (String)destination$iv$iv, "Folder", null, 0, null, null, null, null, null, null, 0L, null, $i$f$filterTo22, null, "User", false, 0L, 0L, 483320, null));
            map.put(string, destination$iv$iv);
        }
        for (Host host : hosts) {
            HostTreeNode node2 = new HostTreeNode(host);
            ((Map)nodes).put(host.getId(), node2);
        }
        for (Host host : hosts) {
            HostTreeNode node2;
            HostTreeNode p;
            if ((HostTreeNode)nodes.get(host.getId()) == null || (p = Intrinsics.areEqual((Object)host.getParentId(), (Object)"0") || StringsKt.isBlank((CharSequence)host.getParentId()) ? (HostTreeNode)nodes.get(this.getAccountManager().getAccountId()) : (HostTreeNode)nodes.get(host.getParentId())) == null) continue;
            p.add(node2);
        }
        if (Intrinsics.areEqual((Object)parent, (Object)this.getRoot())) {
            if (this.getAccountManager().hasTeamFeature()) {
                for (Team team : this.getAccountManager().getTeams()) {
                    ((HostTreeNode)parent).add((MutableTreeNode)MapsKt.getValue((Map)nodes, (Object)team.getId()));
                }
            }
            ((HostTreeNode)parent).add((MutableTreeNode)MapsKt.getValue((Map)nodes, (Object)this.getAccountManager().getAccountId()));
        } else {
            for (Object object : nodes.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"next(...)");
                HostTreeNode hostTreeNode = (HostTreeNode)object;
                if (!Intrinsics.areEqual((Object)hostTreeNode.getHost().getParentId(), (Object)((HostTreeNode)parent).getId())) continue;
                ((HostTreeNode)parent).add(hostTreeNode);
            }
        }
        super.reload(parent);
    }

    @Override
    public void insertNodeInto(@NotNull MutableTreeNode newChild, @NotNull MutableTreeNode parent, int index) {
        Intrinsics.checkNotNullParameter((Object)newChild, (String)"newChild");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.insertNodeInto(newChild, parent, index, true);
    }

    /*
     * WARNING - void declaration
     */
    private final void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index, boolean flush) {
        super.insertNodeInto(newChild, parent, Math.min(index, parent.getChildCount()));
        if (!flush) {
            return;
        }
        if (newChild instanceof HostTreeNode) {
            HostManager.addHost$default(this.getHostManager(), ((HostTreeNode)newChild).getHost(), null, 2, null);
        }
        if (parent instanceof HostTreeNode) {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Enumeration<TreeNode> enumeration = ((HostTreeNode)parent).children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
            ArrayList<TreeNode> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable iterable = arrayList;
            boolean $i$f$filterIsInstance = false;
            void var8_8 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof HostTreeNode)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv)).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                HostTreeNode c = (HostTreeNode)iterator2.next();
                long sort = i;
                if (c.getHost().getSort() == sort) continue;
                c.setHost(Host.copy$default(c.getHost(), null, null, null, null, 0, null, null, null, null, null, null, sort, null, null, null, null, false, 0L, 0L, 522239, null));
                HostManager.addHost$default(this.getHostManager(), c.getHost(), null, 2, null);
            }
        }
    }

    @Override
    public void nodeStructureChanged(@Nullable TreeNode node2) {
        if (node2 instanceof HostTreeNode) {
            HostManager.addHost$default(this.getHostManager(), ((HostTreeNode)node2).getHost(), null, 2, null);
        }
        super.nodeStructureChanged(node2);
    }

    @Override
    public void removeNodeFromParent(@Nullable MutableTreeNode node2) {
        if (node2 instanceof SimpleTreeNode) {
            for (SimpleTreeNode e : ((SimpleTreeNode)node2).getAllChildren()) {
                this.getHostManager().removeHost(e.getId());
            }
            this.getHostManager().removeHost(((SimpleTreeNode)node2).getId());
        }
        this.removeNodeFromParent0(node2);
    }

    private final void removeNodeFromParent0(MutableTreeNode node2) {
        super.removeNodeFromParent(node2);
    }

    private final void registerDynamicExtensions() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(DatabaseChangedExtension.class, (Extension)new MyDatabaseChangedExtension());
        boolean bl = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new MyAccountAccountExtension());
        boolean bl2 = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(ServerSignedExtension.class, (Extension)new ServerSignedExtension(this){
            final /* synthetic */ NewHostTreeModel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSignedChanged(boolean oldSigned, boolean newSigned) {
                this.this$0.reload(this.this$0.getRoot());
            }
        });
        boolean bl3 = false;
        Disposer.register(this, it);
    }

    public /* synthetic */ NewHostTreeModel(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/tree/NewHostTreeModel$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/tree/NewHostTreeModel;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewHostTreeModel getInstance() {
            return (NewHostTreeModel)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(NewHostTreeModel.class), Companion::getInstance$lambda$0);
        }

        private static final NewHostTreeModel getInstance$lambda$0() {
            return new NewHostTreeModel(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lapp/termora/tree/NewHostTreeModel$MyAccountAccountExtension;", "Lapp/termora/account/AccountExtension;", "<init>", "(Lapp/termora/tree/NewHostTreeModel;)V", "onAccountChanged", "", "oldAccount", "Lapp/termora/account/Account;", "newAccount", "termora"})
    @SourceDebugExtension(value={"SMAP\nNewHostTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewHostTreeModel.kt\napp/termora/tree/NewHostTreeModel$MyAccountAccountExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,250:1\n808#2,11:251\n1869#2,2:262\n*S KotlinDebug\n*F\n+ 1 NewHostTreeModel.kt\napp/termora/tree/NewHostTreeModel$MyAccountAccountExtension\n*L\n242#1:251,11\n243#1:262,2\n*E\n"})
    private final class MyAccountAccountExtension
    implements AccountExtension {
        /*
         * WARNING - void declaration
         */
        @Override
        public void onAccountChanged(@NotNull Account oldAccount, @NotNull Account newAccount) {
            Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
            Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
            if (!Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId())) {
                NewHostTreeModel.this.reload(NewHostTreeModel.this.getRoot());
            } else if (!Intrinsics.areEqual(oldAccount.getTeams(), newAccount.getTeams())) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Enumeration<TreeNode> enumeration = NewHostTreeModel.this.getRoot().children();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
                ArrayList<TreeNode> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                Iterable iterable = arrayList;
                boolean $i$f$filterIsInstance = false;
                void var6_6 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof TeamTreeNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List nodes = (List)destination$iv$iv;
                $this$filterIsInstance$iv = nodes;
                NewHostTreeModel newHostTreeModel = NewHostTreeModel.this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TeamTreeNode it = (TeamTreeNode)element$iv;
                    boolean bl = false;
                    newHostTreeModel.removeNodeFromParent0(it);
                }
                NewHostTreeModel.this.reload(NewHostTreeModel.this.getRoot());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lapp/termora/tree/NewHostTreeModel$MyDatabaseChangedExtension;", "Lapp/termora/database/DatabaseChangedExtension;", "<init>", "(Lapp/termora/tree/NewHostTreeModel;)V", "onDataChanged", "", "id", "", "type", "action", "Lapp/termora/database/DatabaseChangedExtension$Action;", "source", "Lapp/termora/database/DatabaseChangedExtension$Source;", "syncUserObject", "termora"})
    private final class MyDatabaseChangedExtension
    implements DatabaseChangedExtension {
        @Override
        public void onDataChanged(@NotNull String id, @NotNull String type, @NotNull DatabaseChangedExtension.Action action2, @NotNull DatabaseChangedExtension.Source source) {
            block8: {
                block10: {
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
                        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
                        if (Intrinsics.areEqual((Object)type, (Object)"Host") && !StringsKt.isBlank((CharSequence)id)) {
                            this.syncUserObject(id);
                        }
                        if (StringsKt.isBlank((CharSequence)id) || source != DatabaseChangedExtension.Source.Sync) {
                            return;
                        }
                        if (!StringsKt.isBlank((CharSequence)type) && !Intrinsics.areEqual((Object)type, (Object)"Host")) {
                            return;
                        }
                        if (action2 != DatabaseChangedExtension.Action.Added) break block9;
                        Host host = NewHostTreeModel.this.getHostManager().getHost(id);
                        if (host == null) {
                            return;
                        }
                        Host host2 = host;
                        for (HostTreeNode node2 : NewHostTreeModel.this.getRoot().getAllChildren()) {
                            if (!Intrinsics.areEqual((Object)node2.getId(), (Object)host2.getParentId())) continue;
                            NewHostTreeModel.this.insertNodeInto(new HostTreeNode(host2), node2, host2.isFolder() ? node2.getFolderCount() : node2.getChildCount(), false);
                            if (node2.isFolder()) {
                                NewHostTreeModel.this.reload(node2);
                            }
                            return;
                        }
                        break block8;
                    }
                    if (action2 != DatabaseChangedExtension.Action.Removed) break block10;
                    for (HostTreeNode node3 : NewHostTreeModel.this.getRoot().getAllChildren()) {
                        if (!Intrinsics.areEqual((Object)node3.getId(), (Object)id)) continue;
                        NewHostTreeModel.this.removeNodeFromParent(node3);
                        return;
                    }
                    break block8;
                }
                if (action2 != DatabaseChangedExtension.Action.Changed) break block8;
                for (HostTreeNode node4 : NewHostTreeModel.this.getRoot().getAllChildren()) {
                    if (!Intrinsics.areEqual((Object)node4.getId(), (Object)id)) continue;
                    HostTreeNode hostTreeNode = node4.getParent();
                    if (hostTreeNode == null) break;
                    NewHostTreeModel.this.reload(hostTreeNode);
                    break;
                }
            }
        }

        private final void syncUserObject(String id) {
            for (HostTreeNode node2 : NewHostTreeModel.this.getRoot().getAllChildren()) {
                if (!Intrinsics.areEqual((Object)node2.getId(), (Object)id)) continue;
                Host host = NewHostTreeModel.this.getHostManager().getHost(id);
                if (host == null) {
                    return;
                }
                Host host2 = host;
                node2.setHost(host2);
                return;
            }
        }
    }
}

