/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tree;

import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Host;
import app.termora.I18n;
import app.termora.database.DatabaseManager;
import app.termora.tree.Filter;
import app.termora.tree.FilterableTreeModel;
import app.termora.tree.HostTreeNode;
import app.termora.tree.NewHostTree;
import app.termora.tree.SimpleTreeNode;
import app.termora.tree.TreeUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001aH\u0014J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eR \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lapp/termora/tree/NewHostTreeDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "filter", "Lapp/termora/tree/Filter;", "<init>", "(Ljava/awt/Window;Lapp/termora/tree/Filter;)V", "hosts", "", "Lapp/termora/Host;", "getHosts", "()Ljava/util/List;", "setHosts", "(Ljava/util/List;)V", "allowMulti", "", "getAllowMulti", "()Z", "setAllowMulti", "(Z)V", "tree", "Lapp/termora/tree/NewHostTree;", "createCenterPanel", "Ljavax/swing/JComponent;", "doCancelAction", "", "doOKAction", "setTreeName", "treeName", "", "termora"})
@SourceDebugExtension(value={"SMAP\nNewHostTreeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewHostTreeDialog.kt\napp/termora/tree/NewHostTreeDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1563#2:101\n1634#2,3:102\n*S KotlinDebug\n*F\n+ 1 NewHostTreeDialog.kt\napp/termora/tree/NewHostTreeDialog\n*L\n78#1:101\n78#1:102,3\n*E\n"})
public final class NewHostTreeDialog
extends DialogWrapper {
    @NotNull
    private List<Host> hosts;
    private boolean allowMulti;
    @NotNull
    private final NewHostTree tree;

    public NewHostTreeDialog(@NotNull Window owner, @NotNull Filter filter) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        super(owner);
        this.hosts = CollectionsKt.emptyList();
        this.allowMulti = true;
        this.tree = new NewHostTree();
        this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 250, UIManager.getInt("Dialog.height") - 150));
        this.setModal(true);
        this.setResizable(false);
        this.setControlsVisible(false);
        this.setTitle(I18n.INSTANCE.getString("termora.transport.sftp.select-host"));
        this.tree.setContextmenu(false);
        this.tree.setDoubleClickConnection(false);
        this.tree.setDragEnabled(false);
        this.tree.setShowsRootHandles(true);
        FilterableTreeModel model2 = new FilterableTreeModel((JTree)((Object)this.tree));
        model2.addFilter(filter);
        this.tree.setModel(model2);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    SimpleTreeNode<?> simpleTreeNode = tree.getLastSelectedPathNode();
                    if (simpleTreeNode == null) {
                        return;
                    }
                    SimpleTreeNode<?> node2 = simpleTreeNode;
                    if (node2.isFolder()) {
                        return;
                    }
                    this.doOKAction();
                }
            }
        });
        Disposer.register(this.getDisposable(), this.tree);
        Disposer.register(this.tree, model2);
        this.init();
        this.setLocationRelativeTo(owner);
    }

    public /* synthetic */ NewHostTreeDialog(Window window, Filter filter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            filter = new Filter(){

                @Override
                public boolean filter(Object node2) {
                    Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                    return true;
                }
            };
        }
        this(window, filter);
    }

    @NotNull
    public final List<Host> getHosts() {
        return this.hosts;
    }

    public final void setHosts(@NotNull List<Host> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.hosts = list;
    }

    public final boolean getAllowMulti() {
        return this.allowMulti;
    }

    public final void setAllowMulti(boolean bl) {
        this.allowMulti = bl;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JScrollPane scrollPane = new JScrollPane((Component)((Object)this.tree));
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()), BorderFactory.createEmptyBorder(4, 6, 4, 6)));
        return scrollPane;
    }

    @Override
    protected void doCancelAction() {
        this.hosts = CollectionsKt.emptyList();
        super.doCancelAction();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doOKAction() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.tree.getSelectionSimpleTreeNodes(true);
        NewHostTreeDialog newHostTreeDialog = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HostTreeNode hostTreeNode = (HostTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getHost());
        }
        newHostTreeDialog.hosts = (List)destination$iv$iv;
        if (this.hosts.isEmpty()) {
            return;
        }
        if (!this.allowMulti && this.hosts.size() > 1) {
            return;
        }
        super.doOKAction();
    }

    public final void setTreeName(@NotNull String treeName) {
        Intrinsics.checkNotNullParameter((Object)treeName, (String)"treeName");
        Disposer.register(this.getDisposable(), new Disposable(treeName, this){
            private final String key;
            final /* synthetic */ NewHostTreeDialog this$0;
            {
                this.this$0 = $receiver;
                this.key = $treeName + ".state";
                TreeUtils.INSTANCE.loadExpansionState((JTree)((Object)NewHostTreeDialog.access$getTree$p($receiver)), this.getProperties().getString(this.key, ""));
            }

            private final DatabaseManager.Properties getProperties() {
                return DatabaseManager.Companion.getInstance().getProperties();
            }

            public void dispose() {
                this.getProperties().putString(this.key, TreeUtils.INSTANCE.saveExpansionState((JTree)((Object)NewHostTreeDialog.access$getTree$p(this.this$0))));
            }
        });
    }
}

