/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tree;

import app.termora.Disposable;
import app.termora.DocumentAdaptor;
import app.termora.tree.Filter;
import app.termora.tree.SimpleTreeNode;
import com.formdev.flatlaf.extras.components.FlatTextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FilterableTreeModel
implements TreeModel,
Disposable {
    private final TreeModel originalModel;
    private final EventListenerList eventListener = new EventListenerList();
    private Filter[] filters = new Filter[0];
    private final TreeModelListener originalModelListener = new TreeModelListener(){

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            FilterableTreeModel.this.rebuildAndNotify(e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            FilterableTreeModel.this.rebuildAndNotify(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            FilterableTreeModel.this.rebuildAndNotify(e);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            FilterableTreeModel.this.rebuildAndNotify(e);
        }
    };
    private final Map<Object, FilterNode> filteredTree = new LinkedHashMap<Object, FilterNode>();
    private final JTree tree;
    public final FlatTextField filterableTextField = new FlatTextField();
    public boolean expand = false;

    public FilterableTreeModel(JTree tree) {
        this.tree = tree;
        this.originalModel = tree.getModel();
        this.originalModel.addTreeModelListener(this.originalModelListener);
        this.filterableTextField.getDocument().addDocumentListener(new DocumentAdaptor(){

            @Override
            public void changedUpdate(@NotNull DocumentEvent e) {
                FilterableTreeModel.this.rebuildAndNotify(null);
            }
        });
        this.rebuildFilteredTree();
    }

    @Override
    public Object getRoot() {
        return this.originalModel.getRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getFilteredChildren(parent)[index];
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getFilteredChildren(parent).length;
    }

    @Override
    public boolean isLeaf(Object node2) {
        if (this.originalModel.isLeaf(node2)) {
            return true;
        }
        return this.getFilteredChildren(node2).length == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return ArrayUtils.indexOf((Object[])this.getFilteredChildren(parent), (Object)child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.eventListener.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.eventListener.remove(TreeModelListener.class, l);
    }

    private void rebuildAndNotify(TreeModelEvent event) {
        this.rebuildFilteredTree();
        this.notifyTreeStructureChanged(event);
        if (this.expand && Arrays.stream(this.filters).anyMatch(Filter::canFilter)) {
            this.expandAllNodes(this.tree, this.getRoot(), new TreePath(this.getRoot()));
        }
    }

    private void expandAllNodes(JTree tree, Object node2, TreePath path) {
        Object[] children;
        tree.expandPath(path);
        for (Object child : children = this.getFilteredChildren(node2)) {
            if (this.isLeaf(child)) continue;
            TreePath childPath = path.pathByAddingChild(child);
            this.expandAllNodes(tree, child, childPath);
        }
    }

    private void rebuildFilteredTree() {
        this.filteredTree.clear();
        this.buildFilteredTree(this.getRoot(), null);
    }

    private void buildFilteredTree(Object node2, Object parent) {
        ArrayList<Object> filteredChildren = new ArrayList<Object>();
        int originalChildCount = this.originalModel.getChildCount(node2);
        for (int i = 0; i < originalChildCount; ++i) {
            Object child = this.originalModel.getChild(node2, i);
            if (this.originalModel.isLeaf(child)) {
                if (!this.passesFilter(child)) continue;
                filteredChildren.add(child);
                continue;
            }
            this.buildFilteredTree(child, node2);
            FilterNode childFilterNode = this.filteredTree.get(child);
            if ((childFilterNode == null || childFilterNode.children().length <= 0) && !this.passesFilter(child)) continue;
            filteredChildren.add(child);
        }
        this.filteredTree.put(node2, new FilterNode(node2, parent, filteredChildren.toArray(), this.passesFilter(node2)));
    }

    private boolean passesFilter(Object node2) {
        return Arrays.stream(this.filters).allMatch(filter -> !filter.canFilter() || filter.filter(node2));
    }

    private Object[] getFilteredChildren(Object parent) {
        FilterNode filterNode = this.filteredTree.get(parent);
        if (filterNode == null) {
            return new Object[0];
        }
        return filterNode.children();
    }

    private void notifyTreeStructureChanged(TreeModelEvent event) {
        TreeModelListener[] listeners = (TreeModelListener[])this.eventListener.getListeners(TreeModelListener.class);
        if (listeners.length > 0) {
            TreePath treePath;
            Object lastPathComponent;
            Object[] objectArray;
            if (event == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getRoot();
            } else {
                objectArray = event.getPath();
            }
            TreeModelEvent evt = new TreeModelEvent((Object)this, objectArray);
            for (TreeModelListener listener2 : listeners) {
                listener2.treeStructureChanged(evt);
            }
            if (event != null && (lastPathComponent = (treePath = event.getTreePath()).getLastPathComponent()) instanceof SimpleTreeNode) {
                SimpleTreeNode c = (SimpleTreeNode)lastPathComponent;
                TreeNode parent = c.getParent();
                if (StringUtils.equals((CharSequence)"0", (CharSequence)c.getId()) || parent != null && StringUtils.equals((CharSequence)"0", (CharSequence)((SimpleTreeNode)parent).getId())) {
                    SwingUtilities.invokeLater(() -> SwingUtilities.updateComponentTreeUI(this.tree));
                }
            }
        }
    }

    public void addFilter(Filter filter) {
        this.filters = (Filter[])ArrayUtils.add((Object[])this.filters, (Object)filter);
        this.rebuildAndNotify(null);
    }

    public void removeFilter(Filter filter) {
        this.filters = (Filter[])ArrayUtils.removeElement((Object[])this.filters, (Object)filter);
        this.rebuildAndNotify(null);
    }

    public void filter() {
        this.rebuildAndNotify(null);
    }

    public void clearFilters() {
        this.filters = new Filter[0];
        this.rebuildAndNotify(null);
    }

    @Override
    public void dispose() {
        this.filters = new Filter[0];
        this.filteredTree.clear();
        this.originalModel.removeTreeModelListener(this.originalModelListener);
    }

    private record FilterNode(Object node, Object parent, Object[] children, boolean matched) {
    }
}

