/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer.s3;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/termora/transfer/s3/S3ReadSeekableByteChannel;", "Ljava/nio/channels/SeekableByteChannel;", "input", "Ljava/io/InputStream;", "size", "", "<init>", "(Ljava/io/InputStream;J)V", "channel", "Ljava/nio/channels/ReadableByteChannel;", "kotlin.jvm.PlatformType", "position", "read", "", "dst", "Ljava/nio/ByteBuffer;", "write", "src", "newPosition", "truncate", "isOpen", "", "close", "", "termora"})
public class S3ReadSeekableByteChannel
implements SeekableByteChannel {
    private final long size;
    private final ReadableByteChannel channel;
    private long position;

    public S3ReadSeekableByteChannel(@NotNull InputStream input2, long size) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        this.size = size;
        this.channel = Channels.newChannel(input2);
    }

    @Override
    public int read(@NotNull ByteBuffer dst) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        int bytesRead = this.channel.read(dst);
        if (bytesRead > 0) {
            this.position += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public int write(@NotNull ByteBuffer src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        throw new UnsupportedOperationException("Read-only channel");
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    @NotNull
    public SeekableByteChannel position(long newPosition) {
        throw new UnsupportedOperationException("Seek not supported in streaming read");
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    @NotNull
    public SeekableByteChannel truncate(long size) {
        throw new UnsupportedOperationException("Read-only channel");
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.channel);
    }
}

