/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer.internal.sftp;

import app.termora.Host;
import app.termora.plugin.internal.ssh.SshClients;
import app.termora.protocol.PathHandler;
import app.termora.protocol.PathHandlerRequest;
import app.termora.protocol.TransferProtocolProvider;
import app.termora.transfer.internal.sftp.SFTPPathHandler;
import java.awt.Window;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.SftpModuleProperties;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/transfer/internal/sftp/SFTPTransferProtocolProvider;", "Lapp/termora/protocol/TransferProtocolProvider;", "<init>", "()V", "isTransient", "", "getProtocol", "", "createPathHandler", "Lapp/termora/protocol/PathHandler;", "requester", "Lapp/termora/protocol/PathHandlerRequest;", "Companion", "termora"})
public final class SFTPTransferProtocolProvider
implements TransferProtocolProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<SFTPTransferProtocolProvider> instance$delegate = LazyKt.lazy(SFTPTransferProtocolProvider::instance_delegate$lambda$0);
    @NotNull
    public static final String PROTOCOL = "sftp";

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    @NotNull
    public PathHandler createPathHandler(@NotNull PathHandlerRequest requester) {
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        SshClient client = null;
        Ref.ObjectRef session2 = new Ref.ObjectRef();
        try {
            Window owner = requester.getOwner();
            client = owner == null ? SshClients.INSTANCE.openClient(requester.getHost()) : SshClients.INSTANCE.openClient(requester.getHost(), owner);
            session2.element = SshClients.INSTANCE.openSession(requester.getHost(), client);
            CoreModuleProperties.IO_CONNECT_TIMEOUT.get((PropertyResolver)client).ifPresent(arg_0 -> SFTPTransferProtocolProvider.createPathHandler$lambda$1(arg_0 -> SFTPTransferProtocolProvider.createPathHandler$lambda$0(session2, arg_0), arg_0));
            SftpFileSystem fileSystem = SftpClientFactory.instance().createSftpFileSystem((ClientSession)session2.element);
            Host host = requester.getHost();
            SftpPath path = fileSystem.getDefaultDir();
            String defaultDirectory = host.getOptions().getSftpDefaultDirectory();
            if (StringUtils.isNotBlank((CharSequence)defaultDirectory)) {
                path = (SftpPath)fileSystem.getPath(defaultDirectory, new String[0]);
            }
            Intrinsics.checkNotNull((Object)fileSystem);
            FileSystem fileSystem2 = (FileSystem)fileSystem;
            SftpPath sftpPath = path;
            Intrinsics.checkNotNull((Object)sftpPath);
            return new SFTPPathHandler(fileSystem2, (Path)sftpPath, client, (ClientSession)session2.element);
        }
        catch (Exception e) {
            IOUtils.closeQuietly((Closeable)((Closeable)session2.element));
            IOUtils.closeQuietly((Closeable)((Closeable)client));
            throw e;
        }
    }

    private static final Unit createPathHandler$lambda$0(Ref.ObjectRef $session, Duration e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        SftpModuleProperties.SFTP_CHANNEL_OPEN_TIMEOUT.set((PropertyResolver)$session.element, (Object)e);
        return Unit.INSTANCE;
    }

    private static final void createPathHandler$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final SFTPTransferProtocolProvider instance_delegate$lambda$0() {
        return new SFTPTransferProtocolProvider();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/transfer/internal/sftp/SFTPTransferProtocolProvider$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/transfer/internal/sftp/SFTPTransferProtocolProvider;", "getInstance", "()Lapp/termora/transfer/internal/sftp/SFTPTransferProtocolProvider;", "instance$delegate", "Lkotlin/Lazy;", "PROTOCOL", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SFTPTransferProtocolProvider getInstance() {
            Lazy lazy = instance$delegate;
            return (SFTPTransferProtocolProvider)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

