/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer.internal.sftp;

import app.termora.CryptoKt;
import app.termora.I18n;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferIndeterminate;
import app.termora.transfer.TransferListener;
import app.termora.transfer.TransferManager;
import app.termora.transfer.TransferTreeTableNode;
import app.termora.transfer.TransportContextMenuExtension;
import app.termora.transfer.TransportPanel;
import app.termora.transfer.TransportPopupMenu;
import app.termora.transfer.TransportTableModel;
import app.termora.transfer.TransportViewer;
import app.termora.transfer.internal.sftp.CompressMode;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.common.file.util.MockPath;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rH\u0016J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001c"}, d2={"Lapp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension;", "Lapp/termora/transfer/TransportContextMenuExtension;", "<init>", "()V", "createJMenuItem", "Ljavax/swing/JMenuItem;", "window", "Ljava/awt/Window;", "fileSystem", "Ljava/nio/file/FileSystem;", "popupMenu", "Lapp/termora/transfer/TransportPopupMenu;", "files", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lapp/termora/transfer/TransportTableModel$Attributes;", "compress", "", "event", "Lapp/termora/actions/AnActionEvent;", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "mode", "Lapp/termora/transfer/internal/sftp/CompressMode;", "ordered", "", "Companion", "CompressTransfer", "termora"})
@SourceDebugExtension(value={"SMAP\nCompressTransportContextMenuExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressTransportContextMenuExtension.kt\napp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1761#2,3:154\n*S KotlinDebug\n*F\n+ 1 CompressTransportContextMenuExtension.kt\napp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension\n*L\n32#1:154,3\n*E\n"})
public final class CompressTransportContextMenuExtension
implements TransportContextMenuExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CompressTransportContextMenuExtension instance = new CompressTransportContextMenuExtension();

    private CompressTransportContextMenuExtension() {
    }

    @Override
    @NotNull
    public JMenuItem createJMenuItem(@NotNull Window window, @Nullable FileSystem fileSystem, @NotNull TransportPopupMenu popupMenu, @NotNull List<? extends Pair<? extends Path, TransportTableModel.Attributes>> files) {
        boolean hasParent;
        block6: {
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            Intrinsics.checkNotNullParameter((Object)((Object)popupMenu), (String)"popupMenu");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            if (files.isEmpty() || !(fileSystem instanceof SftpFileSystem)) {
                throw new UnsupportedOperationException();
            }
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!((TransportTableModel.Attributes)it.getSecond()).isParent()) continue;
                    v0 = true;
                    break block6;
                }
                v0 = hasParent = false;
            }
        }
        if (hasParent) {
            throw new UnsupportedOperationException();
        }
        JMenu compressMenu = new JMenu(I18n.INSTANCE.getString("termora.transport.table.contextmenu.compress"));
        for (CompressMode mode : CompressMode.getEntries()) {
            compressMenu.add(mode.getExtension()).addActionListener((ActionListener)((Object)new AnAction(this, fileSystem, mode, files){
                final /* synthetic */ CompressTransportContextMenuExtension this$0;
                final /* synthetic */ FileSystem $fileSystem;
                final /* synthetic */ CompressMode $mode;
                final /* synthetic */ List<Pair<Path, TransportTableModel.Attributes>> $files;
                {
                    this.this$0 = $receiver;
                    this.$fileSystem = $fileSystem;
                    this.$mode = $mode;
                    this.$files = $files;
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    CompressTransportContextMenuExtension.access$compress(this.this$0, evt, (SftpFileSystem)this.$fileSystem, this.$mode, this.$files);
                }
            }));
        }
        return compressMenu;
    }

    private final void compress(AnActionEvent event, SftpFileSystem fileSystem, CompressMode mode, List<? extends Pair<? extends Path, TransportTableModel.Attributes>> files) {
        String string;
        Path workdir;
        TransferManager transferManager = event.getData(TransportViewer.Companion.getMyTransferManager());
        if (transferManager == null) {
            return;
        }
        TransferManager transferManager2 = transferManager;
        Path file = (Path)((Pair)CollectionsKt.first(files)).getFirst();
        Path path = file.getParent();
        if (path == null) {
            path = workdir = file.getFileSystem().getPath(file.getFileSystem().getSeparator(), new String[0]);
        }
        if (files.size() > 1) {
            Intrinsics.checkNotNull((Object)workdir);
            string = PathsKt.getName((Path)workdir);
        } else {
            string = PathsKt.getName((Path)file);
        }
        String name = (String)StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)"compress");
        Path target = workdir.resolve(name + "." + mode.getExtension());
        Intrinsics.checkNotNull((Object)workdir);
        Intrinsics.checkNotNull((Object)target);
        CompressTransfer myTransfer = new CompressTransfer(fileSystem, mode, files, workdir, target);
        if (!transferManager2.addTransfer(myTransfer)) {
            return;
        }
        TransportPanel transportPanel2 = event.getData(TransportPanel.Companion.getMyTransportPanel());
        if (transportPanel2 == null) {
            return;
        }
        TransportPanel panel2 = transportPanel2;
        transferManager2.addTransferListener(new TransferListener(myTransfer, transferManager2, panel2, target){
            final /* synthetic */ CompressTransfer $myTransfer;
            final /* synthetic */ TransferManager $transferManager;
            final /* synthetic */ TransportPanel $panel;
            final /* synthetic */ Path $target;
            {
                this.$myTransfer = $myTransfer;
                this.$transferManager = $transferManager;
                this.$panel = $panel;
                this.$target = $target;
            }

            public void onTransferChanged(Transfer transfer2, TransferTreeTableNode.State state) {
                Intrinsics.checkNotNullParameter((Object)transfer2, (String)"transfer");
                Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
                if (!Intrinsics.areEqual((Object)transfer2.id(), (Object)this.$myTransfer.id())) {
                    return;
                }
                if (state == TransferTreeTableNode.State.Done || state == TransferTreeTableNode.State.Failed) {
                    this.$transferManager.removeTransferListener(this);
                    if (state == TransferTreeTableNode.State.Done) {
                        Path path = this.$target;
                        Intrinsics.checkNotNull((Object)path);
                        this.$panel.registerSelectRow(PathsKt.getName((Path)path));
                    }
                }
            }
        });
    }

    @Override
    public long ordered() {
        return 1L;
    }

    public static final /* synthetic */ void access$compress(CompressTransportContextMenuExtension $this, AnActionEvent event, SftpFileSystem fileSystem, CompressMode mode, List files) {
        $this.compress(event, fileSystem, mode, files);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension;", "getInstance", "()Lapp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CompressTransportContextMenuExtension getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\b\u0010!\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lapp/termora/transfer/internal/sftp/CompressTransportContextMenuExtension$CompressTransfer;", "Lapp/termora/transfer/Transfer;", "Lapp/termora/transfer/TransferIndeterminate;", "fileSystem", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "mode", "Lapp/termora/transfer/internal/sftp/CompressMode;", "files", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lapp/termora/transfer/TransportTableModel$Attributes;", "workdir", "target", "<init>", "(Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;Lapp/termora/transfer/internal/sftp/CompressMode;Ljava/util/List;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "myID", "", "end", "", "mySource", "transfer", "", "bufferSize", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "source", "size", "isDirectory", "priority", "Lapp/termora/transfer/Transfer$Priority;", "scanning", "id", "parentId", "termora"})
    private static final class CompressTransfer
    implements Transfer,
    TransferIndeterminate {
        @NotNull
        private final SftpFileSystem fileSystem;
        @NotNull
        private final CompressMode mode;
        @NotNull
        private final List<Pair<Path, TransportTableModel.Attributes>> files;
        @NotNull
        private final Path workdir;
        @NotNull
        private final Path target;
        @NotNull
        private final String myID;
        private boolean end;
        @NotNull
        private final Path mySource;

        public CompressTransfer(@NotNull SftpFileSystem fileSystem, @NotNull CompressMode mode, @NotNull List<? extends Pair<? extends Path, TransportTableModel.Attributes>> files, @NotNull Path workdir, @NotNull Path target) {
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Intrinsics.checkNotNullParameter((Object)workdir, (String)"workdir");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.fileSystem = fileSystem;
            this.mode = mode;
            this.files = files;
            this.workdir = workdir;
            this.target = target;
            this.myID = CryptoKt.randomUUID();
            this.mySource = this.files.size() == 1 ? (Path)((Pair)CollectionsKt.first(this.files)).getFirst() : (Path)new MockPath(CollectionsKt.joinToString$default((Iterable)this.files, (CharSequence)",", null, null, (int)0, null, CompressTransfer::mySource$lambda$0, (int)30, null));
        }

        @Override
        @Nullable
        public Object transfer(int bufferSize, @NotNull Continuation<? super Long> $completion) {
            if (this.end) {
                return Boxing.boxLong((long)0L);
            }
            String paths = CollectionsKt.joinToString$default((Iterable)this.files, (CharSequence)" ", null, null, (int)0, null, CompressTransfer::transfer$lambda$0, (int)30, null);
            StringBuilder command = new StringBuilder();
            command.append("cd '" + ((Object)this.workdir.toAbsolutePath()).toString() + "'");
            command.append(" && ");
            if (this.mode == CompressMode.TarGz) {
                command.append("tar -czf");
            } else if (this.mode == CompressMode.Tar) {
                command.append("tar -cf");
            } else if (this.mode == CompressMode.Zip) {
                command.append("zip -r");
            } else if (this.mode == CompressMode.SevenZ) {
                command.append("7z a");
            }
            command.append(" '" + PathsKt.getName((Path)this.target) + "' ");
            command.append(paths);
            this.fileSystem.getClientSession().executeRemoteCommand(command.toString(), (OutputStream)System.out, Charsets.UTF_8);
            this.end = true;
            return Boxing.boxLong((long)this.size());
        }

        @Override
        @NotNull
        public Path source() {
            return this.mySource;
        }

        @Override
        @NotNull
        public Path target() {
            return this.target;
        }

        @Override
        public long size() {
            return this.files.size();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        @NotNull
        public Transfer.Priority priority() {
            return Transfer.Priority.High;
        }

        @Override
        public boolean scanning() {
            return false;
        }

        @Override
        @NotNull
        public String id() {
            return this.myID;
        }

        @Override
        @NotNull
        public String parentId() {
            return "";
        }

        private static final CharSequence mySource$lambda$0(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((Object)((Path)it.getFirst())).toString();
        }

        private static final CharSequence transfer$lambda$0(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + ((TransportTableModel.Attributes)it.getSecond()).getName() + "'";
        }
    }
}

