/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.NewHostDialogV2;
import app.termora.OptionPane;
import app.termora.TermoraFrameKt;
import app.termora.account.AccountManager;
import app.termora.account.AccountOwner;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.database.DatabaseChangedExtension;
import app.termora.database.DatabaseManager;
import app.termora.transfer.DefaultTransportSupport;
import app.termora.transfer.InternalTransferManager;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferManager;
import app.termora.transfer.TransportPanel;
import app.termora.transfer.TransportSelectionPanel;
import app.termora.transfer.TransportSupport;
import app.termora.transfer.TransportSupportLoader;
import app.termora.transfer.TransportTabbed;
import app.termora.transfer.TransportViewer;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010'\u001a\u00020\u0013H\u0016J\u0010\u0010(\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lapp/termora/transfer/TransportTabbed;", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "Lapp/termora/Disposable;", "transferManager", "Lapp/termora/transfer/TransferManager;", "<init>", "(Lapp/termora/transfer/TransferManager;)V", "addBtn", "Ljavax/swing/JButton;", "tabbed", "getTabbed", "()Lapp/termora/transfer/TransportTabbed;", "internalTransferManager", "Lapp/termora/transfer/InternalTransferManager;", "getInternalTransferManager", "()Lapp/termora/transfer/InternalTransferManager;", "setInternalTransferManager", "(Lapp/termora/transfer/InternalTransferManager;)V", "initViews", "", "initEvents", "tabCloseCallback", "index", "", "tabClose", "", "c", "Lapp/termora/transfer/TransportPanel;", "addSelectionTab", "Lapp/termora/transfer/TransportSelectionPanel;", "addLocalTab", "getDefaultLocalPath", "", "showContextMenu", "tabIndex", "e", "Ljava/awt/event/MouseEvent;", "getSelectedTransportPanel", "getTransportPanel", "updateUI", "removeTabAt", "dispose", "termora"})
@SourceDebugExtension(value={"SMAP\nTransportTabbed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportTabbed.kt\napp/termora/transfer/TransportTabbed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n774#2:249\n865#2,2:250\n*S KotlinDebug\n*F\n+ 1 TransportTabbed.kt\napp/termora/transfer/TransportTabbed\n*L\n113#1:249\n113#1:250,2\n*E\n"})
public final class TransportTabbed
extends FlatTabbedPane
implements Disposable {
    @NotNull
    private final TransferManager transferManager;
    @NotNull
    private final JButton addBtn;
    public InternalTransferManager internalTransferManager;

    public TransportTabbed(@NotNull TransferManager transferManager) {
        Intrinsics.checkNotNullParameter((Object)transferManager, (String)"transferManager");
        this.transferManager = transferManager;
        this.addBtn = new JButton((Icon)((Object)Icons.INSTANCE.getAdd()));
        this.initViews();
        this.initEvents();
    }

    private final TransportTabbed getTabbed() {
        return this;
    }

    @NotNull
    public final InternalTransferManager getInternalTransferManager() {
        InternalTransferManager internalTransferManager = this.internalTransferManager;
        if (internalTransferManager != null) {
            return internalTransferManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"internalTransferManager");
        return null;
    }

    public final void setInternalTransferManager(@NotNull InternalTransferManager internalTransferManager) {
        Intrinsics.checkNotNullParameter((Object)internalTransferManager, (String)"<set-?>");
        this.internalTransferManager = internalTransferManager;
    }

    private final void initViews() {
        super.setTabLayoutPolicy(1);
        super.setTabsClosable(true);
        super.setTabType(FlatTabbedPane.TabType.underlined);
        super.setFocusable(false);
        JToolBar toolbar = new JToolBar();
        toolbar.add(this.addBtn);
        super.setTrailingComponent((Component)toolbar);
    }

    private final void initEvents() {
        this.addBtn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ TransportTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                int n = this.this$0.getTabCount();
                for (int i = 0; i < n; ++i) {
                    Component c = this.this$0.getComponentAt(i);
                    if (!(c instanceof TransportSelectionPanel) || ((TransportSelectionPanel)c).getState() != TransportSelectionPanel.State.Initialized) continue;
                    this.this$0.setSelectedIndex(i);
                    SwingUtilities.invokeLater(() -> initEvents.1.actionPerformed$lambda$0(c));
                    return;
                }
                this.this$0.addSelectionTab();
            }

            private static final void actionPerformed$lambda$0(Component $c) {
                ((TransportSelectionPanel)$c).requestFocusInWindow();
            }
        }));
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ TransportTabbed this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int index = this.this$0.indexAtLocation(e.getX(), e.getY());
                if (index < 0) {
                    return;
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    TransportTabbed.access$showContextMenu(this.this$0, index, e);
                } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() % 2 == 0) {
                    TransportPanel transportPanel2 = this.this$0.getTransportPanel(index);
                    if (transportPanel2 == null) {
                        return;
                    }
                    TransportPanel tab = transportPanel2;
                    if (tab.getLoader().isOpening() || tab.getLoader().isOpened()) {
                        return;
                    }
                    TransportPanel.reload$default(tab, null, null, false, 7, null);
                }
            }
        });
        this.setTabCloseCallback((arg_0, arg_1) -> TransportTabbed.initEvents$lambda$0(this, arg_0, arg_1));
    }

    public final void tabCloseCallback(int index) {
        TermoraFrameKt.assertEventDispatchThread();
        if (!this.isTabClosable(index).booleanValue()) {
            return;
        }
        Component c = this.getTabbed().getComponentAt(index);
        if (c == null) {
            this.getTabbed().removeTabAt(index);
            return;
        }
        if (c instanceof TransportPanel && !this.tabClose((TransportPanel)c)) {
            return;
        }
        this.getTabbed().removeTabAt(index);
        if (this.getTabbed().getTabCount() < 1) {
            this.addSelectionTab();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tabClose(TransportPanel c) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        if (this.transferManager.getTransferCount() < 1) {
            return true;
        }
        TransportSupportLoader loader = c.getLoader();
        if (!loader.isLoaded()) {
            return false;
        }
        TransportSupport fileSystem = loader.getSyncTransportSupport();
        Object object = this.transferManager.getTransfers();
        boolean $i$f$filter22 = false;
        String string = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Transfer it = (Transfer)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.source().getFileSystem(), (Object)fileSystem) || Intrinsics.areEqual((Object)it.target().getFileSystem(), (Object)fileSystem))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List transfers = (List)destination$iv$iv;
        if (transfers.isEmpty()) {
            return true;
        }
        object = OptionPane.INSTANCE;
        Window $i$f$filter22 = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (OptionPane.showConfirmDialog$default((OptionPane)object, $i$f$filter22, string = I18n.INSTANCE.getString("termora.transport.sftp.close-tab"), null, 2, 3, null, null, null, null, 484, null) != 0) {
            return false;
        }
        for (Transfer transfer2 : transfers) {
            this.transferManager.removeTransfer(transfer2.id());
        }
        return true;
    }

    @NotNull
    public final TransportSelectionPanel addSelectionTab() {
        TransportSelectionPanel c = new TransportSelectionPanel(this.getTabbed(), this.getInternalTransferManager());
        this.addTab(I18n.INSTANCE.getString("termora.transport.sftp.select-host"), c);
        this.setSelectedIndex(this.getTabCount() - 1);
        SwingUtilities.invokeLater(() -> TransportTabbed.addSelectionTab$lambda$0(c));
        return c;
    }

    public final void addLocalTab() {
        Host host = new Host("local", "Local", "local", null, 0, null, null, null, null, null, null, 0L, null, null, null, null, false, 0L, 0L, 524280, null);
        FileSystem fs = FileSystems.getDefault();
        Intrinsics.checkNotNull((Object)fs);
        Path path = fs.getPath(this.getDefaultLocalPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        DefaultTransportSupport support = new DefaultTransportSupport(fs, path);
        TransportPanel panel2 = new TransportPanel(this.getInternalTransferManager(), host, new TransportSupportLoader(support){
            final /* synthetic */ DefaultTransportSupport $support;
            {
                this.$support = $support;
            }

            public Object getTransportSupport(Continuation<? super TransportSupport> $completion) {
                return this.$support;
            }

            public TransportSupport getSyncTransportSupport() {
                return this.$support;
            }

            public boolean isLoaded() {
                return true;
            }
        });
        this.addTab(I18n.INSTANCE.getString("termora.transport.local"), TransportViewer.MyIcon.Companion.getSuccess(), panel2);
        super.setTabClosable(0, false);
    }

    private final String getDefaultLocalPath() {
        String defaultDirectory = DatabaseManager.Companion.getInstance().getSftp().getDefaultDirectory();
        if (StringsKt.isBlank((CharSequence)defaultDirectory)) {
            String string = SystemUtils.USER_HOME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
            return string;
        }
        return defaultDirectory;
    }

    private final void showContextMenu(int tabIndex, MouseEvent e) {
        TransportPanel transportPanel2 = this.getTransportPanel(tabIndex);
        if (transportPanel2 == null) {
            return;
        }
        TransportPanel panel2 = transportPanel2;
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        JMenuItem clone = popupMenu.add(I18n.INSTANCE.getString("termora.copy"));
        clone.addActionListener((ActionListener)((Object)new AnAction(this, panel2){
            final /* synthetic */ TransportTabbed this$0;
            final /* synthetic */ TransportPanel $panel;
            {
                this.this$0 = $receiver;
                this.$panel = $panel;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                TransportSelectionPanel c = this.this$0.addSelectionTab();
                c.connect(this.$panel.getHost());
            }
        }));
        JMenuItem edit = popupMenu.add(I18n.INSTANCE.getString("termora.keymgr.edit"));
        edit.addActionListener((ActionListener)((Object)new AnAction(panel2, this, tabIndex){
            final /* synthetic */ TransportPanel $panel;
            final /* synthetic */ TransportTabbed this$0;
            final /* synthetic */ int $tabIndex;
            {
                this.$panel = $panel;
                this.this$0 = $receiver;
                this.$tabIndex = $tabIndex;
            }

            private final HostManager getHostManager() {
                return HostManager.Companion.getInstance();
            }

            private final AccountManager getAccountManager() {
                return AccountManager.Companion.getInstance();
            }

            /*
             * WARNING - void declaration
             */
            protected void actionPerformed(AnActionEvent evt) {
                T element$iv2;
                Window window;
                Host host;
                Window window2;
                block2: {
                    void $this$first$iv;
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    window2 = evt.getWindow();
                    Iterable iterable = this.getAccountManager().getOwners();
                    TransportPanel transportPanel2 = this.$panel;
                    host = this.getHost(this.$panel);
                    window = window2;
                    boolean $i$f$first = false;
                    for (T element$iv2 : $this$first$iv) {
                        AccountOwner it = (AccountOwner)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)transportPanel2.getHost().getOwnerId())) continue;
                        break block2;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                T t = element$iv2;
                AccountOwner accountOwner = (AccountOwner)t;
                Host host2 = host;
                Window window3 = window;
                NewHostDialogV2 dialog2 = new NewHostDialogV2(window3, host2, accountOwner);
                dialog2.setLocationRelativeTo(window2);
                dialog2.setTitle(this.$panel.getHost().getName());
                dialog2.setVisible(true);
                Host host3 = dialog2.getHost();
                if (host3 == null) {
                    return;
                }
                Host host4 = host3;
                this.getHostManager().addHost(host4, DatabaseChangedExtension.Source.User);
                this.this$0.setTitleAt(this.$tabIndex, host4.getName());
                this.setHost(this.$panel, host4);
            }

            private final Host getHost(TransportPanel panel2) {
                Host host = (Host)panel2.getClientProperty("EditHost");
                if (host == null) {
                    host = panel2.getHost();
                }
                return host;
            }

            private final void setHost(TransportPanel panel2, Host host) {
                panel2.putClientProperty("EditHost", host);
            }
        }));
        edit.setEnabled(clone.isEnabled() && !panel2.getHost().isTemporary());
        popupMenu.show((Component)((Object)this), e.getX(), e.getY());
    }

    @Nullable
    public final TransportPanel getSelectedTransportPanel() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.getTransportPanel(index);
    }

    @Nullable
    public final TransportPanel getTransportPanel(int index) {
        Component component = this.getComponentAt(index);
        return component instanceof TransportPanel ? (TransportPanel)component : null;
    }

    public void updateUI() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"hoverColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"tabHeight", (Object)30), TuplesKt.to((Object)"showTabSeparators", (Object)true), TuplesKt.to((Object)"tabSeparatorsFullHeight", (Object)true)};
        this.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        super.updateUI();
    }

    public void removeTabAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof Disposable) {
            Disposer.dispose((Disposable)((Object)c));
        }
        super.removeTabAt(index);
    }

    @Override
    public void dispose() {
        while (this.getTabCount() > 0) {
            this.removeTabAt(0);
        }
    }

    private static final void initEvents$lambda$0(TransportTabbed this$0, JTabbedPane jTabbedPane, Integer i) {
        Intrinsics.checkNotNull((Object)i);
        this$0.tabCloseCallback(i);
    }

    private static final void addSelectionTab$lambda$0(TransportSelectionPanel $c) {
        $c.requestFocusInWindow();
    }

    public static final /* synthetic */ void access$showContextMenu(TransportTabbed $this, int tabIndex, MouseEvent e) {
        $this.showContextMenu(tabIndex, e);
    }
}

