/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.I18n;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.attribute.PosixFilePermission;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/termora/transfer/PosixFilePermissionPanel;", "Ljavax/swing/JPanel;", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "<init>", "(Ljava/util/Set;)V", "ownerRead", "Ljavax/swing/JCheckBox;", "ownerWrite", "ownerExecute", "groupRead", "groupWrite", "groupExecute", "otherRead", "otherWrite", "otherExecute", "includeSubFolder", "initView", "", "createCenterPanel", "Ljavax/swing/JComponent;", "isIncludeSubdirectories", "", "getPermissions", "termora"})
public final class PosixFilePermissionPanel
extends JPanel {
    @NotNull
    private final Set<PosixFilePermission> permissions;
    @NotNull
    private final JCheckBox ownerRead;
    @NotNull
    private final JCheckBox ownerWrite;
    @NotNull
    private final JCheckBox ownerExecute;
    @NotNull
    private final JCheckBox groupRead;
    @NotNull
    private final JCheckBox groupWrite;
    @NotNull
    private final JCheckBox groupExecute;
    @NotNull
    private final JCheckBox otherRead;
    @NotNull
    private final JCheckBox otherWrite;
    @NotNull
    private final JCheckBox otherExecute;
    @NotNull
    private final JCheckBox includeSubFolder;

    public PosixFilePermissionPanel(@NotNull Set<? extends PosixFilePermission> permissions) {
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        super(new BorderLayout());
        this.permissions = permissions;
        this.ownerRead = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.read"));
        this.ownerWrite = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.write"));
        this.ownerExecute = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.execute"));
        this.groupRead = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.read"));
        this.groupWrite = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.write"));
        this.groupExecute = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.execute"));
        this.otherRead = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.read"));
        this.otherWrite = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.write"));
        this.otherExecute = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.execute"));
        this.includeSubFolder = new JCheckBox(I18n.INSTANCE.getString("termora.transport.permissions.include-subfolder"));
        this.initView();
    }

    private final void initView() {
        this.ownerRead.setSelected(this.permissions.contains((Object)PosixFilePermission.OWNER_READ));
        this.ownerWrite.setSelected(this.permissions.contains((Object)PosixFilePermission.OWNER_WRITE));
        this.ownerExecute.setSelected(this.permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE));
        this.groupRead.setSelected(this.permissions.contains((Object)PosixFilePermission.GROUP_READ));
        this.groupWrite.setSelected(this.permissions.contains((Object)PosixFilePermission.GROUP_WRITE));
        this.groupExecute.setSelected(this.permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE));
        this.otherRead.setSelected(this.permissions.contains((Object)PosixFilePermission.OTHERS_READ));
        this.otherWrite.setSelected(this.permissions.contains((Object)PosixFilePermission.OTHERS_WRITE));
        this.otherExecute.setSelected(this.permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE));
        this.ownerRead.setFocusable(false);
        this.ownerWrite.setFocusable(false);
        this.ownerExecute.setFocusable(false);
        this.groupRead.setFocusable(false);
        this.groupWrite.setFocusable(false);
        this.groupExecute.setFocusable(false);
        this.otherRead.setFocusable(false);
        this.otherWrite.setFocusable(false);
        this.otherExecute.setFocusable(false);
        this.includeSubFolder.setFocusable(false);
        this.add((Component)this.createCenterPanel(), "Center");
        this.setPreferredSize(new Dimension(Math.max(this.getPreferredSize().width, UIManager.getInt("Dialog.width") - 350), this.getPreferredSize().height));
    }

    private final JComponent createCenterPanel() {
        String formMargin = "7dlu";
        FormLayout layout = new FormLayout("default:grow, " + formMargin + ", default:grow, " + formMargin + ", default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref");
        FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
        builder2.add(I18n.INSTANCE.getString("termora.transport.permissions.file-folder-permissions") + ":", new Object[0]).xyw(1, 1, 5);
        Box ownerBox = Box.createVerticalBox();
        ownerBox.add(this.ownerRead);
        ownerBox.add(this.ownerWrite);
        ownerBox.add(this.ownerExecute);
        ownerBox.setBorder(BorderFactory.createTitledBorder(I18n.INSTANCE.getString("termora.transport.permissions.owner")));
        builder2.add((Component)ownerBox).xy(1, 3);
        Box groupBox = Box.createVerticalBox();
        groupBox.add(this.groupRead);
        groupBox.add(this.groupWrite);
        groupBox.add(this.groupExecute);
        groupBox.setBorder(BorderFactory.createTitledBorder(I18n.INSTANCE.getString("termora.transport.permissions.group")));
        builder2.add((Component)groupBox).xy(3, 3);
        Box otherBox = Box.createVerticalBox();
        otherBox.add(this.otherRead);
        otherBox.add(this.otherWrite);
        otherBox.add(this.otherExecute);
        otherBox.setBorder(BorderFactory.createTitledBorder(I18n.INSTANCE.getString("termora.transport.permissions.others")));
        builder2.add((Component)otherBox).xy(5, 3);
        builder2.add((Component)this.includeSubFolder).xyw(1, 5, 5);
        JPanel jPanel = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    public final boolean isIncludeSubdirectories() {
        return this.includeSubFolder.isSelected();
    }

    @NotNull
    public final Set<PosixFilePermission> getPermissions() {
        Set permissions = new LinkedHashSet();
        if (this.ownerRead.isSelected()) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if (this.ownerWrite.isSelected()) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if (this.ownerExecute.isSelected()) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (this.groupRead.isSelected()) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if (this.groupWrite.isSelected()) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if (this.groupExecute.isSelected()) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (this.otherRead.isSelected()) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if (this.otherWrite.isSelected()) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (this.otherExecute.isSelected()) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }
}

