/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ&\u0010\u0004\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u00a8\u0006\u000e"}, d2={"Lapp/termora/transfer/PathWalker;", "", "<init>", "()V", "walkFileTree", "", "path", "Ljava/nio/file/Path;", "visitor", "Ljava/nio/file/FileVisitor;", "", "sftpClient", "Lorg/apache/sshd/sftp/client/SftpClient;", "EmptyBasicFileAttributes", "termora"})
@SourceDebugExtension(value={"SMAP\nPathWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathWalker.kt\napp/termora/transfer/PathWalker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class PathWalker {
    @NotNull
    public static final PathWalker INSTANCE = new PathWalker();

    private PathWalker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void walkFileTree(@NotNull Path path, @NotNull FileVisitor<Path> visitor2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        if (path.getFileSystem() instanceof SftpFileSystem) {
            Boolean bl;
            FileSystem fileSystem = path.getFileSystem();
            Intrinsics.checkNotNull((Object)fileSystem, (String)"null cannot be cast to non-null type org.apache.sshd.sftp.client.fs.SftpFileSystem");
            SftpFileSystem fileSystem2 = (SftpFileSystem)fileSystem;
            Closeable closeable = (Closeable)fileSystem2.getClient();
            Throwable throwable = null;
            try {
                SftpClient it = (SftpClient)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                bl = INSTANCE.walkFileTree(path, it, visitor2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            v1 = bl;
        } else {
            v1 = Files.walkFileTree(path, visitor2);
        }
    }

    private final boolean walkFileTree(Path path, SftpClient sftpClient, FileVisitor<Path> visitor2) {
        if (visitor2.preVisitDirectory(path, EmptyBasicFileAttributes.Companion.getINSTANCE()) == FileVisitResult.TERMINATE) {
            return false;
        }
        for (SftpClient.DirEntry e : sftpClient.readDir(((Object)path.toAbsolutePath()).toString())) {
            if (Intrinsics.areEqual((Object)e.getFilename(), (Object)"..") || Intrinsics.areEqual((Object)e.getFilename(), (Object)".")) continue;
            if (e.getAttributes().isDirectory()) {
                Path path2 = path.resolve(e.getFilename());
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                if (this.walkFileTree(path2, sftpClient, visitor2)) continue;
                return false;
            }
            if (visitor2.visitFile(path.resolve(e.getFilename()), EmptyBasicFileAttributes.Companion.getINSTANCE()) != FileVisitResult.TERMINATE) continue;
            return false;
        }
        return visitor2.postVisitDirectory(path, null) == FileVisitResult.CONTINUE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lapp/termora/transfer/PathWalker$EmptyBasicFileAttributes;", "Ljava/nio/file/attribute/BasicFileAttributes;", "<init>", "()V", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "lastAccessTime", "creationTime", "isRegularFile", "", "isDirectory", "isSymbolicLink", "isOther", "size", "", "fileKey", "", "Companion", "termora"})
    private static final class EmptyBasicFileAttributes
    implements BasicFileAttributes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final EmptyBasicFileAttributes INSTANCE = new EmptyBasicFileAttributes();

        @Override
        @NotNull
        public FileTime lastModifiedTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FileTime lastAccessTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public FileTime creationTime() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isRegularFile() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isDirectory() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isSymbolicLink() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean isOther() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public long size() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public Object fileKey() {
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/transfer/PathWalker$EmptyBasicFileAttributes$Companion;", "", "<init>", "()V", "INSTANCE", "Lapp/termora/transfer/PathWalker$EmptyBasicFileAttributes;", "getINSTANCE", "()Lapp/termora/transfer/PathWalker$EmptyBasicFileAttributes;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final EmptyBasicFileAttributes getINSTANCE() {
                return INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

