/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.transfer.AbstractTransfer;
import app.termora.transfer.TransferIndeterminate;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/termora/transfer/CommandTransfer;", "Lapp/termora/transfer/AbstractTransfer;", "Lapp/termora/transfer/TransferIndeterminate;", "parentId", "", "path", "Lorg/apache/sshd/sftp/client/fs/SftpPath;", "isDirectory", "", "size", "", "command", "<init>", "(Ljava/lang/String;Lorg/apache/sshd/sftp/client/fs/SftpPath;ZJLjava/lang/String;)V", "getCommand", "()Ljava/lang/String;", "executed", "transfer", "bufferSize", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scanning", "termora"})
public final class CommandTransfer
extends AbstractTransfer
implements TransferIndeterminate {
    private final long size;
    @NotNull
    private final String command;
    private boolean executed;

    public CommandTransfer(@NotNull String parentId, @NotNull SftpPath path, boolean isDirectory, long size, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        super(parentId, (Path)path, (Path)path, isDirectory, null, 16, null);
        this.size = size;
        this.command = command;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @Override
    @Nullable
    public Object transfer(int bufferSize, @NotNull Continuation<? super Long> $completion) {
        if (this.executed) {
            return Boxing.boxLong((long)0L);
        }
        FileSystem fileSystem = this.source().getFileSystem();
        Intrinsics.checkNotNull((Object)fileSystem, (String)"null cannot be cast to non-null type org.apache.sshd.sftp.client.fs.SftpFileSystem");
        SftpFileSystem fs = (SftpFileSystem)fileSystem;
        fs.getClientSession().executeRemoteCommand(this.command);
        this.executed = true;
        return Boxing.boxLong((long)this.size());
    }

    @Override
    public boolean scanning() {
        return false;
    }

    @Override
    public long size() {
        return Math.max(this.size, 1L);
    }
}

