/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.transfer.AbstractTransfer;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferScanner;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0019H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/transfer/ChangePermissionTransfer;", "Lapp/termora/transfer/AbstractTransfer;", "Lapp/termora/transfer/TransferScanner;", "parentId", "", "path", "Ljava/nio/file/Path;", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "isDirectory", "", "size", "", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/util/Set;ZJ)V", "getPermissions", "()Ljava/util/Set;", "changed", "scanned", "transfer", "bufferSize", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scanning", "", "termora"})
public final class ChangePermissionTransfer
extends AbstractTransfer
implements TransferScanner {
    @NotNull
    private final Set<PosixFilePermission> permissions;
    private final long size;
    private boolean changed;
    private boolean scanned;

    public ChangePermissionTransfer(@NotNull String parentId, @NotNull Path path, @NotNull Set<? extends PosixFilePermission> permissions, boolean isDirectory, long size) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        super(parentId, path, path, isDirectory, Transfer.Priority.Normal);
        this.permissions = permissions;
        this.size = size;
    }

    @NotNull
    public final Set<PosixFilePermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Nullable
    public Object transfer(int bufferSize, @NotNull Continuation<? super Long> $completion) {
        if (this.changed) {
            return Boxing.boxLong((long)0L);
        }
        Files.setPosixFilePermissions(this.source(), this.permissions);
        this.changed = true;
        return Boxing.boxLong((long)this.size());
    }

    @Override
    public boolean scanning() {
        return this.isDirectory() ? !this.scanned : false;
    }

    @Override
    public void scanned() {
        this.scanned = true;
    }

    @Override
    public long size() {
        return Math.max(this.size, 1L);
    }
}

