/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.Application;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TermoraFrameKt;
import app.termora.database.DatabaseManager;
import app.termora.transfer.BookmarksDialog;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lapp/termora/transfer/BookmarkButton;", "Ljavax/swing/JButton;", "<init>", "()V", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "arrowWidth", "", "arrowSize", "button", "value", "", "isBookmark", "()Z", "setBookmark", "(Z)V", "showBookmarks", "", "e", "Ljava/awt/event/MouseEvent;", "addBookmark", "text", "", "deleteBookmark", "getBookmarks", "", "paintComponent", "g", "Ljava/awt/Graphics;", "isSelected", "fireActionPerformed", "event", "Ljava/awt/event/ActionEvent;", "termora"})
@SourceDebugExtension(value={"SMAP\nBookmarkButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookmarkButton.kt\napp/termora/transfer/BookmarkButton\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n205#2:171\n205#2:172\n222#2:174\n205#2:175\n1#3:173\n*S KotlinDebug\n*F\n+ 1 BookmarkButton.kt\napp/termora/transfer/BookmarkButton\n*L\n110#1:171\n118#1:172\n129#1:174\n80#1:175\n*E\n"})
public final class BookmarkButton
extends JButton {
    @NotNull
    private final DatabaseManager.Properties properties = DatabaseManager.Companion.getInstance().getProperties();
    private final int arrowWidth;
    private final int arrowSize;
    @NotNull
    private final BookmarkButton button = this;
    private boolean isBookmark;

    public BookmarkButton() {
        super((Icon)((Object)Icons.INSTANCE.getBookmarks()));
        this.arrowWidth = 16;
        this.arrowSize = 6;
        final int oldWidth = this.getPreferredSize().width;
        this.setPreferredSize(new Dimension(oldWidth + this.arrowWidth, this.getPreferredSize().height));
        this.setHorizontalAlignment(2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getX() < oldWidth) {
                        ActionListener[] actionListenerArray = this.getActionListeners();
                        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
                        for (ActionListener listener2 : actionListenerArray) {
                            listener2.actionPerformed(new ActionEvent(button, 1001, ""));
                        }
                    } else {
                        this.showBookmarks(e);
                    }
                }
            }
        });
        this.setBookmark(false);
        this.setToolTipText(I18n.INSTANCE.getString("termora.transport.bookmarks"));
    }

    public final boolean isBookmark() {
        return this.isBookmark;
    }

    public final void setBookmark(boolean value) {
        this.isBookmark = value;
        this.setIcon(value ? (Icon)((Object)Icons.INSTANCE.getBookmarksOff()) : (Icon)((Object)Icons.INSTANCE.getBookmarks()));
    }

    private final void showBookmarks(MouseEvent e) {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        List<String> bookmarks = this.getBookmarks();
        popupMenu.add(I18n.INSTANCE.getString("termora.transport.bookmarks")).addActionListener(arg_0 -> BookmarkButton.showBookmarks$lambda$0(this, bookmarks, arg_0));
        if (!((Collection)bookmarks).isEmpty()) {
            popupMenu.addSeparator();
            for (String bookmark : bookmarks) {
                popupMenu.add(bookmark).addActionListener(arg_0 -> BookmarkButton.showBookmarks$lambda$1(this, bookmark, arg_0));
            }
        }
        popupMenu.show(e.getComponent(), -(popupMenu.getPreferredSize().width / 2 - this.getWidth() / 2), this.getHeight() + 2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBookmark(@NotNull String text) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermoraFrameKt.assertEventDispatchThread();
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        List bookmarks = CollectionsKt.toMutableList((Collection)this.getBookmarks());
        bookmarks.add(text);
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json json = Application.INSTANCE.getOhMyJson();
        List value$iv = bookmarks;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        this.properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), (Object)value$iv));
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteBookmark(@NotNull String text) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermoraFrameKt.assertEventDispatchThread();
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return;
        }
        List bookmarks = CollectionsKt.toMutableList((Collection)this.getBookmarks());
        bookmarks.removeIf(arg_0 -> BookmarkButton.deleteBookmark$lambda$1(arg_0 -> BookmarkButton.deleteBookmark$lambda$0(text, arg_0), arg_0));
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json json = Application.INSTANCE.getOhMyJson();
        List value$iv = bookmarks;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        this.properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), (Object)value$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getBookmarks() {
        if (StringUtils.isBlank((CharSequence)this.getName())) {
            return CollectionsKt.emptyList();
        }
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String text = this.properties.getString(string, "[]");
        if (StringUtils.isNotBlank((CharSequence)text)) {
            Object $this$getBookmarks_u24lambda_u240;
            Object object = this;
            try {
                void this_$iv;
                $this$getBookmarks_u24lambda_u240 = object;
                boolean bl = false;
                Json json = Application.INSTANCE.getOhMyJson();
                String string$iv = text;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                $this$getBookmarks_u24lambda_u240 = Result.constructor-impl((Object)((List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), string$iv)));
            }
            catch (Throwable bl) {
                $this$getBookmarks_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$getBookmarks_u24lambda_u240;
            if (Result.isSuccess-impl((Object)object)) {
                List it = (List)object;
                boolean bl = false;
                return it;
            }
        }
        return CollectionsKt.emptyList();
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g2d);
        int x = this.getPreferredSize().width - this.arrowWidth;
        ((Graphics2D)g).setColor(DynamicColor.Companion.getBorderColor());
        g.drawLine(x + 1, 4, x + 1, this.getPreferredSize().height - 2);
        ((Graphics2D)g).setColor(FlatLaf.isLafDark() ? new Color(206, 208, 214) : new Color(108, 112, 126));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        FlatUIUtils.paintArrow((Graphics2D)g2d, (int)x, (int)(this.getPreferredSize().height / 2 - this.arrowSize), (int)this.arrowWidth, (int)this.arrowWidth, (int)5, (boolean)false, (int)this.arrowSize, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    protected void fireActionPerformed(@NotNull ActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    /*
     * WARNING - void declaration
     */
    private static final void showBookmarks$lambda$0(BookmarkButton this$0, List $bookmarks, ActionEvent it) {
        void this_$iv;
        Window window = SwingUtilities.getWindowAncestor(this$0);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        List<String> list = new BookmarksDialog(window, $bookmarks).open();
        DatabaseManager.Properties properties = this$0.properties;
        String string = this$0.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Json json = Application.INSTANCE.getOhMyJson();
        List<String> value$iv = list;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        properties.putString(string, this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), value$iv));
    }

    private static final void showBookmarks$lambda$1(BookmarkButton this$0, String $bookmark, ActionEvent it) {
        ActionListener[] actionListenerArray = this$0.getActionListeners();
        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
        for (ActionListener listener2 : actionListenerArray) {
            listener2.actionPerformed(new ActionEvent(this$0.button, 1001, $bookmark));
        }
    }

    private static final boolean deleteBookmark$lambda$0(String $text, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)$text, (Object)it);
    }

    private static final boolean deleteBookmark$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

