/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tlog;

import app.termora.CryptoKt;
import app.termora.Host;
import app.termora.HostTerminalTab;
import app.termora.I18n;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalListener;
import app.termora.terminal.TextProcessor;
import app.termora.terminal.VisualTerminal;
import app.termora.tlog.TerminalLoggerAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006&"}, d2={"Lapp/termora/tlog/TerminalLoggerDataListener;", "Lapp/termora/terminal/DataListener;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "channel", "Lkotlinx/coroutines/channels/Channel;", "", "file", "Ljava/io/File;", "writer", "Ljava/io/BufferedWriter;", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isClosed", "terminalLoggerActionPropertyChangeListener", "Ljava/beans/PropertyChangeListener;", "host", "Lapp/termora/Host;", "getHost", "()Lapp/termora/Host;", "onChanged", "", "key", "Lapp/termora/terminal/DataKey;", "data", "", "tryRecord", "text", "action", "Lapp/termora/tlog/TerminalLoggerAction;", "createFile", "dir", "close", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalLoggerDataListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalLoggerDataListener.kt\napp/termora/tlog/TerminalLoggerDataListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,207:1\n1#2:208\n*E\n"})
public final class TerminalLoggerDataListener
implements DataListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @Nullable
    private CoroutineScope coroutineScope;
    @Nullable
    private Channel<String> channel;
    @Nullable
    private File file;
    @Nullable
    private BufferedWriter writer;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final PropertyChangeListener terminalLoggerActionPropertyChangeListener;
    @NotNull
    private static final DataKey<Boolean> IgnoreTerminalLogger = new DataKey(Reflection.getOrCreateKotlinClass(Boolean.TYPE));
    private static final Logger log = LoggerFactory.getLogger(TerminalLoggerDataListener.class);

    public TerminalLoggerDataListener(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.isRecording = new AtomicBoolean(false);
        this.isClosed = new AtomicBoolean(false);
        this.terminalLoggerActionPropertyChangeListener = arg_0 -> TerminalLoggerDataListener.terminalLoggerActionPropertyChangeListener$lambda$0(this, arg_0);
        this.terminal.addTerminalListener(new TerminalListener(){

            @Override
            public void onClose(Terminal terminal) {
                Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
                if (isClosed.compareAndSet(false, true)) {
                    isClosed.set(true);
                    terminal.getTerminalModel().removeDataListener(this);
                    this.close();
                }
            }
        });
    }

    private final Host getHost() {
        if (this.terminal.getTerminalModel().hasData(HostTerminalTab.Companion.getHost())) {
            return this.terminal.getTerminalModel().getData(HostTerminalTab.Companion.getHost());
        }
        return null;
    }

    @Override
    public void onChanged(@NotNull DataKey<?> key, @NotNull Object data) {
        block11: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (this.isClosed.get()) {
                return;
            }
            if (this.terminal.getTerminalModel().getData(IgnoreTerminalLogger, false).booleanValue()) {
                return;
            }
            if (!Intrinsics.areEqual(key, VisualTerminal.Companion.getWritten()) && !Intrinsics.areEqual(key, TextProcessor.Companion.getWritten())) {
                return;
            }
            Host host = this.getHost();
            if (host == null) {
                return;
            }
            Host host2 = host;
            TerminalLoggerAction action2 = TerminalLoggerAction.Companion.getInstance();
            if (!action2.isRecording()) {
                return;
            }
            try {
                if (action2.isPlainText()) {
                    if (Intrinsics.areEqual(key, TextProcessor.Companion.getWritten())) {
                        this.tryRecord((String)data, host2, action2);
                    }
                } else if (Intrinsics.areEqual(key, VisualTerminal.Companion.getWritten())) {
                    this.tryRecord((String)data, host2, action2);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private final void tryRecord(String text, Host host, TerminalLoggerAction action2) {
        block5: {
            if (this.isRecording.compareAndSet(false, true)) {
                Channel channel;
                CoroutineScope coroutineScope;
                File file = this.createFile(host, action2.getLogDir());
                Object $this$tryRecord_u24lambda_u240 = file;
                boolean bl = false;
                this.file = $this$tryRecord_u24lambda_u240;
                File file2 = file;
                Object $this$tryRecord_u24lambda_u241 = $this$tryRecord_u24lambda_u240 = new BufferedWriter(new FileWriter(file2, false));
                boolean bl2 = false;
                this.writer = $this$tryRecord_u24lambda_u241;
                Object writer = $this$tryRecord_u24lambda_u240;
                if (log.isInfoEnabled()) {
                    log.info("Terminal logger file: " + file2.getAbsolutePath());
                }
                action2.removePropertyChangeListener(this.terminalLoggerActionPropertyChangeListener);
                action2.addPropertyChangeListener(this.terminalLoggerActionPropertyChangeListener);
                CoroutineScope coroutineScope2 = this.coroutineScope;
                if (coroutineScope2 == null) {
                    CoroutineScope $this$tryRecord_u24lambda_u242 = bl2 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getIO()));
                    boolean bl3 = false;
                    this.coroutineScope = $this$tryRecord_u24lambda_u242;
                    coroutineScope2 = coroutineScope = bl2;
                }
                if ((channel = this.channel) == null) {
                    Channel channel2;
                    Channel $this$tryRecord_u24lambda_u243 = channel2 = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
                    boolean bl4 = false;
                    this.channel = $this$tryRecord_u24lambda_u243;
                    channel = channel2;
                }
                Channel channel3 = channel;
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(coroutineScope, channel3, (BufferedWriter)writer, null){
                    int label;
                    final /* synthetic */ CoroutineScope $coroutineScope;
                    final /* synthetic */ Channel<String> $channel;
                    final /* synthetic */ BufferedWriter $writer;
                    {
                        this.$coroutineScope = $coroutineScope;
                        this.$channel = $channel;
                        this.$writer = $writer;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
lbl5:
                                // 4 sources

                                while (CoroutineScopeKt.isActive((CoroutineScope)this.$coroutineScope)) {
                                    this.label = 1;
                                    v0 = this.$channel.receiveCatching-JP2dKIU((Continuation)this);
                                    if (v0 == var7_2) {
                                        return var7_2;
                                    }
                                    ** GOTO lbl15
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = ((ChannelResult)$result).unbox-impl();
lbl15:
                                // 2 sources

                                var2_3 = v0;
                                var3_5 = this.$writer;
                                $i$f$onSuccess-WpGqRn0 = false;
                                if (!($this$onSuccess_u2dWpGqRn0$iv instanceof ChannelResult.Failed)) {
                                    it = (String)$this$onSuccess_u2dWpGqRn0$iv;
                                    $i$a$-onSuccess-WpGqRn0-TerminalLoggerDataListener$tryRecord$1$1 = false;
                                    var3_5.write(it);
                                }
                                $this$onFailure_u2dWpGqRn0$iv = $this$onSuccess_u2dWpGqRn0$iv;
                                $i$f$onFailure-WpGqRn0 = false;
                                if (!($this$onFailure_u2dWpGqRn0$iv instanceof ChannelResult.Failed)) ** GOTO lbl5
                                e = ChannelResult.exceptionOrNull-impl((Object)$this$onFailure_u2dWpGqRn0$iv);
                                $i$a$-onFailure-WpGqRn0-TerminalLoggerDataListener$tryRecord$1$2 = false;
                                if (!TerminalLoggerDataListener.access$getLog$cp().isErrorEnabled() || e == null) ** GOTO lbl5
                                TerminalLoggerDataListener.access$getLog$cp().error(e.getMessage(), e);
                                ** GOTO lbl5
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                String date = DateFormatUtils.format((Date)new Date(), (String)I18n.INSTANCE.getString("termora.date-format"));
                ChannelResult.isSuccess-impl((Object)channel3.trySend-JP2dKIU((Object)("[BEGIN] ---- " + date + " ----")));
                ChannelResult.isSuccess-impl((Object)channel3.trySend-JP2dKIU((Object)"\n\r"));
            }
            if (!this.isRecording.get()) break block5;
            Channel<String> channel = this.channel;
            if (channel != null) {
                ChannelResult.isSuccess-impl((Object)channel.trySend-JP2dKIU((Object)text));
            }
        }
    }

    private final File createFile(Host host, File dir) {
        Object object;
        String now = DateFormatUtils.format((Date)new Date(), (String)"HH_mm_ss_SSS");
        String filename = dir.getAbsolutePath() + File.separator + host.getName() + "." + now + ".log";
        try {
            object = Paths.get(filename, new String[0]).toFile();
            Intrinsics.checkNotNull((Object)object);
        }
        catch (Exception e) {
            Object object2;
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                object2 = new String[]{host.getId() + "." + now + ".log"};
                object2 = Paths.get(dir.getAbsolutePath(), object2).toFile();
            }
            catch (Exception e2) {
                String[] stringArray = new String[]{CryptoKt.randomUUID() + "." + now + ".log"};
                object2 = Paths.get(dir.getAbsolutePath(), stringArray).toFile();
            }
            Object object3 = object2;
            Intrinsics.checkNotNull((Object)object3);
            object = object3;
        }
        return object;
    }

    private final void close() {
        Object object;
        if (!this.isRecording.compareAndSet(true, false)) {
            return;
        }
        TerminalLoggerAction.Companion.getInstance().removePropertyChangeListener(this.terminalLoggerActionPropertyChangeListener);
        Channel<String> channel = this.channel;
        if (channel != null) {
            SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)channel), null, (int)1, null);
        }
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope != null) {
            CoroutineScopeKt.cancel$default((CoroutineScope)coroutineScope, null, (int)1, null);
        }
        this.channel = null;
        this.coroutineScope = null;
        Object object2 = this;
        try {
            Unit unit;
            TerminalLoggerDataListener $this$close_u24lambda_u240 = object2;
            boolean bl = false;
            String date = DateFormatUtils.format((Date)new Date(), (String)I18n.INSTANCE.getString("termora.date-format"));
            BufferedWriter bufferedWriter = $this$close_u24lambda_u240.writer;
            if (bufferedWriter != null) {
                bufferedWriter.write("\n\r");
            }
            BufferedWriter bufferedWriter2 = $this$close_u24lambda_u240.writer;
            if (bufferedWriter2 != null) {
                bufferedWriter2.write("[END] ---- " + date + " ----");
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            object = Result.constructor-impl(unit);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            if (log.isErrorEnabled()) {
                log.error(((Throwable)it).getMessage(), (Throwable)it);
            }
        }
        IOUtils.closeQuietly((Writer)this.writer);
        File file = this.file;
        if (log.isInfoEnabled() && file != null) {
            log.info("Terminal logger file: {} saved", (Object)file.getAbsolutePath());
        }
        this.writer = null;
        this.file = null;
    }

    private static final void terminalLoggerActionPropertyChangeListener$lambda$0(TerminalLoggerDataListener this$0, PropertyChangeEvent evt) {
        if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"Recording") && Intrinsics.areEqual((Object)evt.getNewValue(), (Object)false)) {
            this$0.close();
        }
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/tlog/TerminalLoggerDataListener$Companion;", "", "<init>", "()V", "IgnoreTerminalLogger", "Lapp/termora/terminal/DataKey;", "", "getIgnoreTerminalLogger", "()Lapp/termora/terminal/DataKey;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Boolean> getIgnoreTerminalLogger() {
            return IgnoreTerminalLogger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

