/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tlog;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.FileChooser;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TerminalTabbedManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.database.DatabaseManager;
import app.termora.tlog.LogViewerTerminalTab;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\r\u00a8\u0006\u001a"}, d2={"Lapp/termora/tlog/TerminalLoggerAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "value", "", "isRecording", "()Z", "setRecording", "(Z)V", "isPlainText", "setPlainText", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "openLogViewer", "owner", "Ljava/awt/Window;", "getLogDir", "Ljava/io/File;", "Companion", "termora"})
public final class TerminalLoggerAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isRecording;
    private boolean isPlainText;
    private static final Logger log = LoggerFactory.getLogger(TerminalLoggerAction.class);

    private TerminalLoggerAction() {
        super(I18n.INSTANCE.getString("termora.terminal-logger"), (Icon)((Object)Icons.INSTANCE.getListFiles()));
        String string = this.getProperties().getString("terminal.logger.isRecording");
        this.isRecording = string != null ? Boolean.parseBoolean(string) : false;
        String string2 = this.getProperties().getString("terminal.logger.isPlainText");
        this.isPlainText = string2 != null ? Boolean.parseBoolean(string2) : false;
        this.setSmallIcon(this.isRecording ? (Icon)((Object)Icons.INSTANCE.getDotListFiles()) : (Icon)((Object)Icons.INSTANCE.getListFiles()));
    }

    private final DatabaseManager.Properties getProperties() {
        return DatabaseManager.Companion.getInstance().getProperties();
    }

    public final boolean isRecording() {
        return this.isRecording;
    }

    private final void setRecording(boolean value) {
        this.isRecording = value;
        this.putValue("Recording", value);
        this.getProperties().putString("terminal.logger.isRecording", String.valueOf(value));
    }

    public final boolean isPlainText() {
        return this.isPlainText;
    }

    private final void setPlainText(boolean value) {
        this.isPlainText = value;
        this.getProperties().putString("terminal.logger.isPlainText", String.valueOf(value));
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Object source = evt.getSource();
        if (!(source instanceof JComponent)) {
            return;
        }
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        if (this.isRecording) {
            popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.stop-recording")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$0(this, arg_0));
        } else {
            popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.start-recording")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$1(this, arg_0));
        }
        JMenu settingMenu = new JMenu(I18n.INSTANCE.getString("termora.setting"));
        JMenuItem plainText = settingMenu.add(new JCheckBoxMenuItem(I18n.INSTANCE.getString("termora.terminal-logger.plain-text")));
        JMenuItem styledText = settingMenu.add(new JCheckBoxMenuItem(I18n.INSTANCE.getString("termora.terminal-logger.styled-text")));
        plainText.setSelected(this.isPlainText);
        styledText.setSelected(!plainText.isSelected());
        plainText.setEnabled(!this.isRecording);
        styledText.setEnabled(plainText.isEnabled());
        plainText.addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$2(this, plainText, arg_0));
        styledText.addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$3(this, styledText, arg_0));
        popupMenu.add((JMenuItem)settingMenu);
        popupMenu.addSeparator();
        popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.open-log-viewer")).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$4(this, source, arg_0));
        Object[] objectArray = new Object[]{SystemInfo.isMacOS ? I18n.INSTANCE.getString("termora.finder") : (SystemInfo.isWindows ? I18n.INSTANCE.getString("termora.explorer") : I18n.INSTANCE.getString("termora.folder"))};
        popupMenu.add(I18n.INSTANCE.getString("termora.terminal-logger.open-in-folder", objectArray)).addActionListener(arg_0 -> TerminalLoggerAction.actionPerformed$lambda$5(this, arg_0));
        int width = popupMenu.getPreferredSize().width;
        popupMenu.show((Component)source, -(width / 2) + ((JComponent)source).getWidth() / 2, ((JComponent)source).getHeight());
    }

    private final void openLogViewer(Window owner) {
        FileChooser fc = new FileChooser();
        fc.setAllowsMultiSelection(true);
        fc.setTitle(I18n.INSTANCE.getString("termora.terminal-logger.open-log-viewer"));
        fc.setFileSelectionMode(0);
        if (SystemInfo.isMacOS) {
            fc.setOsxAllowedFileTypes(CollectionsKt.listOf((Object)"log"));
        } else if (SystemInfo.isWindows) {
            fc.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"Log files", (Object)CollectionsKt.listOf((Object)"log")));
        }
        String string = this.getLogDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        fc.setDefaultDirectory(string);
        fc.showOpenDialog(owner).thenAccept(arg_0 -> TerminalLoggerAction.openLogViewer$lambda$1(arg_0 -> TerminalLoggerAction.openLogViewer$lambda$0(owner, arg_0), arg_0));
    }

    @NotNull
    public final File getLogDir() {
        String[] stringArray = new String[]{"terminal", "logs", LocalDate.now().toString()};
        File dir = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])stringArray);
        FileUtils.forceMkdir((File)dir);
        Intrinsics.checkNotNull((Object)dir);
        return dir;
    }

    private static final void actionPerformed$lambda$0(TerminalLoggerAction this$0, ActionEvent it) {
        this$0.setRecording(false);
        this$0.setSmallIcon((Icon)((Object)Icons.INSTANCE.getListFiles()));
    }

    private static final void actionPerformed$lambda$1(TerminalLoggerAction this$0, ActionEvent it) {
        this$0.setRecording(true);
        this$0.setSmallIcon((Icon)((Object)Icons.INSTANCE.getDotListFiles()));
    }

    private static final void actionPerformed$lambda$2(TerminalLoggerAction this$0, JMenuItem $plainText, ActionEvent it) {
        this$0.setPlainText($plainText.isSelected());
    }

    private static final void actionPerformed$lambda$3(TerminalLoggerAction this$0, JMenuItem $styledText, ActionEvent it) {
        this$0.setPlainText(!$styledText.isSelected());
    }

    private static final void actionPerformed$lambda$4(TerminalLoggerAction this$0, Object $source, ActionEvent it) {
        Window window = SwingUtilities.getWindowAncestor((Component)$source);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        this$0.openLogViewer(window);
    }

    private static final void actionPerformed$lambda$5(TerminalLoggerAction this$0, ActionEvent it) {
        File dir = this$0.getLogDir();
        URI uRI = dir.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
    }

    private static final Unit openLogViewer$lambda$0(Window $owner, List files) {
        Intrinsics.checkNotNull((Object)files);
        if (!((Collection)files).isEmpty()) {
            SwingUtilities.invokeLater(() -> TerminalLoggerAction.openLogViewer$lambda$0$0($owner, files));
        }
        return Unit.INSTANCE;
    }

    private static final void openLogViewer$lambda$0$0(Window $owner, List $files) {
        TerminalTabbedManager manager = (TerminalTabbedManager)ApplicationScope.Companion.forWindowScope($owner).get(Reflection.getOrCreateKotlinClass(TerminalTabbedManager.class));
        for (File file : $files) {
            LogViewerTerminalTab tab = new LogViewerTerminalTab(ApplicationScope.Companion.forWindowScope($owner), file);
            tab.start();
            TerminalTabbedManager.addTerminalTab$default(manager, tab, false, 2, null);
        }
    }

    private static final void openLogViewer$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public /* synthetic */ TerminalLoggerAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/tlog/TerminalLoggerAction$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/tlog/TerminalLoggerAction;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalLoggerAction getInstance() {
            return (TerminalLoggerAction)((Object)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(TerminalLoggerAction.class), Companion::getInstance$lambda$0));
        }

        private static final TerminalLoggerAction getInstance$lambda$0() {
            return new TerminalLoggerAction(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

