/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel.vw;

import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.TermoraFrame;
import app.termora.database.DatabaseManager;
import app.termora.terminal.panel.vw.VisualWindow;
import app.termora.terminal.panel.vw.VisualWindowManager;
import app.termora.terminal.panel.vw.VisualWindowPanel;
import app.termora.terminal.panel.vw.VisualWindowResizer;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n*\u0001-\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0003MNOB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u00109\u001a\u00020:H\u0004J\b\u0010;\u001a\u00020:H\u0002J\u001a\u0010<\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020?0>0=H\u0014J\b\u0010@\u001a\u00020:H\u0002J\b\u0010A\u001a\u00020:H\u0002J\b\u0010B\u001a\u00020:H\u0016J\u0006\u0010C\u001a\u00020DJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\n\u0010E\u001a\u0004\u0018\u00010FH\u0016J\b\u0010G\u001a\u00020\u0004H\u0014J\b\u0010H\u001a\u00020:H\u0016J\b\u0010I\u001a\u00020:H\u0014J\b\u0010J\u001a\u00020\u001dH\u0014J\b\u0010K\u001a\u00020:H\u0014J\b\u0010L\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0018\u00010\"R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010(\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010 R\u000e\u0010+\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010.R$\u0010/\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010)\"\u0004\b0\u0010 R$\u00101\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010)\"\u0004\b2\u0010 R\u0014\u00103\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010)R$\u00105\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00048D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\n\"\u0004\b7\u00108\u00a8\u0006P"}, d2={"Lapp/termora/terminal/panel/vw/VisualWindowPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/terminal/panel/vw/VisualWindow;", "id", "", "visualWindowManager", "Lapp/termora/terminal/panel/vw/VisualWindowManager;", "<init>", "(Ljava/lang/String;Lapp/termora/terminal/panel/vw/VisualWindowManager;)V", "getId", "()Ljava/lang/String;", "getVisualWindowManager", "()Lapp/termora/terminal/panel/vw/VisualWindowManager;", "stickPx", "", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "titleLabel", "Ljavax/swing/JLabel;", "toolbar", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "visualWindow", "getVisualWindow", "()Lapp/termora/terminal/panel/vw/VisualWindowPanel;", "resizer", "Lapp/termora/terminal/panel/vw/VisualWindowResizer;", "value", "", "isWindow", "setWindow", "(Z)V", "dialog", "Lapp/termora/terminal/panel/vw/VisualWindowPanel$VisualWindowDialog;", "oldBounds", "Ljava/awt/Rectangle;", "toggleWindowBtn", "Ljavax/swing/JButton;", "closeBtn", "isAlwaysTop", "()Z", "setAlwaysTop", "alwaysTopBtn", "closeWindowListener", "app/termora/terminal/panel/vw/VisualWindowPanel$closeWindowListener$1", "Lapp/termora/terminal/panel/vw/VisualWindowPanel$closeWindowListener$1;", "isStickHover", "setStickHover", "isStick", "setStick", "expand", "getExpand", "title", "getTitle", "setTitle", "(Ljava/lang/String;)V", "initVisualWindowPanel", "", "initViews", "toolbarButtons", "", "Lkotlin/Pair;", "Lapp/termora/terminal/panel/vw/VisualWindowPanel$Position;", "initEvents", "initToolBar", "dispose", "getJComponent", "Ljavax/swing/JComponent;", "getWindow", "Ljava/awt/Window;", "getWindowTitle", "toggleWindow", "reassemble", "beforeClose", "close", "getWindowName", "Position", "DragListener", "VisualWindowDialog", "termora"})
@SourceDebugExtension(value={"SMAP\nVisualWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualWindowPanel.kt\napp/termora/terminal/panel/vw/VisualWindowPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1788#2,4:407\n774#2:411\n865#2,2:412\n1869#2,2:414\n774#2:416\n865#2,2:417\n1869#2,2:419\n1#3:421\n*S KotlinDebug\n*F\n+ 1 VisualWindowPanel.kt\napp/termora/terminal/panel/vw/VisualWindowPanel\n*L\n178#1:407,4\n180#1:411\n180#1:412,2\n180#1:414,2\n186#1:416\n186#1:417,2\n186#1:419,2\n*E\n"})
public class VisualWindowPanel
extends JPanel
implements VisualWindow {
    @NotNull
    private final String id;
    @NotNull
    private final VisualWindowManager visualWindowManager;
    private final int stickPx;
    @NotNull
    private final JLabel titleLabel;
    @NotNull
    private final FlatToolBar toolbar;
    @NotNull
    private final VisualWindowResizer resizer;
    private boolean isWindow;
    @Nullable
    private VisualWindowDialog dialog;
    @NotNull
    private Rectangle oldBounds;
    @NotNull
    private JButton toggleWindowBtn;
    @NotNull
    private final JButton closeBtn;
    @NotNull
    private final JButton alwaysTopBtn;
    @NotNull
    private final closeWindowListener.1 closeWindowListener;
    private boolean isStickHover;
    private boolean isStick;

    public VisualWindowPanel(@NotNull String id, @NotNull VisualWindowManager visualWindowManager) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)visualWindowManager, (String)"visualWindowManager");
        super(new BorderLayout());
        this.id = id;
        this.visualWindowManager = visualWindowManager;
        this.stickPx = 2;
        this.titleLabel = new JLabel();
        this.toolbar = new FlatToolBar();
        this.resizer = new VisualWindowResizer(this.getVisualWindow(), (Function0<Boolean>)((Function0)() -> VisualWindowPanel.resizer$lambda$0(this)));
        this.oldBounds = new Rectangle();
        this.toggleWindowBtn = new JButton((Icon)((Object)Icons.INSTANCE.getOpenInNewWindow()));
        this.closeBtn = new JButton((Icon)((Object)Icons.INSTANCE.getClose()));
        this.alwaysTopBtn = new JButton((Icon)((Object)Icons.INSTANCE.getMoveUp()));
        this.closeWindowListener = new WindowAdapter(this){
            final /* synthetic */ VisualWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close();
            }
        };
    }

    @NotNull
    protected final String getId() {
        return this.id;
    }

    @NotNull
    protected final VisualWindowManager getVisualWindowManager() {
        return this.visualWindowManager;
    }

    @NotNull
    protected final DatabaseManager.Properties getProperties() {
        return DatabaseManager.Companion.getInstance().getProperties();
    }

    private final VisualWindowPanel getVisualWindow() {
        return this;
    }

    private final void setWindow(boolean value) {
        boolean oldValue = this.isWindow;
        this.isWindow = value;
        this.firePropertyChange("isWindow", oldValue, value);
    }

    private final boolean isAlwaysTop() {
        return Boolean.parseBoolean(this.getProperties().getString("VisualWindow." + this.id + ".dialog.isAlwaysTop", "false"));
    }

    private final void setAlwaysTop(boolean value) {
        this.getProperties().putString("VisualWindow." + this.id + ".dialog.isAlwaysTop", String.valueOf(value));
    }

    protected boolean isStickHover() {
        return this.isStickHover;
    }

    protected void setStickHover(boolean value) {
        if (value == this.isStickHover) {
            return;
        }
        this.isStickHover = value;
        this.reassemble();
    }

    protected final boolean isStick() {
        return this.isStick;
    }

    private final void setStick(boolean value) {
        if (this.isStick == value) {
            return;
        }
        if (!value) {
            this.setStickHover(false);
        }
        this.isStick = value;
        this.reassemble();
    }

    protected final boolean getExpand() {
        return this.isWindow || this.isStickHover() || !this.isStick;
    }

    @NotNull
    protected final String getTitle() {
        String string = this.titleLabel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    protected final void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.titleLabel.setText(value);
    }

    protected final void initVisualWindowPanel() {
        this.initViews();
        this.initEvents();
        this.initToolBar();
    }

    private final void initViews() {
        int h;
        this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        Integer n = StringsKt.toIntOrNull((String)this.getProperties().getString("VisualWindow." + this.id + ".location.x", "-1"));
        int x = n != null ? n : -1;
        Integer n2 = StringsKt.toIntOrNull((String)this.getProperties().getString("VisualWindow." + this.id + ".location.y", "-1"));
        int y = n2 != null ? n2 : -1;
        Integer n3 = StringsKt.toIntOrNull((String)this.getProperties().getString("VisualWindow." + this.id + ".location.width", "-1"));
        int w = n3 != null ? n3 : -1;
        Integer n4 = StringsKt.toIntOrNull((String)this.getProperties().getString("VisualWindow." + this.id + ".location.height", "-1"));
        int n5 = h = n4 != null ? n4 : -1;
        if (x >= 0 && y >= 0) {
            this.setLocation(x, y);
        } else {
            this.setLocation(200, 200);
        }
        if (w > 0 && h > 0) {
            this.setSize(w, h);
        } else {
            this.setSize(400, 200);
        }
        Rectangle rectangle = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
        this.oldBounds = rectangle;
        this.alwaysTopBtn.setSelected(this.isAlwaysTop());
        this.alwaysTopBtn.setVisible(false);
        this.closeBtn.setToolTipText(I18n.INSTANCE.getString("termora.tabbed.contextmenu.close"));
    }

    @NotNull
    protected List<Pair<JButton, Position>> toolbarButtons() {
        return CollectionsKt.emptyList();
    }

    private final void initEvents() {
        DragListener dragListener = new DragListener();
        this.toolbar.addMouseListener((MouseListener)dragListener);
        this.toolbar.addMouseMotionListener((MouseMotionListener)dragListener);
        AWTEventListener awtEventListener2 = new AWTEventListener(this){
            final /* synthetic */ VisualWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void eventDispatched(AWTEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof MouseEvent) {
                    if (((MouseEvent)event).getID() == 501) {
                        Component component = ((MouseEvent)event).getComponent();
                        if (component == null) {
                            return;
                        }
                        Component c = component;
                        if (SwingUtilities.isDescendingFrom(c, VisualWindowPanel.access$getVisualWindow(this.this$0))) {
                            this.this$0.getVisualWindowManager().moveToFront(VisualWindowPanel.access$getVisualWindow(this.this$0));
                        }
                    } else if (((MouseEvent)event).getID() == 503 && this.this$0.isStick() && !VisualWindowPanel.access$isWindow$p(this.this$0)) {
                        Component component = ((MouseEvent)event).getComponent();
                        if (component == null) {
                            return;
                        }
                        Component c = component;
                        this.this$0.setStickHover(SwingUtilities.isDescendingFrom(c, VisualWindowPanel.access$getVisualWindow(this.this$0)));
                    }
                }
            }
        };
        this.getToolkit().addAWTEventListener(awtEventListener2, 48L);
        Disposer.register(this, new Disposable(this, awtEventListener2){
            final /* synthetic */ VisualWindowPanel this$0;
            final /* synthetic */ initEvents.awtEventListener.1 $awtEventListener;
            {
                this.this$0 = $receiver;
                this.$awtEventListener = $awtEventListener;
            }

            public void dispose() {
                this.this$0.getToolkit().removeAWTEventListener(this.$awtEventListener);
            }
        });
        this.addMouseListener(new MouseAdapter(){});
        this.toggleWindowBtn.addActionListener(arg_0 -> VisualWindowPanel.initEvents$lambda$0(this, arg_0));
        this.toggleWindowBtn.setToolTipText(I18n.INSTANCE.getString("termora.visual-window.toggle-window"));
        this.addPropertyChangeListener("isWindow", arg_0 -> VisualWindowPanel.initEvents$lambda$1(this, arg_0));
        this.addPropertyChangeListener("ancestor", new PropertyChangeListener(this){
            final /* synthetic */ VisualWindowPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChange(PropertyChangeEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                this.this$0.removePropertyChangeListener("ancestor", this);
                boolean isStick = Boolean.parseBoolean(this.this$0.getProperties().getString("VisualWindow." + this.this$0.getId() + ".stick", "false"));
                if (isStick && this.this$0.getBounds().y <= VisualWindowPanel.access$getStickPx$p(this.this$0)) {
                    VisualWindowPanel.access$setStick(VisualWindowPanel.access$getVisualWindow(this.this$0), true);
                }
            }
        });
        this.alwaysTopBtn.addActionListener(arg_0 -> VisualWindowPanel.initEvents$lambda$2(this, arg_0));
        this.closeBtn.addActionListener(arg_0 -> VisualWindowPanel.initEvents$lambda$3(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void initToolBar() {
        Pair it;
        Iterable $this$filterTo$iv$iv;
        Object it2;
        int n;
        void $this$count$iv;
        List<Pair<JButton, Position>> buttons = this.toolbarButtons();
        Iterable iterable = buttons;
        int n2 = 2 + buttons.size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it2 = (Pair)element$iv;
                boolean bl = false;
                if (!(it2.getSecond() == Position.Left) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        int count = n2 - n3 * 2;
        this.toolbar.add((Component)this.alwaysTopBtn);
        Iterable $this$filter$iv = buttons;
        boolean $i$f$filter = false;
        Iterable count$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        it2 = $this$filterTo$iv$iv.iterator();
        while (it2.hasNext()) {
            Object element$iv$iv = it2.next();
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(it.getSecond() == Position.Left)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it3 = (Pair)element$iv;
            boolean bl = false;
            this.toolbar.add((Component)it3.getFirst());
        }
        this.toolbar.add(Box.createHorizontalStrut(Math.max(count * 26, 0)));
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)this.titleLabel);
        this.toolbar.add(Box.createHorizontalGlue());
        $this$filter$iv = buttons;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getSecond() == Position.Right)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it4 = (Pair)element$iv;
            boolean bl3 = false;
            this.toolbar.add((Component)it4.getFirst());
        }
        this.toolbar.add((Component)this.toggleWindowBtn);
        this.toolbar.add((Component)this.closeBtn);
        this.toolbar.setBorder((Border)BorderFactory.createMatteBorder(0, 0, 1, 0, DynamicColor.Companion.getBorderColor()));
        this.add((Component)this.toolbar, "North");
    }

    @Override
    public void dispose() {
        Rectangle bounds = this.isWindow || this.isStick ? this.oldBounds : this.getBounds();
        this.getProperties().putString("VisualWindow." + this.id + ".location.x", String.valueOf(bounds.x));
        this.getProperties().putString("VisualWindow." + this.id + ".location.y", String.valueOf(bounds.y));
        this.getProperties().putString("VisualWindow." + this.id + ".location.width", String.valueOf(bounds.width));
        this.getProperties().putString("VisualWindow." + this.id + ".location.height", String.valueOf(bounds.height));
        this.getProperties().putString("VisualWindow." + this.id + ".stick", String.valueOf(this.isStick));
        this.resizer.uninstall();
        this.close();
    }

    @Override
    @NotNull
    public final JComponent getJComponent() {
        return this;
    }

    @Override
    public boolean isWindow() {
        return this.isWindow;
    }

    @Override
    @Nullable
    public Window getWindow() {
        return this.dialog;
    }

    @NotNull
    protected String getWindowTitle() {
        return this.id;
    }

    @Override
    public void toggleWindow() {
        if (this.isWindow) {
            VisualWindowDialog visualWindowDialog = this.dialog;
            if (visualWindowDialog != null) {
                visualWindowDialog.removeWindowListener(this.closeWindowListener);
            }
        }
        this.setWindow(!this.isWindow);
        VisualWindowDialog visualWindowDialog = this.dialog;
        if (visualWindowDialog != null) {
            visualWindowDialog.dispose();
        }
        this.dialog = null;
        this.alwaysTopBtn.setVisible(this.isWindow);
        if (this.isWindow) {
            VisualWindowDialog visualWindowDialog2;
            Rectangle rectangle = this.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
            this.oldBounds = rectangle;
            this.visualWindowManager.rebaseVisualWindow(this);
            if (this.isStickHover()) {
                this.setStickHover(false);
            } else {
                this.reassemble();
            }
            VisualWindowDialog $this$toggleWindow_u24lambda_u240 = visualWindowDialog2 = new VisualWindowDialog();
            boolean bl = false;
            this.dialog = $this$toggleWindow_u24lambda_u240;
            VisualWindowDialog dialog2 = visualWindowDialog2;
            dialog2.addWindowListener(this.closeWindowListener);
            dialog2.setVisible(true);
        } else {
            this.setBounds(this.oldBounds);
            this.visualWindowManager.removeVisualWindow(this.getVisualWindow());
            this.visualWindowManager.addVisualWindow(this.getVisualWindow());
            this.reassemble();
        }
    }

    protected void reassemble() {
        if (this.getExpand()) {
            this.setBorder(BorderFactory.createMatteBorder(this.isStickHover() ? 0 : 1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
            this.getVisualWindow().setBounds(this.getBounds().x, this.getBounds().y, this.oldBounds.width, this.oldBounds.height);
        } else {
            Rectangle bounds = this.getVisualWindow().getBounds();
            this.getVisualWindow().setBounds(bounds.x, bounds.y, bounds.width, Math.max(this.toolbar.getHeight(), this.toolbar.getPreferredSize().height));
            this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        }
        SwingUtilities.invokeLater(() -> VisualWindowPanel.reassemble$lambda$0(this));
    }

    protected boolean beforeClose() {
        return true;
    }

    protected void close() {
        if (this.isWindow()) {
            VisualWindowDialog visualWindowDialog = this.dialog;
            if (visualWindowDialog != null) {
                visualWindowDialog.dispose();
            }
            this.dialog = null;
        }
        this.visualWindowManager.removeVisualWindow(this.getVisualWindow());
    }

    @Override
    @NotNull
    public String getWindowName() {
        return this.id;
    }

    private static final boolean resizer$lambda$0(VisualWindowPanel this$0) {
        return !this$0.isWindow && !this$0.isStick;
    }

    private static final void initEvents$lambda$0(VisualWindowPanel this$0, ActionEvent it) {
        this$0.toggleWindow();
    }

    private static final void initEvents$lambda$1(VisualWindowPanel this$0, PropertyChangeEvent it) {
        if (this$0.isWindow) {
            this$0.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()));
            this$0.toggleWindowBtn.setIcon((Icon)((Object)Icons.INSTANCE.getOpenInToolWindow()));
        } else {
            this$0.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
            this$0.toggleWindowBtn.setIcon((Icon)((Object)Icons.INSTANCE.getOpenInNewWindow()));
        }
    }

    private static final void initEvents$lambda$2(VisualWindowPanel this$0, ActionEvent it) {
        block1: {
            this$0.setAlwaysTop(!this$0.isAlwaysTop());
            this$0.alwaysTopBtn.setSelected(this$0.isAlwaysTop());
            if (!this$0.isWindow()) break block1;
            VisualWindowDialog visualWindowDialog = this$0.dialog;
            if (visualWindowDialog != null) {
                visualWindowDialog.setAlwaysOnTop(this$0.isAlwaysTop());
            }
        }
    }

    private static final void initEvents$lambda$3(VisualWindowPanel this$0, ActionEvent it) {
        if (this$0.beforeClose()) {
            Disposer.dispose(this$0.getVisualWindow());
        }
    }

    private static final void reassemble$lambda$0(VisualWindowPanel this$0) {
        SwingUtilities.updateComponentTreeUI(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/panel/vw/VisualWindowPanel$DragListener;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lapp/termora/terminal/panel/vw/VisualWindowPanel;)V", "startPoint", "Ljava/awt/Point;", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseReleased", "termora"})
    private final class DragListener
    extends MouseAdapter {
        @Nullable
        private Point startPoint;

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (VisualWindowPanel.this.isWindow) {
                this.startPoint = null;
                return;
            }
            this.startPoint = SwingUtilities.convertPoint(VisualWindowPanel.this.getVisualWindow(), e.getPoint(), VisualWindowPanel.this.getVisualWindow().getParent());
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Point point = this.startPoint;
            if (point == null) {
                return;
            }
            Point startPoint = point;
            Point newPoint = SwingUtilities.convertPoint(VisualWindowPanel.this.getVisualWindow(), e.getPoint(), VisualWindowPanel.this.getVisualWindow().getParent());
            Dimension dimension = VisualWindowPanel.this.getVisualWindowManager().getDimension();
            int x = Math.min(VisualWindowPanel.this.getVisualWindow().getX() + (newPoint.x - startPoint.x), dimension.width - VisualWindowPanel.this.getVisualWindow().getWidth());
            int y = Math.min(VisualWindowPanel.this.getVisualWindow().getY() + (newPoint.y - startPoint.y), dimension.height - VisualWindowPanel.this.getVisualWindow().getHeight());
            if (VisualWindowPanel.this.isStick()) {
                if (y > VisualWindowPanel.this.stickPx) {
                    VisualWindowPanel.this.setStick(false);
                    return;
                }
            } else {
                Rectangle rectangle = VisualWindowPanel.this.getVisualWindow().getBounds();
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getBounds(...)");
                VisualWindowPanel.this.oldBounds = rectangle;
            }
            VisualWindowPanel.this.setBorder(BorderFactory.createMatteBorder(y <= 0 ? 0 : 1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
            VisualWindowPanel.this.getVisualWindow().setBounds(Math.max(x, 0), Math.max(y, 0), VisualWindowPanel.this.getVisualWindow().getWidth(), VisualWindowPanel.this.getVisualWindow().getHeight());
            this.startPoint = newPoint;
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VisualWindowPanel.this.getVisualWindowManager().moveToFront(VisualWindowPanel.this.getVisualWindow());
            VisualWindowPanel.this.setStick(((VisualWindowPanel)VisualWindowPanel.this).getVisualWindow().getBounds().y <= VisualWindowPanel.this.stickPx);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/terminal/panel/vw/VisualWindowPanel$Position;", "", "<init>", "(Ljava/lang/String;I)V", "Left", "Right", "termora"})
    protected static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position Left = new Position();
        public static final /* enum */ Position Right = new Position();
        private static final /* synthetic */ Position[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String value) {
            return Enum.valueOf(Position.class, value);
        }

        @NotNull
        public static EnumEntries<Position> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = positionArray = new Position[]{Position.Left, Position.Right};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\t"}, d2={"Lapp/termora/terminal/panel/vw/VisualWindowPanel$VisualWindowDialog;", "Lapp/termora/DialogWrapper;", "<init>", "(Lapp/termora/terminal/panel/vw/VisualWindowPanel;)V", "initEvents", "", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "termora"})
    @SourceDebugExtension(value={"SMAP\nVisualWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualWindowPanel.kt\napp/termora/terminal/panel/vw/VisualWindowPanel$VisualWindowDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,406:1\n1617#2,9:407\n1869#2:416\n1870#2:419\n1626#2:420\n1#3:417\n1#3:418\n*S KotlinDebug\n*F\n+ 1 VisualWindowPanel.kt\napp/termora/terminal/panel/vw/VisualWindowPanel$VisualWindowDialog\n*L\n355#1:407,9\n355#1:416\n355#1:419\n355#1:420\n355#1:418\n*E\n"})
    private final class VisualWindowDialog
    extends DialogWrapper {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public VisualWindowDialog() {
            int h;
            super((Window)null);
            this.setModal(false);
            this.setControlsVisible(false);
            this.setResizable(true);
            this.setTitle(VisualWindowPanel.this.getWindowTitle());
            this.setAlwaysOnTop(VisualWindowPanel.this.isAlwaysTop());
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                void $this$mapNotNullTo$iv$iv;
                Object[] objectArray = new Integer[]{16, 20, 24, 28, 32, 48, 64, 128};
                List sizes = CollectionsKt.listOf((Object[])objectArray);
                ClassLoader loader = TermoraFrame.class.getClassLoader();
                Iterable $this$mapNotNull$iv = sizes;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    BufferedImage bufferedImage;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    int e = ((Number)element$iv$iv).intValue();
                    boolean bl2 = false;
                    InputStream inputStream = loader.getResourceAsStream("icons/termora_" + e + "x" + e + ".png");
                    if (inputStream != null) {
                        Closeable closeable = inputStream;
                        Throwable throwable = null;
                        try {
                            InputStream it = (InputStream)closeable;
                            boolean bl3 = false;
                            BufferedImage bufferedImage2 = ImageIO.read(it);
                            bufferedImage = bufferedImage2;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    } else {
                        bufferedImage = null;
                    }
                    if (bufferedImage == null) continue;
                    BufferedImage it$iv$iv = bufferedImage;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List images = (List)destination$iv$iv;
                this.setIconImages(images);
            }
            this.initEvents();
            this.init();
            Integer n = StringsKt.toIntOrNull((String)VisualWindowPanel.this.getProperties().getString("VisualWindow." + VisualWindowPanel.this.getId() + ".dialog.location.x", "-1"));
            int x = n != null ? n : -1;
            Integer n2 = StringsKt.toIntOrNull((String)VisualWindowPanel.this.getProperties().getString("VisualWindow." + VisualWindowPanel.this.getId() + ".dialog.location.y", "-1"));
            int y = n2 != null ? n2 : -1;
            Integer n3 = StringsKt.toIntOrNull((String)VisualWindowPanel.this.getProperties().getString("VisualWindow." + VisualWindowPanel.this.getId() + ".dialog.location.width", "-1"));
            int w = n3 != null ? n3 : -1;
            Integer n4 = StringsKt.toIntOrNull((String)VisualWindowPanel.this.getProperties().getString("VisualWindow." + VisualWindowPanel.this.getId() + ".dialog.location.height", "-1"));
            int n5 = h = n4 != null ? n4 : -1;
            if (w > 0 && h > 0) {
                this.setSize(w, h);
            } else {
                this.pack();
            }
            if (x >= 0 && y >= 0) {
                this.setLocation(x, y);
            } else {
                this.setLocationRelativeTo(null);
            }
        }

        private final void initEvents() {
            this.addWindowListener(new WindowAdapter(VisualWindowPanel.this, this){
                final /* synthetic */ VisualWindowPanel this$0;
                final /* synthetic */ VisualWindowDialog this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void windowClosed(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.getProperties().putString("VisualWindow." + this.this$0.getId() + ".dialog.location.x", String.valueOf(this.this$1.getX()));
                    this.this$0.getProperties().putString("VisualWindow." + this.this$0.getId() + ".dialog.location.y", String.valueOf(this.this$1.getY()));
                    this.this$0.getProperties().putString("VisualWindow." + this.this$0.getId() + ".dialog.location.width", String.valueOf(this.this$1.getWidth()));
                    this.this$0.getProperties().putString("VisualWindow." + this.this$0.getId() + ".dialog.location.height", String.valueOf(this.this$1.getHeight()));
                }
            });
        }

        @Override
        @NotNull
        protected JComponent createCenterPanel() {
            return VisualWindowPanel.this.getJComponent();
        }

        @Override
        @Nullable
        protected JComponent createSouthPanel() {
            return null;
        }
    }
}

