/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel.vw;

import app.termora.Application;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.FileChooser;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.NativeMacLibrary;
import app.termora.OptionPane;
import app.termora.ScopeKt;
import app.termora.SwingUtils;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProvider;
import app.termora.actions.DataProviderSupport;
import app.termora.actions.DataProviders;
import app.termora.plugin.internal.badge.Badge;
import app.termora.plugin.internal.badge.BadgePresentation;
import app.termora.plugin.internal.ssh.SSHTerminalTab;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.terminal.panel.vw.SSHVisualWindow;
import app.termora.terminal.panel.vw.TransferVisualWindow;
import app.termora.terminal.panel.vw.VisualWindowManager;
import app.termora.terminal.panel.vw.VisualWindowPanel;
import app.termora.transfer.DefaultInternalTransferManager;
import app.termora.transfer.DefaultTransportSupport;
import app.termora.transfer.InternalTransferManager;
import app.termora.transfer.TransferListener;
import app.termora.transfer.TransferTable;
import app.termora.transfer.TransferTableModel;
import app.termora.transfer.TransportPanel;
import app.termora.transfer.TransportPopupMenu;
import app.termora.transfer.TransportSupport;
import app.termora.transfer.TransportSupportLoader;
import app.termora.transfer.TransportTableModel;
import app.termora.transfer.TransportViewer;
import com.formdev.flatlaf.icons.FlatOptionPaneErrorIcon;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClasses;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0006GHIJKLB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u000202H\u0002J\b\u00104\u001a\u000202H\u0002J\u000e\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u00107J\n\u00108\u001a\u0004\u0018\u000109H\u0002J\b\u0010:\u001a\u00020+H\u0014J\b\u0010;\u001a\u000202H\u0016J\b\u0010<\u001a\u000202H\u0014J'\u0010=\u001a\u0004\u0018\u0001H>\"\b\b\u0000\u0010>*\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H>0AH\u0016\u00a2\u0006\u0002\u0010BJ\u001a\u0010C\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020F0E0DH\u0014R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u00060\u0017R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00070\u001b\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\n \u000b*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\n \u000b*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020+8T@TX\u0094\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010.\"\u0004\b/\u00100\u00a8\u0006M"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow;", "Lapp/termora/terminal/panel/vw/SSHVisualWindow;", "Lapp/termora/actions/DataProvider;", "tab", "Lapp/termora/plugin/internal/ssh/SSHTerminalTab;", "visualWindowManager", "Lapp/termora/terminal/panel/vw/VisualWindowManager;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHTerminalTab;Lapp/termora/terminal/panel/vw/VisualWindowManager;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "coroutineDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "cardLayout", "Ljava/awt/CardLayout;", "panel", "Ljavax/swing/JPanel;", "connectingPanel", "Lapp/termora/terminal/panel/vw/TransferVisualWindow$ConnectingPanel;", "connectFailedPanel", "Lapp/termora/terminal/panel/vw/TransferVisualWindow$ConnectFailedPanel;", "transferManager", "Lapp/termora/transfer/TransferTableModel;", "disposable", "Lapp/termora/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "focusedWindow", "Ljava/awt/Window;", "getFocusedWindow", "()Ljava/awt/Window;", "owner", "getOwner", "questionBtn", "Ljavax/swing/JButton;", "downloadBtn", "badgePresentation", "Lapp/termora/plugin/internal/badge/BadgePresentation;", "support", "Lapp/termora/actions/DataProviderSupport;", "isShowPopupMenu", "", "value", "isStickHover", "()Z", "setStickHover", "(Z)V", "initViews", "", "initEvents", "connect", "getSession", "Lorg/apache/sshd/client/session/ClientSession;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTransportNavigator", "Lapp/termora/transfer/TransportPanel;", "beforeClose", "dispose", "reassemble", "getData", "T", "", "dataKey", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "toolbarButtons", "", "Lkotlin/Pair;", "Lapp/termora/terminal/panel/vw/VisualWindowPanel$Position;", "Companion", "State", "DownloadDialog", "MyInternalTransferManager", "ConnectingPanel", "ConnectFailedPanel", "termora"})
@SourceDebugExtension(value={"SMAP\nTransferVisualWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransferVisualWindow.kt\napp/termora/terminal/panel/vw/TransferVisualWindow\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,579:1\n1#2:580\n*E\n"})
public final class TransferVisualWindow
extends SSHVisualWindow
implements DataProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final ExecutorService executorService;
    @NotNull
    private final ExecutorCoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CardLayout cardLayout;
    @NotNull
    private final JPanel panel;
    @NotNull
    private final ConnectingPanel connectingPanel;
    @NotNull
    private final ConnectFailedPanel connectFailedPanel;
    @NotNull
    private final TransferTableModel transferManager;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JButton questionBtn;
    @NotNull
    private final JButton downloadBtn;
    @NotNull
    private final BadgePresentation badgePresentation;
    @NotNull
    private final DataProviderSupport support;
    private boolean isShowPopupMenu;
    private static final Logger log = LoggerFactory.getLogger(TransferVisualWindow.class);

    /*
     * WARNING - void declaration
     */
    public TransferVisualWindow(@NotNull SSHTerminalTab tab, @NotNull VisualWindowManager visualWindowManager) {
        void $this$badgePresentation_u24lambda_u240;
        BadgePresentation badgePresentation;
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)visualWindowManager, (String)"visualWindowManager");
        super(tab, "Transfer", visualWindowManager);
        ExecutorService executorService = this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
        this.coroutineDispatcher = ExecutorsKt.from((ExecutorService)executorService);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher));
        this.cardLayout = new CardLayout();
        this.panel = new JPanel(this.cardLayout);
        this.connectingPanel = new ConnectingPanel();
        this.connectFailedPanel = new ConnectFailedPanel();
        this.transferManager = new TransferTableModel(this.coroutineScope);
        Disposable disposable2 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"newDisposable(...)");
        this.disposable = disposable2;
        this.questionBtn = new JButton((Icon)((Object)Icons.INSTANCE.getQuestionMark()));
        this.downloadBtn = new JButton((Icon)((Object)Icons.INSTANCE.getDownload()));
        BadgePresentation badgePresentation2 = badgePresentation = Badge.Companion.getInstance(tab.getWindowScope()).addBadge(this.downloadBtn);
        TransferVisualWindow transferVisualWindow = this;
        boolean bl = false;
        $this$badgePresentation_u24lambda_u240.setVisible(false);
        transferVisualWindow.badgePresentation = badgePresentation;
        this.support = new DataProviderSupport();
        this.initViews();
        this.initEvents();
        this.initVisualWindowPanel();
    }

    private final Window getFocusedWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    @Override
    protected boolean isStickHover() {
        return super.isStickHover();
    }

    @Override
    protected void setStickHover(boolean value) {
        if (this.isShowPopupMenu || !Intrinsics.areEqual((Object)this.getOwner(), (Object)this.getFocusedWindow())) {
            super.setStickHover(true);
        } else {
            super.setStickHover(value);
        }
    }

    private final void initViews() {
        this.setTitle("SFTP");
        this.panel.add((Component)this.connectingPanel, "Connecting");
        this.panel.add((Component)this.connectFailedPanel, "Failed");
        this.add((Component)this.panel, "Center");
        this.support.addData(TransportViewer.Companion.getMyTransferManager(), this.transferManager);
    }

    private final void initEvents() {
        Disposer.register(this.getTab(), this);
        Disposer.register(this, this.disposable);
        Disposer.register(this.disposable, this.transferManager);
        Disposer.register(this.disposable, this.badgePresentation);
        this.connectingPanel.getBusyLabel().setBusy(true);
        TerminalPanel terminalPanel = this.getTab().getData(DataProviders.INSTANCE.getTerminalPanel());
        Terminal terminal = terminalPanel != null ? terminalPanel.getData(DataProviders.INSTANCE.getTerminal()) : null;
        Object object = terminal;
        if (object != null && (object = object.getTerminalModel()) != null) {
            object.addDataListener(new DataListener(this){
                final /* synthetic */ TransferVisualWindow this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onChanged(DataKey<?> key, Object data) {
                    Intrinsics.checkNotNullParameter(key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    if (Intrinsics.areEqual(key, DataKey.Companion.getCurrentDir())) {
                        String dir = (String)KClasses.cast(DataKey.Companion.getCurrentDir().getClazz(), (Object)data);
                        TransportPanel transportPanel2 = TransferVisualWindow.access$getTransportNavigator(this.this$0);
                        if (transportPanel2 == null) {
                            return;
                        }
                        TransportPanel navigator = transportPanel2;
                        TransportSupportLoader loader = navigator.getLoader();
                        if (!loader.isOpened()) {
                            return;
                        }
                        FileSystem fileSystem = loader.getSyncTransportSupport().getFileSystem();
                        Path path = fileSystem.getPath(dir, new String[0]);
                        Intrinsics.checkNotNull((Object)path);
                        navigator.navigateTo(((Object)path.toAbsolutePath()).toString());
                    }
                }
            });
        }
        this.downloadBtn.addActionListener(new AbstractAction(this){
            final /* synthetic */ TransferVisualWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DownloadDialog dialog2 = this.this$0.new DownloadDialog();
                dialog2.setIconImages(TransferVisualWindow.access$getOwner(this.this$0).getIconImages());
                dialog2.setLocationRelativeTo(TransferVisualWindow.access$getDownloadBtn$p(this.this$0));
                dialog2.setLocation(dialog2.getX(), TransferVisualWindow.access$getDownloadBtn$p((TransferVisualWindow)this.this$0).getLocationOnScreen().y + TransferVisualWindow.access$getDownloadBtn$p(this.this$0).getHeight() + 2);
                dialog2.setVisible(true);
            }
        });
        this.transferManager.addTransferListener(new TransferListener(this){
            final /* synthetic */ TransferVisualWindow this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTransferCountChanged() {
                boolean newVisible;
                boolean oldVisible = TransferVisualWindow.access$getBadgePresentation$p(this.this$0).getVisible();
                boolean bl = newVisible = TransferVisualWindow.access$getTransferManager$p(this.this$0).getTransferCount() > 0;
                if (oldVisible != newVisible) {
                    TransferVisualWindow.access$getBadgePresentation$p(this.this$0).setVisible(newVisible);
                    TransferVisualWindow.access$getDownloadBtn$p(this.this$0).repaint();
                }
            }
        });
        this.questionBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                URI uRI = URI.create("https://github.com/TermoraDev/termora/pull/690");
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
            }
        });
        this.questionBtn.setToolTipText(I18n.INSTANCE.getString("termora.visual-window.transport.question"));
        this.connect();
    }

    private final void connect() {
        this.connectingPanel.getBusyLabel().setBusy(true);
        this.cardLayout.show(this.panel, "Connecting");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ TransferVisualWindow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = TransferVisualWindow.access$getSession(this.this$0, (Continuation)this);
                        ** if (v0 != var5_2) goto lbl11
lbl10:
                        // 1 sources

                        return var5_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        session = (ClientSession)v0;
                        fileSystem = SftpClientFactory.instance().createSftpFileSystem(session);
                        Intrinsics.checkNotNull((Object)fileSystem);
                        v1 = (FileSystem)fileSystem;
                        v2 = fileSystem.getDefaultDir();
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getDefaultDir(...)");
                        support = new DefaultTransportSupport(v1, (Path)v2);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)fileSystem);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)support);
                        this.label = 2;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, session, support, fileSystem, null){
                            int label;
                            final /* synthetic */ TransferVisualWindow this$0;
                            final /* synthetic */ ClientSession $session;
                            final /* synthetic */ DefaultTransportSupport $support;
                            final /* synthetic */ SftpFileSystem $fileSystem;
                            {
                                this.this$0 = $receiver;
                                this.$session = $session;
                                this.$support = $support;
                                this.$fileSystem = $fileSystem;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        MyInternalTransferManager internalTransferManager = this.this$0.new MyInternalTransferManager();
                                        Host host = this.this$0.getTab().getHost();
                                        TransportSupportLoader transportSupportLoader = new TransportSupportLoader(this.$support){
                                            final /* synthetic */ DefaultTransportSupport $support;
                                            {
                                                this.$support = $support;
                                            }

                                            public Object getTransportSupport(Continuation<? super TransportSupport> $completion) {
                                                return this.$support;
                                            }

                                            public TransportSupport getSyncTransportSupport() {
                                                return this.$support;
                                            }

                                            public boolean isLoaded() {
                                                return true;
                                            }
                                        };
                                        TransportPanel transportPanel2 = new TransportPanel(internalTransferManager, this.this$0, host, transportSupportLoader){
                                            final /* synthetic */ TransferVisualWindow this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super($internalTransferManager, $super_call_param$1, $super_call_param$2);
                                            }

                                            protected void customizeContextmenu(Integer[] rows, MouseEvent e, TransportPopupMenu popupMenu) {
                                                Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
                                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                                Intrinsics.checkNotNullParameter((Object)((Object)popupMenu), (String)"popupMenu");
                                                popupMenu.addPopupMenuListener(new PopupMenuListener(this.this$0){
                                                    final /* synthetic */ TransferVisualWindow this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                    }

                                                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                                                        TransferVisualWindow.access$setShowPopupMenu$p(this.this$0, true);
                                                    }

                                                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                                                        TransferVisualWindow.access$setShowPopupMenu$p(this.this$0, false);
                                                    }

                                                    public void popupMenuCanceled(PopupMenuEvent e) {
                                                        TransferVisualWindow.access$setShowPopupMenu$p(this.this$0, false);
                                                    }
                                                });
                                            }
                                        };
                                        internalTransferManager.setTransferPanel(transportPanel2);
                                        Disposer.register(transportPanel2, new Disposable(this.this$0, transportPanel2, this.$fileSystem){
                                            final /* synthetic */ TransferVisualWindow this$0;
                                            final /* synthetic */ connect.transportPanel.1 $transportPanel;
                                            final /* synthetic */ SftpFileSystem $fileSystem;
                                            {
                                                this.this$0 = $receiver;
                                                this.$transportPanel = $transportPanel;
                                                this.$fileSystem = $fileSystem;
                                            }

                                            public void dispose() {
                                                TransferVisualWindow.access$getPanel$p(this.this$0).remove(this.$transportPanel);
                                                IOUtils.closeQuietly((Closeable)((Closeable)this.$fileSystem));
                                                BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                    int label;
                                                    final /* synthetic */ TransferVisualWindow this$0;
                                                    {
                                                        this.this$0 = $receiver;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object $result) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                TransferVisualWindow.access$getConnectFailedPanel$p(this.this$0).getErrorLabel().setText(I18n.INSTANCE.getString("termora.transport.sftp.closed"));
                                                                TransferVisualWindow.access$getCardLayout$p(this.this$0).show(TransferVisualWindow.access$getPanel$p(this.this$0), "Failed");
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (int)3, null);
                                            }
                                        });
                                        Disposer.register(TransferVisualWindow.access$getDisposable$p(this.this$0), transportPanel2);
                                        this.$session.addCloseFutureListener(arg_0 -> connect.1.invokeSuspend$lambda$0(transportPanel2, arg_0));
                                        TransferVisualWindow.access$getPanel$p(this.this$0).add((Component)transportPanel2, "Transfer");
                                        TransferVisualWindow.access$getCardLayout$p(this.this$0).show(TransferVisualWindow.access$getPanel$p(this.this$0), "Transfer");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final void invokeSuspend$lambda$0(connect.transportPanel.1 $transportPanel, CloseFuture it) {
                                Disposer.dispose($transportPanel);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v3 != var5_2) goto lbl31
lbl30:
                        // 1 sources

                        return var5_2;
lbl31:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 2: {
                        support = (DefaultTransportSupport)this.L$2;
                        fileSystem = (SftpFileSystem)this.L$1;
                        session = (ClientSession)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
                        }
                        catch (Exception e) {
                            if (TransferVisualWindow.access$getLog$cp().isErrorEnabled()) {
                                TransferVisualWindow.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 3;
                            v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, e, null){
                                int label;
                                final /* synthetic */ TransferVisualWindow this$0;
                                final /* synthetic */ Exception $e;
                                {
                                    this.this$0 = $receiver;
                                    this.$e = $e;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            TransferVisualWindow.access$getConnectFailedPanel$p(this.this$0).getErrorLabel().setText(ExceptionUtils.getRootCauseMessage((Throwable)this.$e));
                                            TransferVisualWindow.access$getCardLayout$p(this.this$0).show(TransferVisualWindow.access$getPanel$p(this.this$0), "Failed");
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            ** if (v4 != var5_2) goto lbl54
lbl53:
                            // 1 sources

                            return var5_2;
lbl54:
                            // 1 sources

                            ** GOTO lbl65
                        }
lbl40:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TransferVisualWindow this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        TransferVisualWindow.access$getConnectingPanel$p(this.this$0).getBusyLabel().setBusy(false);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        ** GOTO lbl68
                    }
                    case 3: {
                        e = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
                        {
                            catch (Throwable var2_6) {
                                BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
                                throw var2_6;
                            }
                        }
lbl65:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), null, null, (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (int)3, null);
lbl68:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object getSession(Continuation<? super ClientSession> $completion) {
        block7: {
            if (!($completion instanceof getSession.1)) ** GOTO lbl-1000
            var4_2 = $completion;
            if ((var4_2.label & -2147483648) != 0) {
                var4_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ TransferVisualWindow this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TransferVisualWindow.access$getSession(this.this$0, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block0 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
lbl12:
                    // 3 sources

                    while (CoroutineScopeKt.isActive((CoroutineScope)this.coroutineScope)) {
                        session = this.getTab().getData(SSHTerminalTab.Companion.getSSHSession());
                        if (session != null) break block0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)session);
                        $continuation.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)250, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)$continuation);
                        if (v0 != var5_4) continue;
                        return var5_4;
                    }
                    break block7;
                }
                case 1: {
                    session = (ClientSession)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                    ** GOTO lbl12
                }
            }
            return session;
        }
        throw new IllegalStateException("Session is null");
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final TransportPanel getTransportNavigator() {
        int n = this.panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.panel.getComponent(i);
            if (!(c instanceof TransportPanel)) continue;
            return (TransportPanel)c;
        }
        return null;
    }

    @Override
    protected boolean beforeClose() {
        if (this.transferManager.getTransferCount() > 0) {
            String string;
            OptionPane optionPane = OptionPane.INSTANCE;
            Window window = this.getOwner();
            return OptionPane.showConfirmDialog$default(optionPane, window, string = I18n.INSTANCE.getString("termora.transport.sftp.close-tab"), null, 2, 3, null, null, null, null, 484, null) == 0;
        }
        return super.beforeClose();
    }

    @Override
    public void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.coroutineDispatcher.close();
        this.executorService.shutdownNow();
        this.connectingPanel.getBusyLabel().setBusy(false);
        super.dispose();
    }

    @Override
    protected void reassemble() {
        super.reassemble();
    }

    @Override
    @Nullable
    public <T> T getData(@NotNull DataKey<T> dataKey) {
        Intrinsics.checkNotNullParameter(dataKey, (String)"dataKey");
        return this.support.getData(dataKey);
    }

    @Override
    @NotNull
    protected List<Pair<JButton, VisualWindowPanel.Position>> toolbarButtons() {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)this.downloadBtn, (Object)((Object)VisualWindowPanel.Position.Left)), TuplesKt.to((Object)this.questionBtn, (Object)((Object)VisualWindowPanel.Position.Right))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public static final /* synthetic */ TransportPanel access$getTransportNavigator(TransferVisualWindow $this) {
        return $this.getTransportNavigator();
    }

    public static final /* synthetic */ JButton access$getDownloadBtn$p(TransferVisualWindow $this) {
        return $this.downloadBtn;
    }

    public static final /* synthetic */ BadgePresentation access$getBadgePresentation$p(TransferVisualWindow $this) {
        return $this.badgePresentation;
    }

    public static final /* synthetic */ Object access$getSession(TransferVisualWindow $this, Continuation $completion) {
        return $this.getSession((Continuation<? super ClientSession>)$completion);
    }

    public static final /* synthetic */ void access$setShowPopupMenu$p(TransferVisualWindow $this, boolean bl) {
        $this.isShowPopupMenu = bl;
    }

    public static final /* synthetic */ JPanel access$getPanel$p(TransferVisualWindow $this) {
        return $this.panel;
    }

    public static final /* synthetic */ ConnectFailedPanel access$getConnectFailedPanel$p(TransferVisualWindow $this) {
        return $this.connectFailedPanel;
    }

    public static final /* synthetic */ CardLayout access$getCardLayout$p(TransferVisualWindow $this) {
        return $this.cardLayout;
    }

    public static final /* synthetic */ Disposable access$getDisposable$p(TransferVisualWindow $this) {
        return $this.disposable;
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ ConnectingPanel access$getConnectingPanel$p(TransferVisualWindow $this) {
        return $this.connectingPanel;
    }

    public static final /* synthetic */ void access$connect(TransferVisualWindow $this) {
        $this.connect();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$ConnectFailedPanel;", "Ljavax/swing/JPanel;", "<init>", "(Lapp/termora/terminal/panel/vw/TransferVisualWindow;)V", "errorLabel", "Ljavax/swing/JLabel;", "getErrorLabel", "()Ljavax/swing/JLabel;", "initView", "", "termora"})
    private final class ConnectFailedPanel
    extends JPanel {
        @NotNull
        private final JLabel errorLabel;

        public ConnectFailedPanel() {
            super(new BorderLayout());
            this.errorLabel = new JLabel();
            this.initView();
        }

        @NotNull
        public final JLabel getErrorLabel() {
            return this.errorLabel;
        }

        /*
         * WARNING - void declaration
         */
        private final void initView() {
            void $this$initView_u24lambda_u240;
            String formMargin = "4dlu";
            FormLayout layout = new FormLayout("default:grow, pref, default:grow", "40dlu, pref, " + formMargin + ", pref, " + formMargin + ", pref");
            this.errorLabel.setHorizontalAlignment(0);
            FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
            builder2.add((Icon)new FlatOptionPaneErrorIcon()).xy(2, 2);
            builder2.add((Component)this.errorLabel).xyw(1, 4, 3, "fill, center");
            String string = I18n.INSTANCE.getString("termora.transport.sftp.retry");
            String string2 = string = new JXHyperlink((Action)new AbstractAction(TransferVisualWindow.this, string){
                final /* synthetic */ TransferVisualWindow this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TransferVisualWindow.access$connect(this.this$0);
                }
            });
            FormBuilder formBuilder = builder2;
            boolean bl = false;
            $this$initView_u24lambda_u240.setHorizontalAlignment(0);
            $this$initView_u24lambda_u240.setVerticalAlignment(0);
            $this$initView_u24lambda_u240.setFocusable(false);
            formBuilder.add((Component)((Object)string)).xy(2, 6);
            this.add((Component)builder2.build(), "Center");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$ConnectingPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "busyLabel", "Lorg/jdesktop/swingx/JXBusyLabel;", "getBusyLabel", "()Lorg/jdesktop/swingx/JXBusyLabel;", "initView", "", "termora"})
    private static final class ConnectingPanel
    extends JPanel {
        @NotNull
        private final JXBusyLabel busyLabel = new JXBusyLabel();

        public ConnectingPanel() {
            super(new BorderLayout());
            this.initView();
        }

        @NotNull
        public final JXBusyLabel getBusyLabel() {
            return this.busyLabel;
        }

        private final void initView() {
            String formMargin = "7dlu";
            FormLayout layout = new FormLayout("default:grow, pref, default:grow", "40dlu, pref, " + formMargin + ", pref");
            JLabel label = new JLabel(I18n.INSTANCE.getString("termora.transport.sftp.connecting"));
            label.setHorizontalAlignment(0);
            this.busyLabel.setHorizontalAlignment(0);
            this.busyLabel.setVerticalAlignment(0);
            FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
            builder2.add((Component)this.busyLabel).xy(2, 2, "fill, center");
            builder2.add((Component)label).xy(2, 4);
            this.add((Component)builder2.build(), "Center");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$DownloadDialog;", "Ljavax/swing/JDialog;", "<init>", "(Lapp/termora/terminal/panel/vw/TransferVisualWindow;)V", "getMySize", "Ljava/awt/Dimension;", "hasPopupMenus", "", "createCenterPanel", "Ljavax/swing/JComponent;", "addNotify", "", "termora"})
    private final class DownloadDialog
    extends JDialog {
        public DownloadDialog() {
            this.setSize(this.getMySize());
            this.setModal(false);
            this.setTitle(I18n.INSTANCE.getString("termora.transport.sftp"));
            this.setLayout(new BorderLayout());
            if (SystemInfo.isMacOS) {
                this.rootPane.putClientProperty("apple.awt.windowTitleVisible", false);
                this.rootPane.putClientProperty("apple.awt.fullWindowContent", true);
                this.rootPane.putClientProperty("apple.awt.transparentTitleBar", true);
            }
            this.add((Component)this.createCenterPanel(), "Center");
            final DownloadDialog window = this;
            InputMap inputMap = this.rootPane.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "close");
            inputMap.put(KeyStroke.getKeyStroke(87, this.getToolkit().getMenuShortcutKeyMaskEx()), "close");
            this.rootPane.getActionMap().put("close", (Action)((Object)new AnAction(){

                @Override
                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    if (!this.hasPopupMenus()) {
                        window.dispose();
                    }
                }
            }));
            AWTEventListener awtEventListener2 = new AWTEventListener(window, this){
                final /* synthetic */ DownloadDialog $window;
                final /* synthetic */ DownloadDialog this$0;
                {
                    this.$window = $window;
                    this.this$0 = $receiver;
                }

                public void eventDispatched(AWTEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!(event instanceof MouseEvent)) {
                        return;
                    }
                    if (((MouseEvent)event).getID() != 501) {
                        return;
                    }
                    Window ancestor = SwingUtilities.getWindowAncestor(((MouseEvent)event).getComponent());
                    if (Intrinsics.areEqual((Object)ancestor, (Object)this.$window)) {
                        return;
                    }
                    if (ancestor != null && this.getOwners(ancestor).contains(this.$window)) {
                        return;
                    }
                    if (this.this$0.isFocused() && ((MouseEvent)event).getComponent() instanceof JXTree) {
                        return;
                    }
                    this.$window.dispose();
                }

                private final List<Window> getOwners(Window window) {
                    List owners = new ArrayList<E>();
                    for (Window owner = window.getOwner(); owner != null; owner = owner.getOwner()) {
                        owners.add(owner);
                    }
                    return owners;
                }
            };
            this.getToolkit().addAWTEventListener(awtEventListener2, 16L);
            this.addWindowListener(new WindowAdapter(awtEventListener2, TransferVisualWindow.this){
                final /* synthetic */ awtEventListener.1 $awtEventListener;
                final /* synthetic */ TransferVisualWindow this$1;
                {
                    this.$awtEventListener = $awtEventListener;
                    this.this$1 = $receiver2;
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.removeWindowListener(this);
                    this.getToolkit().removeAWTEventListener(this.$awtEventListener);
                    this.this$1.getProperties().putString("VisualWindow.DownloadDialog.location.width", String.valueOf(this.getWidth()));
                    this.this$1.getProperties().putString("VisualWindow.DownloadDialog.location.height", String.valueOf(this.getHeight()));
                }
            });
        }

        private final Dimension getMySize() {
            Dimension size = new Dimension(UIManager.getInt("Dialog.width") - 150, UIManager.getInt("Dialog.height") - 100);
            Integer n = StringsKt.toIntOrNull((String)TransferVisualWindow.this.getProperties().getString("VisualWindow.DownloadDialog.location.width", String.valueOf(size.width)));
            int width = n != null ? n : size.width;
            Integer n2 = StringsKt.toIntOrNull((String)TransferVisualWindow.this.getProperties().getString("VisualWindow.DownloadDialog.location.height", String.valueOf(size.height)));
            int height = n2 != null ? n2 : size.height;
            return new Dimension(Math.max(width, 250), Math.max(height, 150));
        }

        private final boolean hasPopupMenus() {
            Window[] c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (c != null) {
                Window window;
                List<JPopupMenu> list = SwingUtils.getDescendantsOfType(JPopupMenu.class, (Container)c, true);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getDescendantsOfType(...)");
                List<JPopupMenu> popups = list;
                boolean openPopup = false;
                for (JPopupMenu p : popups) {
                    p.setVisible(false);
                    openPopup = true;
                }
                Window[] windowArray = c;
                Window window2 = windowArray instanceof Window ? (Window)windowArray : null;
                if (window2 == null) {
                    window2 = SwingUtilities.windowForComponent((Component)c);
                }
                if ((window = window2) != null) {
                    Window[] windows = window.getOwnedWindows();
                    Intrinsics.checkNotNull((Object)windows);
                    for (Window w : windows) {
                        if (!w.isVisible()) continue;
                        String string = w.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.endsWith$default((String)string, (String)"HeavyWeightWindow", (boolean)false, (int)2, null)) continue;
                        openPopup = true;
                        w.dispose();
                    }
                }
                if (openPopup) {
                    return true;
                }
            }
            return false;
        }

        private final JComponent createCenterPanel() {
            TransferTable table = new TransferTable(TransferVisualWindow.this.coroutineScope, TransferVisualWindow.this.transferManager);
            JScrollPane scrollPane = new JScrollPane((Component)((Object)table));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.addWindowListener(new WindowAdapter(this, table){
                final /* synthetic */ DownloadDialog this$0;
                final /* synthetic */ TransferTable $table;
                {
                    this.this$0 = $receiver;
                    this.$table = $table;
                }

                public void windowClosed(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.removeWindowListener(this);
                    Disposer.dispose(this.$table);
                }
            });
            return scrollPane;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (SystemInfo.isMacOS) {
                NativeMacLibrary.setControlsVisible$default(NativeMacLibrary.INSTANCE, this, false, null, 4, null);
            } else if (SystemInfo.isWindows || SystemInfo.isLinux) {
                this.rootPane.putClientProperty("FlatLaf.fullWindowContent", true);
                this.rootPane.putClientProperty("JRootPane.titleBarShowIconify", false);
                this.rootPane.putClientProperty("JRootPane.titleBarShowIcon", false);
                this.rootPane.putClientProperty("JRootPane.titleBarShowMaximize", false);
                this.rootPane.putClientProperty("JRootPane.titleBarShowTitle", false);
                this.rootPane.putClientProperty("JRootPane.titleBarShowClose", false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J0\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u00100\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J8\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00110\u00100\f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$MyInternalTransferManager;", "Lapp/termora/transfer/InternalTransferManager;", "<init>", "(Lapp/termora/terminal/panel/vw/TransferVisualWindow;)V", "internalTransferManager", "setTransferPanel", "", "transportPanel", "Lapp/termora/transfer/TransportPanel;", "canTransfer", "", "paths", "", "Ljava/nio/file/Path;", "addTransfer", "Ljava/util/concurrent/CompletableFuture;", "Lkotlin/Pair;", "Lapp/termora/transfer/TransportTableModel$Attributes;", "mode", "Lapp/termora/transfer/InternalTransferManager$TransferMode;", "targetWorkdir", "addHighTransfer", "", "source", "target", "addTransferListener", "Lapp/termora/Disposable;", "listener", "Lapp/termora/transfer/TransferListener;", "createWorkdirProvider", "Lapp/termora/transfer/DefaultInternalTransferManager$WorkdirProvider;", "createInternalTransferManager", "termora"})
    private final class MyInternalTransferManager
    implements InternalTransferManager {
        private InternalTransferManager internalTransferManager;

        public final void setTransferPanel(@NotNull TransportPanel transportPanel2) {
            Intrinsics.checkNotNullParameter((Object)transportPanel2, (String)"transportPanel");
            this.internalTransferManager = this.createInternalTransferManager(transportPanel2);
        }

        @Override
        public boolean canTransfer(@NotNull List<? extends Path> paths) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            return !((Collection)paths).isEmpty();
        }

        @Override
        @NotNull
        public CompletableFuture<Unit> addTransfer(@NotNull List<? extends Pair<? extends Path, TransportTableModel.Attributes>> paths, @NotNull InternalTransferManager.TransferMode mode) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            if (mode == InternalTransferManager.TransferMode.Transfer) {
                CompletableFuture<Unit> future2 = new CompletableFuture<Unit>();
                FileChooser chooser = new FileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setAllowsMultiSelection(false);
                chooser.showOpenDialog(TransferVisualWindow.this.getOwner()).whenComplete((arg_0, arg_1) -> MyInternalTransferManager.addTransfer$lambda$1((arg_0, arg_1) -> MyInternalTransferManager.addTransfer$lambda$0(future2, TransferVisualWindow.this, this, paths, mode, arg_0, arg_1), arg_0, arg_1));
                return future2;
            }
            InternalTransferManager internalTransferManager = this.internalTransferManager;
            if (internalTransferManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"internalTransferManager");
                internalTransferManager = null;
            }
            return internalTransferManager.addTransfer(paths, mode);
        }

        @Override
        @NotNull
        public CompletableFuture<Unit> addTransfer(@NotNull List<? extends Pair<? extends Path, TransportTableModel.Attributes>> paths, @NotNull Path targetWorkdir, @NotNull InternalTransferManager.TransferMode mode) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)targetWorkdir, (String)"targetWorkdir");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            InternalTransferManager internalTransferManager = this.internalTransferManager;
            if (internalTransferManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"internalTransferManager");
                internalTransferManager = null;
            }
            return internalTransferManager.addTransfer(paths, targetWorkdir, mode);
        }

        @Override
        @NotNull
        public String addHighTransfer(@NotNull Path source, @NotNull Path target) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            InternalTransferManager internalTransferManager = this.internalTransferManager;
            if (internalTransferManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"internalTransferManager");
                internalTransferManager = null;
            }
            return internalTransferManager.addHighTransfer(source, target);
        }

        @Override
        @NotNull
        public Disposable addTransferListener(@NotNull TransferListener listener2) {
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return TransferVisualWindow.this.transferManager.addTransferListener(listener2);
        }

        private final DefaultInternalTransferManager.WorkdirProvider createWorkdirProvider(TransportPanel transportPanel2) {
            return new DefaultInternalTransferManager.WorkdirProvider(transportPanel2){
                final /* synthetic */ TransportPanel $transportPanel;
                {
                    this.$transportPanel = $transportPanel;
                }

                public Path getWorkdir() {
                    return this.$transportPanel.getWorkdir();
                }
            };
        }

        private final InternalTransferManager createInternalTransferManager(TransportPanel transportPanel2) {
            return new DefaultInternalTransferManager(() -> MyInternalTransferManager.createInternalTransferManager$lambda$0(TransferVisualWindow.this), TransferVisualWindow.this.coroutineScope, TransferVisualWindow.this.transferManager, new DefaultInternalTransferManager.WorkdirProvider(){

                public Void getWorkdir() {
                    return null;
                }
            }, this.createWorkdirProvider(transportPanel2));
        }

        private static final Unit addTransfer$lambda$0(CompletableFuture $future, TransferVisualWindow this$0, MyInternalTransferManager this$1, List $paths, InternalTransferManager.TransferMode $mode, List files, Throwable e) {
            Boolean bl = e != null ? Boolean.valueOf($future.completeExceptionally(e)) : (files.isEmpty() ? Boolean.valueOf($future.complete(Unit.INSTANCE)) : BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$1, (List<? extends Pair<? extends Path, TransportTableModel.Attributes>>)$paths, (List<? extends File>)files, $mode, (CompletableFuture<Unit>)$future, null){
                int label;
                final /* synthetic */ MyInternalTransferManager this$0;
                final /* synthetic */ List<Pair<Path, TransportTableModel.Attributes>> $paths;
                final /* synthetic */ List<File> $files;
                final /* synthetic */ InternalTransferManager.TransferMode $mode;
                final /* synthetic */ CompletableFuture<Unit> $future;
                {
                    this.this$0 = $receiver;
                    this.$paths = $paths;
                    this.$files = $files;
                    this.$mode = $mode;
                    this.$future = $future;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                List<File> list = this.$files;
                                Intrinsics.checkNotNull(list);
                                Path path = ((File)CollectionsKt.first(list)).toPath();
                                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                                ((CompletableFuture)this.this$0.addTransfer(this.$paths, path, this.$mode).thenApply(arg_0 -> addTransfer.1.1.invokeSuspend$lambda$1(arg_0 -> addTransfer.1.1.invokeSuspend$lambda$0(this.$future, arg_0), arg_0))).exceptionally(arg_0 -> addTransfer.1.1.invokeSuspend$lambda$2(this.$future, arg_0));
                            }
                            catch (Exception e) {
                                this.$future.completeExceptionally(e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final Boolean invokeSuspend$lambda$0(CompletableFuture $future, Unit it) {
                    return $future.complete(it);
                }

                private static final Boolean invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                    return (Boolean)$tmp0.invoke(p0);
                }

                private static final Boolean invokeSuspend$lambda$2(CompletableFuture $future, Throwable it) {
                    return $future.completeExceptionally(it);
                }
            }), (int)2, null));
            return Unit.INSTANCE;
        }

        private static final void addTransfer$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        private static final Window createInternalTransferManager$lambda$0(TransferVisualWindow this$0) {
            return this$0.getOwner();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/vw/TransferVisualWindow$State;", "", "<init>", "(Ljava/lang/String;I)V", "Connecting", "Transfer", "Failed", "termora"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Connecting = new State();
        public static final /* enum */ State Transfer = new State();
        public static final /* enum */ State Failed = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Connecting, State.Transfer, State.Failed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

