/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.actions.AnActionEvent;
import app.termora.database.DatabaseManager;
import app.termora.terminal.DataKey;
import app.termora.terminal.Document;
import app.termora.terminal.KTermKt;
import app.termora.terminal.MouseMode;
import app.termora.terminal.Position;
import app.termora.terminal.SelectionModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u000245B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010)\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010.\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u000201000/2\u0006\u00102\u001a\u00020\u0018H\u0002J\u0010\u00103\u001a\u0002012\u0006\u00102\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseSelectionAdapter;", "Ljava/awt/event/MouseAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;)V", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "isMouseTracking", "", "()Z", "isSelectCopy", "selectionModel", "Lapp/termora/terminal/SelectionModel;", "getSelectionModel", "()Lapp/termora/terminal/SelectionModel;", "wordBreakIterator", "Ljava/text/BreakIterator;", "kotlin.jvm.PlatformType", "rightClickMode", "", "getRightClickMode", "()Ljava/lang/String;", "mousePressedPoint", "Ljava/awt/Point;", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseDragged", "isOnlyAltDown", "beginSelect", "position", "Lapp/termora/terminal/Position;", "select", "endSelect", "triggerCopyAction", "Ljava/awt/event/KeyEvent;", "triggerPasteAction", "selectWord", "selectLine", "convertWords", "", "Lkotlin/Triple;", "", "text", "getStringWidth", "Companion", "DragSelection", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalPanelMouseSelectionAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPanelMouseSelectionAdapter.kt\napp/termora/terminal/panel/TerminalPanelMouseSelectionAdapter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,356:1\n13861#2,2:357\n*S KotlinDebug\n*F\n+ 1 TerminalPanelMouseSelectionAdapter.kt\napp/termora/terminal/panel/TerminalPanelMouseSelectionAdapter\n*L\n353#1:357,2\n*E\n"})
public final class TerminalPanelMouseSelectionAdapter
extends MouseAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;
    private final BreakIterator wordBreakIterator;
    @NotNull
    private Point mousePressedPoint;
    private static final Logger log = LoggerFactory.getLogger(TerminalPanelMouseSelectionAdapter.class);

    public TerminalPanelMouseSelectionAdapter(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
        this.wordBreakIterator = BreakIterator.getWordInstance();
        this.mousePressedPoint = new Point(0, 0);
    }

    private final TerminalModel getTerminalModel() {
        return this.terminal.getTerminalModel();
    }

    private final boolean isMouseTracking() {
        return this.getTerminalModel().getData(DataKey.Companion.getMouseMode(), MouseMode.MOUSE_REPORTING_NONE) != MouseMode.MOUSE_REPORTING_NONE;
    }

    private final boolean isSelectCopy() {
        return this.getTerminalModel().getData(TerminalPanel.Companion.getSelectCopy(), false);
    }

    private final SelectionModel getSelectionModel() {
        return this.terminal.getSelectionModel();
    }

    private final String getRightClickMode() {
        return DatabaseManager.Companion.getInstance().getTerminal().getRightClick();
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.terminalPanel.requestFocusInWindow();
        if (this.isMouseTracking()) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            if (this.getSelectionModel().hasSelection() && !this.isSelectCopy()) {
                this.triggerCopyAction(new KeyEvent(e.getComponent(), 401, e.getWhen(), e.getModifiersEx(), 67, 'C'));
                if (Intrinsics.areEqual((Object)this.getRightClickMode(), (Object)"CopyAndPaste")) {
                    this.triggerPasteAction(new KeyEvent(e.getComponent(), 401, e.getWhen(), e.getModifiersEx(), 86, 'V'));
                }
            } else {
                this.triggerPasteAction(new KeyEvent(e.getComponent(), 401, e.getWhen(), e.getModifiersEx(), 86, 'V'));
            }
        } else if (SwingUtilities.isLeftMouseButton(e)) {
            this.mousePressedPoint.x = e.getX();
            this.mousePressedPoint.y = e.getY();
        }
        if (this.getSelectionModel().hasSelection() && SwingUtilities.isLeftMouseButton(e) && e.getModifiersEx() == 1088) {
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            Position position = this.terminalPanel.pointToPosition(point);
            Position selectionStartPosition = this.getSelectionModel().getSelectionStartPosition();
            Position selectionEndPosition = this.getSelectionModel().getSelectionEndPosition();
            int cols = this.getTerminalModel().getCols();
            int clickIndex = position.getY() * cols + position.getX();
            int startIndex = selectionStartPosition.getY() * cols + selectionStartPosition.getX();
            int endIndex = selectionEndPosition.getY() * cols + selectionEndPosition.getX();
            int startDiff = Math.abs(clickIndex - startIndex);
            int endDiff = Math.abs(clickIndex - endIndex);
            if (startDiff < endDiff) {
                this.getSelectionModel().setSelection(position, selectionEndPosition);
            } else {
                this.getSelectionModel().setSelection(selectionStartPosition, position);
            }
        } else {
            this.getSelectionModel().clearSelection();
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (e.getClickCount() % 2 == 0) {
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                this.selectWord(this.terminalPanel.pointToPosition(point));
            } else if (e.getClickCount() % 3 == 0) {
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
                this.selectLine(this.terminalPanel.pointToPosition(point));
            }
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (DragSelection.INSTANCE.getDragging()) {
            int n = e.getX();
            int n2 = e.getY();
            this.endSelect(new Position(n2, n));
        }
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isMouseTracking()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (DragSelection.INSTANCE.getDragging()) {
            int n = e.getX();
            int n2 = e.getY();
            this.select(new Position(n2, n));
        } else {
            double diff = (double)this.terminalPanel.getAverageCharWidth() / 5.0;
            if ((double)Math.abs(this.mousePressedPoint.y - e.getY()) >= diff || (double)Math.abs(this.mousePressedPoint.x - e.getX()) >= diff) {
                this.terminal.getSelectionModel().setBlockSelection(this.isOnlyAltDown(e));
                int n = this.mousePressedPoint.x;
                int n3 = this.mousePressedPoint.y;
                this.beginSelect(new Position(n3, n));
            }
        }
    }

    private final boolean isOnlyAltDown(MouseEvent e) {
        return e.isAltDown() && !e.isMetaDown() && !e.isControlDown() && !e.isShiftDown() && !e.isAltGraphDown();
    }

    private final void beginSelect(Position position) {
        if (DragSelection.INSTANCE.getDragging()) {
            throw new IllegalStateException("Selecting");
        }
        this.getSelectionModel().clearSelection();
        DragSelection.INSTANCE.setDragging(true);
        DragSelection.INSTANCE.setStart(this.terminalPanel.pointToPosition(new Point(position.getX(), position.getY())));
        if (log.isTraceEnabled()) {
            log.trace("Begin select start={}", (Object)DragSelection.INSTANCE.getStart());
        }
    }

    private final void select(Position position) {
        if (!DragSelection.INSTANCE.getDragging()) {
            throw new IllegalStateException("Not Selecting");
        }
        Position point = this.terminalPanel.pointToPosition(new Point(position.getX(), position.getY()));
        DragSelection.INSTANCE.setEnd(point);
        Position start2 = DragSelection.INSTANCE.getStart();
        Position end = DragSelection.INSTANCE.getEnd();
        this.terminal.getScrollingModel().scrollToRow(point.getY());
        if (start2.getY() > end.getY() || start2.getY() == end.getY() && start2.getX() > end.getX()) {
            Position temp = start2;
            start2 = end;
            end = temp;
        }
        this.terminal.getSelectionModel().setSelection(start2, end);
        if (log.isTraceEnabled()) {
            log.trace("Select start={} end={}", (Object)start2, (Object)end);
        }
    }

    private final void endSelect(Position position) {
        if (!DragSelection.INSTANCE.getDragging()) {
            throw new IllegalStateException("Not Selecting");
        }
        this.select(position);
        DragSelection.INSTANCE.setDragging(false);
        if (this.isSelectCopy()) {
            TerminalPanelMouseSelectionAdapter.triggerCopyAction$default(this, null, 1, null);
        }
        if (log.isTraceEnabled()) {
            log.trace("End select start={} end={}", (Object)DragSelection.INSTANCE.getStart(), (Object)DragSelection.INSTANCE.getEnd());
        }
    }

    private final void triggerCopyAction(KeyEvent e) {
        Action action2 = ActionManager.getInstance().getAction((Object)"TerminalCopy");
        if (action2 != null) {
            action2.actionPerformed(new AnActionEvent((Object)this.terminalPanel, "", e));
        }
    }

    static /* synthetic */ void triggerCopyAction$default(TerminalPanelMouseSelectionAdapter terminalPanelMouseSelectionAdapter, KeyEvent keyEvent, int n, Object object) {
        if ((n & 1) != 0) {
            keyEvent = new KeyEvent(terminalPanelMouseSelectionAdapter.terminalPanel, 401, System.currentTimeMillis(), 0, 67, 'C');
        }
        terminalPanelMouseSelectionAdapter.triggerCopyAction(keyEvent);
    }

    private final void triggerPasteAction(KeyEvent e) {
        Action action2 = ActionManager.getInstance().getAction((Object)"TerminalPaste");
        if (action2 != null) {
            action2.actionPerformed(new AnActionEvent((Object)this.terminalPanel, "", e));
        }
    }

    static /* synthetic */ void triggerPasteAction$default(TerminalPanelMouseSelectionAdapter terminalPanelMouseSelectionAdapter, KeyEvent keyEvent, int n, Object object) {
        if ((n & 1) != 0) {
            keyEvent = new KeyEvent(terminalPanelMouseSelectionAdapter.terminalPanel, 401, System.currentTimeMillis(), 0, 86, 'V');
        }
        terminalPanelMouseSelectionAdapter.triggerPasteAction(keyEvent);
    }

    private final void selectWord(Position position) {
        Document document = this.terminal.getDocument();
        if (!position.isValid() || position.getY() > document.getLineCount()) {
            return;
        }
        TerminalLine line = document.getLine(position.getY());
        String text = line.getText();
        if (((CharSequence)text).length() == 0) {
            this.selectLine(position);
            return;
        }
        for (Triple<Integer, String, Integer> triple : this.convertWords(text)) {
            int offset = ((Number)triple.component1()).intValue();
            int end = ((Number)triple.component3()).intValue();
            int n = position.getX();
            boolean bl = offset <= n ? n <= end : false;
            if (!bl) continue;
            this.getSelectionModel().setSelection(new Position(position.getY(), offset + 1), new Position(position.getY(), end));
            if (this.isSelectCopy()) {
                TerminalPanelMouseSelectionAdapter.triggerCopyAction$default(this, null, 1, null);
            }
            return;
        }
        int actualCount = line.actualCount();
        if (position.getX() > actualCount) {
            this.getSelectionModel().setSelection(new Position(position.getY(), actualCount + 1), new Position(position.getY(), this.getTerminalModel().getCols()));
        }
    }

    private final void selectLine(Position position) {
        Document document = this.terminal.getDocument();
        if (!position.isValid() || position.getY() > document.getLineCount()) {
            return;
        }
        this.getSelectionModel().setSelection(new Position(position.getY(), 1), new Position(position.getY(), this.getTerminalModel().getCols()));
        if (this.isSelectCopy()) {
            TerminalPanelMouseSelectionAdapter.triggerCopyAction$default(this, null, 1, null);
        }
    }

    private final List<Triple<Integer, String, Integer>> convertWords(String text) {
        List words = new ArrayList();
        this.wordBreakIterator.setText(text);
        int doubleWidthCharCount = 0;
        int start2 = this.wordBreakIterator.first();
        int end = this.wordBreakIterator.next();
        while (end != -1) {
            String word;
            Intrinsics.checkNotNullExpressionValue((Object)text.substring(start2, end), (String)"substring(...)");
            boolean first = doubleWidthCharCount == 0;
            int widthDiff = this.getStringWidth(word) - word.length();
            words.add(new Triple((Object)(start2 + (first ? 0 : doubleWidthCharCount)), (Object)word, (Object)(end + (doubleWidthCharCount + widthDiff))));
            doubleWidthCharCount += this.getStringWidth(word) - word.length();
            start2 = end;
            end = this.wordBreakIterator.next();
        }
        return words;
    }

    private final int getStringWidth(String text) {
        int count = 0;
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] $this$forEach$iv = cArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            char element$iv;
            char it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            count += KTermKt.mk_wcwidth(it);
        }
        return count;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseSelectionAdapter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseSelectionAdapter$DragSelection;", "", "<init>", "()V", "dragging", "", "getDragging", "()Z", "setDragging", "(Z)V", "start", "Lapp/termora/terminal/Position;", "getStart", "()Lapp/termora/terminal/Position;", "setStart", "(Lapp/termora/terminal/Position;)V", "end", "getEnd", "setEnd", "termora"})
    private static final class DragSelection {
        @NotNull
        public static final DragSelection INSTANCE = new DragSelection();
        private static boolean dragging;
        @NotNull
        private static Position start;
        @NotNull
        private static Position end;

        private DragSelection() {
        }

        public final boolean getDragging() {
            return dragging;
        }

        public final void setDragging(boolean bl) {
            dragging = bl;
        }

        @NotNull
        public final Position getStart() {
            return start;
        }

        public final void setStart(@NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"<set-?>");
            start = position;
        }

        @NotNull
        public final Position getEnd() {
            return end;
        }

        public final void setEnd(@NotNull Position position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"<set-?>");
            end = position;
        }

        static {
            start = Position.Companion.getUnknown();
            end = Position.Companion.getUnknown();
        }
    }
}

