/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.terminal.ClickableHighlighter;
import app.termora.terminal.Highlighter;
import app.termora.terminal.Position;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseHyperlinkAdapter;", "Ljava/awt/event/MouseAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/panel/TerminalDisplay;Lapp/termora/terminal/Terminal;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseMoved", "termora"})
public final class TerminalPanelMouseHyperlinkAdapter
extends MouseAdapter {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final TerminalDisplay terminalDisplay;
    @NotNull
    private final Terminal terminal;

    public TerminalPanelMouseHyperlinkAdapter(@NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminalPanel = terminalPanel;
        this.terminalDisplay = terminalDisplay;
        this.terminal = terminal;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (SystemInfo.isMacOS ? !e.isMetaDown() : !e.isControlDown()) {
            return;
        }
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Position position = this.terminalPanel.pointToPosition(point);
        for (Highlighter highlighter : this.terminal.getMarkupModel().getHighlighters(position)) {
            if (!(highlighter instanceof ClickableHighlighter)) continue;
            ((ClickableHighlighter)highlighter).onClicked(position);
        }
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Position position = this.terminalPanel.pointToPosition(point);
        Cursor cursor = Cursor.getPredefinedCursor(2);
        for (Highlighter highlighter : this.terminal.getMarkupModel().getHighlighters(position)) {
            if (!(highlighter instanceof ClickableHighlighter)) continue;
            cursor = SystemInfo.isMacOS ? Cursor.getDefaultCursor() : Cursor.getPredefinedCursor(12);
            break;
        }
        this.terminalDisplay.setCursor(cursor);
    }
}

