/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.database.DatabaseManager;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lapp/termora/terminal/panel/TerminalPanelMouseFloatingToolBarAdapter;", "Ljava/awt/event/MouseAdapter;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/panel/TerminalDisplay;)V", "floatingToolbarEnable", "", "getFloatingToolbarEnable", "()Z", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "termora"})
public final class TerminalPanelMouseFloatingToolBarAdapter
extends MouseAdapter {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final TerminalDisplay terminalDisplay;

    public TerminalPanelMouseFloatingToolBarAdapter(@NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        this.terminalPanel = terminalPanel;
        this.terminalDisplay = terminalDisplay;
    }

    private final boolean getFloatingToolbarEnable() {
        return DatabaseManager.Companion.getInstance().getTerminal().getFloatingToolbar();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.getFloatingToolbarEnable()) {
            return;
        }
        FloatingToolbarPanel floatingToolbarPanel = this.terminalPanel.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
        if (floatingToolbarPanel == null) {
            return;
        }
        FloatingToolbarPanel floatingToolbar = floatingToolbarPanel;
        int width = this.terminalPanel.getWidth();
        int height = this.terminalPanel.getHeight();
        int widthDiff = (int)((double)width * 0.25);
        int heightDiff = (int)((double)height * 0.25);
        int n = width - widthDiff;
        int n2 = e.getX();
        boolean bl = n <= n2 ? n2 <= width : false;
        if (bl) {
            n = e.getY();
            boolean bl2 = 0 <= n ? n <= heightDiff : false;
            if (bl2) {
                floatingToolbar.triggerShow();
                return;
            }
        }
        floatingToolbar.triggerHide();
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FloatingToolbarPanel floatingToolbarPanel = this.terminalPanel.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
        if (floatingToolbarPanel == null) {
            return;
        }
        FloatingToolbarPanel floatingToolbar = floatingToolbarPanel;
        if (this.terminalDisplay.isShowing() && (rectangle = new Rectangle(this.terminalDisplay.getLocationOnScreen(), this.terminalDisplay.getSize())).contains(e.getLocationOnScreen())) {
            return;
        }
        floatingToolbar.triggerHide();
    }
}

