/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.DynamicColor;
import app.termora.ScopeKt;
import app.termora.TermoraFrameKt;
import app.termora.database.DatabaseManager;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.CursorStyle;
import app.termora.terminal.DataKey;
import app.termora.terminal.Highlighter;
import app.termora.terminal.KTermKt;
import app.termora.terminal.MarkupModel;
import app.termora.terminal.Position;
import app.termora.terminal.SelectionModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalLineBuffer;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.TerminalBlink;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalInputMethodData;
import app.termora.terminal.panel.TerminalPaintListener;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 Z2\u00020\u0001:\u0005YZ[\\]B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J(\u0010-\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020/H\u0002J\u0006\u00102\u001a\u00020/J\u0006\u00103\u001a\u00020/J\u0006\u00104\u001a\u000205J\b\u00106\u001a\u00020$H\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020$2\u0006\u0010%\u001a\u00020<H\u0002J-\u0010;\u001a\u00020$2\u0006\u0010%\u001a\u00020<2\u0006\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020/2\u0006\u0010?\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b@J(\u0010A\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020D\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020/0C0B2\u0006\u0010F\u001a\u00020/H\u0002J\u0018\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020/2\u0006\u0010I\u001a\u00020JH\u0002J\u001d\u0010K\u001a\u00020\u00152\u0006\u0010L\u001a\u00020D2\u0006\u0010M\u001a\u00020E\u00a2\u0006\u0004\bN\u0010OJ\u0010\u0010P\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010Q\u001a\u00020\u0015H\u0002J\n\u0010R\u001a\u0004\u0018\u00010\u0015H\u0002J\u001d\u0010S\u001a\u00020$2\u0006\u0010L\u001a\u00020D2\u0006\u0010T\u001a\u00020U\u00a2\u0006\u0004\bV\u0010WJ\u0006\u0010X\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0018*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u0018*\u0004\u0018\u00010\u00150\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006^"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay;", "Ljavax/swing/JComponent;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "terminalBlink", "Lapp/termora/terminal/panel/TerminalBlink;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;Lapp/termora/terminal/panel/TerminalBlink;)V", "debug", "", "getDebug", "()Z", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "toaster", "Lapp/termora/terminal/panel/TerminalDisplay$Toaster;", "font", "Ljava/awt/Font;", "monospacedFont", "boldFont", "kotlin.jvm.PlatformType", "italicFont", "boldItalicFont", "fallbackFont", "value", "Lapp/termora/terminal/panel/TerminalInputMethodData;", "inputMethodData", "getInputMethodData", "()Lapp/termora/terminal/panel/TerminalInputMethodData;", "setInputMethodData", "(Lapp/termora/terminal/panel/TerminalInputMethodData;)V", "paint", "", "g", "Ljava/awt/Graphics;", "setupAntialiasing", "graphics", "drawBefore", "drawAfter", "drawBaseline", "clear", "drawCursor", "y", "", "xOffset", "width", "getAverageCharWidth", "getLineHeight", "getFontMetrics", "Ljava/awt/FontMetrics;", "checkFont", "pointToPosition", "Lapp/termora/terminal/Position;", "point", "Ljava/awt/Point;", "drawCharacters", "Ljava/awt/Graphics2D;", "verticalScrollOffset", "rows", "overflowBreak", "drawCharacters$termora", "smartCharacters", "", "Lkotlin/Triple;", "", "Lapp/termora/terminal/TextStyle;", "row", "getDisplayColor", "color", "terminalColor", "Lapp/termora/terminal/TerminalColor;", "getDisplayFont", "text", "style", "getDisplayFont-QwXzuJw", "(Ljava/lang/String;J)Ljava/awt/Font;", "drawLineNumber", "getTerminalFont", "getFallbackTerminalFont", "toast", "duration", "Lkotlin/time/Duration;", "toast-HG0u8IE", "(Ljava/lang/String;J)V", "hideToast", "RendererFont", "Companion", "Toast", "Toaster", "FontCanDisplay", "termora"})
@SourceDebugExtension(value={"SMAP\nTerminalDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalDisplay.kt\napp/termora/terminal/panel/TerminalDisplay\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,615:1\n13805#2,2:616\n13805#2,2:618\n*S KotlinDebug\n*F\n+ 1 TerminalDisplay.kt\napp/termora/terminal/panel/TerminalDisplay\n*L\n101#1:616,2\n115#1:618,2\n*E\n"})
public final class TerminalDisplay
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalBlink terminalBlink;
    @NotNull
    private final Toaster toaster;
    @NotNull
    private Font font;
    @NotNull
    private Font monospacedFont;
    private Font boldFont;
    private Font italicFont;
    private Font boldItalicFont;
    @Nullable
    private Font fallbackFont;
    @NotNull
    private TerminalInputMethodData inputMethodData;
    @NotNull
    private static final Companion.lru.1 lru = new LinkedHashMap<String, RendererFont>(){

        protected boolean removeEldestEntry(Map.Entry<String, RendererFont> eldest) {
            return this.size() > 2048;
        }
    };

    public TerminalDisplay(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal, @NotNull TerminalBlink terminalBlink) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)terminalBlink, (String)"terminalBlink");
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
        this.terminalBlink = terminalBlink;
        this.toaster = new Toaster();
        this.font = this.getTerminalFont();
        this.monospacedFont = new Font("Monospaced", this.font.getStyle(), this.font.getSize());
        this.boldFont = this.font.deriveFont(1);
        this.italicFont = this.font.deriveFont(2);
        this.boldItalicFont = this.font.deriveFont(3);
        this.fallbackFont = this.getFallbackTerminalFont();
        this.inputMethodData = TerminalInputMethodData.Companion.getDefault();
        this.terminalPanel.addTerminalPaintListener(this.toaster);
        this.putClientProperty(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.setCursor(Cursor.getPredefinedCursor(2));
    }

    private final boolean getDebug() {
        return this.terminalPanel.getDebug();
    }

    private final ColorPalette getColorPalette() {
        return this.terminal.getTerminalModel().getColorPalette();
    }

    @NotNull
    public final TerminalInputMethodData getInputMethodData() {
        return this.inputMethodData;
    }

    public final void setInputMethodData(@NotNull TerminalInputMethodData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.inputMethodData = value;
        this.terminalPanel.repaintImmediate();
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.isShowing()) {
            return;
        }
        if (g instanceof Graphics2D) {
            this.setupAntialiasing(g);
            this.clear(g);
            this.drawBefore(g);
            this.drawCharacters((Graphics2D)g);
            this.drawBaseline(g);
            this.drawLineNumber(g);
            this.drawAfter(g);
        }
    }

    private final void setupAntialiasing(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
    }

    private final void drawBefore(Graphics g) {
        EventListener[] eventListenerArray = this.terminalPanel.getListeners(TerminalPaintListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventListenerArray, (String)"getListeners(...)");
        Object[] $this$forEach$iv = eventListenerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalPaintListener it = (TerminalPaintListener)element$iv;
            boolean bl = false;
            it.before(this.terminal.getScrollingModel().getVerticalScrollOffset(), this.terminal.getTerminalModel().getRows(), g, this.terminalPanel, this, this.terminal);
        }
    }

    private final void drawAfter(Graphics g) {
        EventListener[] eventListenerArray = this.terminalPanel.getListeners(TerminalPaintListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventListenerArray, (String)"getListeners(...)");
        Object[] $this$forEach$iv = eventListenerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalPaintListener it = (TerminalPaintListener)element$iv;
            boolean bl = false;
            it.after(this.terminal.getScrollingModel().getVerticalScrollOffset(), this.terminal.getTerminalModel().getRows(), g, this.terminalPanel, this, this.terminal);
        }
    }

    private final void drawBaseline(Graphics g) {
        if (!this.getDebug()) {
            return;
        }
        int lineHeight = this.getLineHeight();
        int averageCharWidth = this.getAverageCharWidth();
        g.setColor(DynamicColor.Companion.getBorderColor());
        int i = 1;
        int n = this.getHeight() / lineHeight;
        if (i <= n) {
            while (true) {
                g.drawLine(0, i * lineHeight, this.getWidth(), i * lineHeight);
                if (i == n) break;
                ++i;
            }
        }
        if ((i = 1) <= (n = this.getWidth() / averageCharWidth)) {
            while (true) {
                g.drawLine(i * averageCharWidth, 0, i * averageCharWidth, this.getHeight());
                if (i == n) break;
                ++i;
            }
        }
    }

    private final void clear(Graphics g) {
        g.setFont(this.font);
        g.setColor(new Color(this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private final void drawCursor(Graphics g, int y, int xOffset, int width) {
        int lineHeight = this.getLineHeight();
        CursorStyle style = this.inputMethodData.isNoTyping() ? this.terminal.getTerminalModel().getData(DataKey.Companion.getCursorStyle()) : CursorStyle.Bar;
        boolean hasFocus = this.terminal.getTerminalModel().getData(TerminalPanel.Companion.getFocused(), false);
        g.setColor(new Color(this.getColorPalette().getColor(TerminalColor.Cursor.INSTANCE.getBACKGROUND())));
        if (style == CursorStyle.Block) {
            if (hasFocus) {
                g.fillRect(xOffset, (y - 1) * lineHeight, width, lineHeight);
            } else {
                g.drawRect(xOffset, (y - 1) * lineHeight, width, lineHeight);
            }
        } else if (style == CursorStyle.Underline) {
            int h = (int)Math.ceil((double)lineHeight / 10.0);
            g.fillRect(xOffset, y * lineHeight - h / 2, width, h);
        } else if (style == CursorStyle.Bar) {
            if (this.inputMethodData.isTyping()) {
                int w = (int)Math.ceil((double)width / 3.5);
                g.fillRect(xOffset, (y - 1) * lineHeight, w, lineHeight);
            } else {
                g.drawLine(xOffset, y * lineHeight - lineHeight, xOffset, y * lineHeight);
            }
        }
    }

    public final int getAverageCharWidth() {
        this.checkFont();
        return this.getFontMetrics().charWidth('W');
    }

    public final int getLineHeight() {
        this.checkFont();
        return this.getFontMetrics().getHeight();
    }

    @NotNull
    public final FontMetrics getFontMetrics() {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        return fontMetrics;
    }

    private final void checkFont() {
        DatabaseManager.Terminal terminal;
        block5: {
            block4: {
                terminal = DatabaseManager.Companion.getInstance().getTerminal();
                if (!StringsKt.isBlank((CharSequence)terminal.getFallbackFont()) && this.fallbackFont == null || StringsKt.isBlank((CharSequence)terminal.getFallbackFont()) && this.fallbackFont != null) break block4;
                Font font = this.fallbackFont;
                if (Intrinsics.areEqual((Object)terminal.getFallbackFont(), (Object)(font != null ? font.getFamily() : null)) && this.font.getSize() == terminal.getFontSize()) break block5;
            }
            this.fallbackFont = this.getFallbackTerminalFont();
        }
        if (!Intrinsics.areEqual((Object)this.font.getFamily(), (Object)terminal.getFont()) || this.font.getSize() != terminal.getFontSize()) {
            this.font = this.getTerminalFont();
            this.boldFont = this.font.deriveFont(1);
            this.italicFont = this.font.deriveFont(2);
            this.boldItalicFont = this.font.deriveFont(3);
            this.monospacedFont = new Font("Monospaced", this.font.getStyle(), this.font.getSize());
        }
    }

    @NotNull
    public final Position pointToPosition(@NotNull Point point) {
        TerminalLine line;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        int pointY = point.y;
        int pointX = point.x;
        int y = Math.max(1, (int)(Math.ceil(1.0 * (double)pointY / (double)this.getLineHeight()) + (double)this.terminal.getScrollingModel().getVerticalScrollOffset()));
        int x = Math.max(1, (int)Math.ceil(1.0 * (double)pointX / (double)this.getAverageCharWidth()));
        if (y <= this.terminal.getDocument().getLineCount() && x <= (line = this.terminal.getDocument().getLine(y)).chars().size() && ((Character)line.chars().get(x - 1).getFirst()).charValue() == KTermKt.getSoftHyphen(CharCompanionObject.INSTANCE)) {
            --x;
        }
        return new Position(y, x);
    }

    private final void drawCharacters(Graphics2D g) {
        this.drawCharacters$termora(g, this.terminal.getScrollingModel().getVerticalScrollOffset(), this.terminal.getTerminalModel().getRows(), false);
    }

    public final void drawCharacters$termora(@NotNull Graphics2D g, int verticalScrollOffset, int rows, boolean overflowBreak) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        TerminalModel terminalModel = this.terminal.getTerminalModel();
        boolean reverseVideo = terminalModel.getData(DataKey.Companion.getReverseVideo(), false);
        int cols = terminalModel.getCols();
        Triple<String, TextStyle, Integer> triple = new Triple<String, TextStyle, Integer>((Object)String.valueOf(KTermKt.getSpace(CharCompanionObject.INSTANCE)), (Object)TextStyle.box-impl(TextStyle.Companion.getDefault-c2YIwqY()), (Object)1);
        Position cursorPosition = this.terminal.getCursorModel().getPosition();
        int averageCharWidth = this.getAverageCharWidth();
        int maxVerticalScrollOffset = this.terminal.getScrollingModel().getMaxVerticalScrollOffset();
        SelectionModel selectionModel = this.terminal.getSelectionModel();
        CursorStyle cursorStyle = terminalModel.getData(DataKey.Companion.getCursorStyle());
        boolean showCursor = terminalModel.getData(DataKey.Companion.getShowCursor());
        MarkupModel markupModel = this.terminal.getMarkupModel();
        int lineHeight = this.getLineHeight();
        boolean blink = this.terminalBlink.getBlink();
        boolean cursorBlink = this.terminalBlink.getCursorBlink();
        boolean hasFocus = terminalModel.getData(TerminalPanel.Companion.getFocused(), false);
        int lineCount = this.terminal.getDocument().getLineCount();
        int i = 1;
        if (i <= rows) {
            while (true) {
                int xOffset = 0;
                int row = verticalScrollOffset + i - 1;
                if (overflowBreak && row >= lineCount) break;
                Iterator<Triple<String, TextStyle, Integer>> characters = this.smartCharacters(row).iterator();
                int j = 1;
                while (j <= cols) {
                    Position position = new Position(row + 1, j);
                    boolean isCursorLine = i == cursorPosition.getY() + (maxVerticalScrollOffset - verticalScrollOffset);
                    boolean caret = showCursor && j == cursorPosition.getX() + this.inputMethodData.getOffset() && isCursorLine;
                    Triple<String, TextStyle, Integer> triple2 = characters.hasNext() ? characters.next() : triple;
                    String text = (String)triple2.component1();
                    long style = ((TextStyle)triple2.component2()).unbox-impl();
                    int length = ((Number)triple2.component3()).intValue();
                    long textStyle = style;
                    int n = i + verticalScrollOffset;
                    int n2 = j;
                    boolean hasSelection = selectionModel.hasSelection(n2, n);
                    int background = this.getDisplayColor(TextStyle.getBackground-impl(style), TerminalColor.Basic.INSTANCE.getBACKGROUND());
                    int foreground = this.getDisplayColor(TextStyle.getForeground-impl(style), TerminalColor.Basic.INSTANCE.getFOREGROUND());
                    if (reverseVideo || TextStyle.getInverse-impl(style)) {
                        int tmp = foreground;
                        foreground = background;
                        background = tmp;
                    }
                    for (Highlighter highlighter : markupModel.getHighlighters(position)) {
                        long highlighterStyle = highlighter.getTextStyle-mA23jlo(position, textStyle);
                        foreground = this.getDisplayColor(TextStyle.getForeground-impl(highlighterStyle), TerminalColor.Basic.INSTANCE.getFOREGROUND());
                        background = this.getDisplayColor(TextStyle.getBackground-impl(highlighterStyle), TerminalColor.Basic.INSTANCE.getBACKGROUND());
                        textStyle = highlighterStyle;
                    }
                    if (hasSelection) {
                        foreground = this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getSELECTION_FOREGROUND());
                        background = this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getSELECTION_BACKGROUND());
                    }
                    if (TextStyle.getBlink-impl(textStyle) && !blink) continue;
                    g.setFont(this.getDisplayFont-QwXzuJw(text, textStyle));
                    int charWidth = Math.min(Math.max(g.getFontMetrics().stringWidth(text), length * averageCharWidth), length * averageCharWidth);
                    if (terminalModel.getData(TerminalPanel.Companion.getFocusMode(), false).booleanValue() && !TerminalModelKt.isAlternateScreenBuffer(terminalModel) && !isCursorLine) {
                        background = this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND());
                        foreground = UIManager.getColor("textInactiveText").getRGB();
                    }
                    if (TextStyle.getInverse-impl(textStyle) || background != this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())) {
                        g.setColor(new Color(background));
                        g.fillRect(xOffset, (i - 1) * lineHeight, charWidth, lineHeight);
                    }
                    g.setColor(TextStyle.getDim-impl(textStyle) ? new Color(foreground).darker() : new Color(foreground));
                    if (TextStyle.getUnderline-impl(textStyle)) {
                        Stroke stroke = g.getStroke();
                        int width = stroke instanceof BasicStroke ? (int)((BasicStroke)stroke).getLineWidth() : 0;
                        g.drawLine(xOffset, i * lineHeight - width, xOffset + charWidth, i * lineHeight - width);
                    }
                    if (TextStyle.getLineThrough-impl(textStyle)) {
                        int ly = i * lineHeight - lineHeight / 2;
                        g.drawLine(xOffset, ly, xOffset + charWidth, ly);
                    }
                    if (TextStyle.getDoublyUnderline-impl(textStyle)) {
                        if (TextStyle.getUnderline-impl(textStyle)) {
                            g.drawLine(xOffset, i * lineHeight - 3, xOffset + charWidth, i * lineHeight - 3);
                        } else {
                            g.drawLine(xOffset, i * lineHeight, xOffset + charWidth, i * lineHeight);
                            g.drawLine(xOffset, i * lineHeight - 3, xOffset + charWidth, i * lineHeight - 3);
                        }
                    }
                    if (caret && (this.inputMethodData.isTyping() || cursorBlink || !hasFocus)) {
                        this.drawCursor(g, i, xOffset, charWidth);
                        if (hasFocus && cursorStyle == CursorStyle.Block && this.inputMethodData.isNoTyping()) {
                            g.setColor(new Color(this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
                        } else {
                            g.setColor(new Color(foreground));
                        }
                    }
                    g.drawString(text, xOffset, i * lineHeight - g.getFontMetrics().getDescent());
                    xOffset += charWidth;
                    j += length;
                }
                if (i == rows) break;
                ++i;
            }
        }
    }

    private final List<Triple<String, TextStyle, Integer>> smartCharacters(int row) {
        TerminalLineBuffer buffer = this.terminal.getDocument().getCurrentTerminalLineBuffer();
        TerminalLine line = buffer.getLineAt(row);
        List<Triple<String, TextStyle, Integer>> characters = line.characters();
        if (this.inputMethodData.isNoTyping()) {
            return characters;
        }
        Position position = this.terminal.getCursorModel().getPosition();
        if (position.getY() + this.terminal.getScrollingModel().getVerticalScrollOffset() - 1 == row) {
            TerminalLine imeLine = new TerminalLine();
            imeLine.write(0, this.inputMethodData.getChars());
            int index = 0;
            int n = characters.size();
            for (int i = 0; i < n; ++i) {
                if ((index += ((Number)characters.get(i).getThird()).intValue()) < position.getX()) continue;
                characters.addAll(i, (Collection<Triple<String, TextStyle, Integer>>)imeLine.characters());
                break;
            }
        }
        return characters;
    }

    private final int getDisplayColor(int color, TerminalColor terminalColor) {
        if (color == 0) {
            return this.getColorPalette().getColor(terminalColor);
        }
        if (color <= 16) {
            return this.getColorPalette().getXTerm256Color(color);
        }
        return color;
    }

    @NotNull
    public final Font getDisplayFont-QwXzuJw(@NotNull String text, long l) {
        Font displayFont;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TermoraFrameKt.assertEventDispatchThread();
        Font font = displayFont = TextStyle.getBold-impl(l) && TextStyle.getItalic-impl(l) ? this.boldItalicFont : (TextStyle.getItalic-impl(l) ? this.italicFont : (TextStyle.getBold-impl(l) ? this.boldFont : this.font));
        String key = font.getFontName() + ":" + font.getStyle() + ":" + font.getSize() + ":" + text;
        if (lru.containsKey((Object)key)) {
            Font font2;
            c = (RendererFont)((Object)MapsKt.getValue((Map)lru, (Object)key));
            switch (WhenMappings.$EnumSwitchMapping$0[((Enum)c).ordinal()]) {
                case 1: {
                    font2 = font;
                    break;
                }
                case 2: {
                    font2 = this.fallbackFont;
                    if (font2 != null) break;
                    font2 = this.monospacedFont;
                    break;
                }
                default: {
                    font2 = this.monospacedFont;
                }
            }
            font = font2;
        } else {
            c = font;
            Intrinsics.checkNotNull((Object)c);
            if (FontCanDisplay.INSTANCE.canDisplayUpTo((Font)c, text) != -1) {
                Font fallbackTerminalFont;
                Font font3 = this.fallbackFont;
                if (font3 == null) {
                    font3 = this.monospacedFont;
                }
                Font font4 = Intrinsics.areEqual((Object)(fallbackTerminalFont = font3).getFontName(), (Object)this.monospacedFont.getFontName()) ? this.monospacedFont : (font = FontCanDisplay.INSTANCE.canDisplayUpTo(fallbackTerminalFont, text) != -1 ? this.monospacedFont : fallbackTerminalFont);
            }
        }
        if (SystemInfo.isMacOS && Intrinsics.areEqual((Object)font, (Object)this.monospacedFont)) {
            font = displayFont;
        }
        Font font5 = font;
        Intrinsics.checkNotNull((Object)font5);
        return font5;
    }

    private final void drawLineNumber(Graphics g) {
        if (!this.getDebug()) {
            return;
        }
        g.setColor(new DynamicColor("Component.warning.focusedBorderColor"));
        FontMetrics fontMetrics = this.getFontMetrics();
        int lineHeight = this.getLineHeight();
        int verticalScrollOffset = this.terminal.getScrollingModel().getVerticalScrollOffset();
        int i = 1;
        int n = this.getHeight() / lineHeight;
        if (i <= n) {
            while (true) {
                String text = String.valueOf(verticalScrollOffset + i);
                int w = fontMetrics.stringWidth(text);
                g.drawString(text, this.getWidth() - w, i * lineHeight - fontMetrics.getDescent());
                if (i == n) break;
                ++i;
            }
        }
    }

    private final Font getTerminalFont() {
        DatabaseManager.Terminal terminal = DatabaseManager.Companion.getInstance().getTerminal();
        return new Font(terminal.getFont(), 0, terminal.getFontSize());
    }

    private final Font getFallbackTerminalFont() {
        DatabaseManager.Terminal terminal = DatabaseManager.Companion.getInstance().getTerminal();
        return StringsKt.isBlank((CharSequence)terminal.getFallbackFont()) ? null : new Font(terminal.getFallbackFont(), 0, terminal.getFontSize());
    }

    public final void toast-HG0u8IE(@NotNull String text, long l) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.toaster.toast-HG0u8IE(text, l);
    }

    public final void hideToast() {
        this.toaster.hideToast();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003*\u0001\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay$Companion;", "", "<init>", "()V", "lru", "app/termora/terminal/panel/TerminalDisplay$Companion$lru$1", "Lapp/termora/terminal/panel/TerminalDisplay$Companion$lru$1;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay$FontCanDisplay;", "", "<init>", "()V", "canDisplayUpTo", "", "font", "Ljava/awt/Font;", "str", "", "termora"})
    private static final class FontCanDisplay {
        @NotNull
        public static final FontCanDisplay INSTANCE = new FontCanDisplay();

        private FontCanDisplay() {
        }

        public final int canDisplayUpTo(@NotNull Font font, @NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                return font.canDisplayUpTo(str);
            }
            Method getFontMethod = Font.class.getDeclaredMethod("getFont2D", new Class[0]);
            getFontMethod.setAccessible(true);
            Object font2d = getFontMethod.invoke((Object)font, new Object[0]);
            Method getMapperMethod = font2d.getClass().getDeclaredMethod("getMapper", new Class[0]);
            getMapperMethod.setAccessible(true);
            Object mapper = getMapperMethod.invoke(font2d, new Object[0]);
            Class[] classArray = new Class[]{Character.TYPE};
            Method charToGlyphMethod = mapper.getClass().getDeclaredMethod("charToGlyph", classArray);
            int len = str.length();
            int i = 0;
            while (i < len) {
                block7: {
                    block6: {
                        char c = str.charAt(i);
                        Object[] objectArray = new Object[]{Character.valueOf(c)};
                        Object object = charToGlyphMethod.invoke(mapper, objectArray);
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
                        int glyph = (Integer)object;
                        if (glyph >= 0) {
                            ++i;
                            continue;
                        }
                        if (!Character.isHighSurrogate(c)) break block6;
                        objectArray = new Object[]{str.codePointAt(i)};
                        Object object2 = charToGlyphMethod.invoke(mapper, objectArray);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                        if ((Integer)object2 >= 0) break block7;
                    }
                    return i;
                }
                i += 2;
            }
            return -1;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay$RendererFont;", "", "<init>", "(Ljava/lang/String;I)V", "Base", "Monospaced", "Fallback", "termora"})
    public static final class RendererFont
    extends Enum<RendererFont> {
        public static final /* enum */ RendererFont Base = new RendererFont();
        public static final /* enum */ RendererFont Monospaced = new RendererFont();
        public static final /* enum */ RendererFont Fallback = new RendererFont();
        private static final /* synthetic */ RendererFont[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RendererFont[] values() {
            return (RendererFont[])$VALUES.clone();
        }

        public static RendererFont valueOf(String value) {
            return Enum.valueOf(RendererFont.class, value);
        }

        @NotNull
        public static EnumEntries<RendererFont> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rendererFontArray = new RendererFont[]{RendererFont.Base, RendererFont.Monospaced, RendererFont.Fallback};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay$Toast;", "", "text", "", "<init>", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "termora"})
    private static final class Toast {
        @NotNull
        private final String text;

        public Toast(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.text = text;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Toast copy(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return new Toast(text);
        }

        public static /* synthetic */ Toast copy$default(Toast toast2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = toast2.text;
            }
            return toast2.copy(string);
        }

        @NotNull
        public String toString() {
            return "Toast(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Toast)) {
                return false;
            }
            Toast toast2 = (Toast)other;
            return Intrinsics.areEqual((Object)this.text, (Object)toast2.text);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lapp/termora/terminal/panel/TerminalDisplay$Toaster;", "Lapp/termora/terminal/panel/TerminalPaintListener;", "<init>", "(Lapp/termora/terminal/panel/TerminalDisplay;)V", "toasts", "", "Lapp/termora/terminal/panel/TerminalDisplay$Toast;", "after", "", "offset", "", "count", "g", "Ljava/awt/Graphics;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "terminal", "Lapp/termora/terminal/Terminal;", "toast", "text", "", "duration", "Lkotlin/time/Duration;", "toast-HG0u8IE", "(Ljava/lang/String;J)V", "hideToast", "termora"})
    private final class Toaster
    implements TerminalPaintListener {
        @NotNull
        private final List<Toast> toasts = new ArrayList();

        @Override
        public void after(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
            Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            if (this.toasts.isEmpty()) {
                return;
            }
            Toast toast2 = (Toast)CollectionsKt.last(this.toasts);
            Font font = g.getFont();
            g.setFont(TerminalDisplay.this.getDisplayFont-QwXzuJw(toast2.getText(), TextStyle.Companion.getDefault-c2YIwqY()));
            FontMetrics fontMetrics = g.getFontMetrics();
            int lineHeight = fontMetrics.getHeight();
            int width = fontMetrics.stringWidth(toast2.getText()) + TerminalDisplay.this.getAverageCharWidth() * 2;
            int height = lineHeight + lineHeight / 2;
            int x = terminalDisplay.getWidth() / 2 - width / 2;
            int y = terminalDisplay.getHeight() / 2 - height / 2;
            g.setColor(new Color(TerminalDisplay.this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())));
            g.fillRect(x, y, width, height);
            g.setColor(new Color(TerminalDisplay.this.getColorPalette().getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
            g.drawString(toast2.getText(), x + TerminalDisplay.this.getAverageCharWidth(), y + lineHeight);
            g.setFont(font);
        }

        public final void toast-HG0u8IE(@NotNull String text, long l) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            if (!TerminalDisplay.this.terminalPanel.getShowToast()) {
                return;
            }
            Toast toast2 = new Toast(text);
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(l, this, toast2, TerminalDisplay.this, null){
                int label;
                final /* synthetic */ long $$v$c$kotlin-time-Duration$-duration$0;
                final /* synthetic */ Toaster this$0;
                final /* synthetic */ Toast $toast;
                final /* synthetic */ TerminalDisplay this$1;
                {
                    this.$$v$c$kotlin-time-Duration$-duration$0 = l;
                    this.this$0 = $receiver;
                    this.$toast = $toast;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)this.$$v$c$kotlin-time-Duration$-duration$0, (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            Toaster.access$getToasts$p(this.this$0).remove(this.$toast);
                            TerminalDisplay.access$getTerminalPanel$p(this.this$1).repaintImmediate();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this.toasts.add(toast2);
            TerminalDisplay.this.terminalPanel.repaintImmediate();
        }

        public final void hideToast() {
            this.toasts.clear();
            TerminalDisplay.this.terminalPanel.repaintImmediate();
        }

        public static final /* synthetic */ List access$getToasts$p(Toaster $this) {
            return $this.toasts;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RendererFont.values().length];
            try {
                nArray[RendererFont.Base.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RendererFont.Fallback.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

