/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.ScrollingModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModelKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u0001H\u0016J\b\u0010\u000e\u001a\u00020\u0001H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/terminal/ScrollingModelImpl;", "Lapp/termora/terminal/ScrollingModel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "screenModel", "Lapp/termora/terminal/ScrollingModelImpl$ScrollModel;", "scrollModel", "getTerminal", "getVerticalScrollOffset", "", "getMaxVerticalScrollOffset", "getAlternateScreenBufferScrollingModel", "getNonAlternateScreenBufferScrollingModel", "isStick", "", "canVerticalScroll", "getScrollModel", "scrollTo", "", "offset", "scrollToRow", "row", "isInVisibleArea", "ScrollModel", "termora"})
public class ScrollingModelImpl
implements ScrollingModel {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final ScrollModel screenModel;
    @NotNull
    private final ScrollModel scrollModel;

    public ScrollingModelImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.screenModel = new ScrollModel(this.terminal);
        this.scrollModel = new ScrollModel(this.terminal);
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public int getVerticalScrollOffset() {
        return Math.min(this.getScrollModel().getOffset(), this.getMaxVerticalScrollOffset());
    }

    @Override
    public int getMaxVerticalScrollOffset() {
        return this.getScrollModel().getMaxVerticalScrollOffset();
    }

    @Override
    @NotNull
    public ScrollingModel getAlternateScreenBufferScrollingModel() {
        Terminal terminal = this.terminal;
        return new ScrollingModelImpl(this, terminal){
            final /* synthetic */ ScrollingModelImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected ScrollModel getScrollModel() {
                return ScrollingModelImpl.access$getScreenModel$p(this.this$0);
            }

            public ScrollingModel getAlternateScreenBufferScrollingModel() {
                return this;
            }

            public ScrollingModel getNonAlternateScreenBufferScrollingModel() {
                return this.this$0.getNonAlternateScreenBufferScrollingModel();
            }
        };
    }

    @Override
    @NotNull
    public ScrollingModel getNonAlternateScreenBufferScrollingModel() {
        Terminal terminal = this.terminal;
        return new ScrollingModelImpl(this, terminal){
            final /* synthetic */ ScrollingModelImpl this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected ScrollModel getScrollModel() {
                return ScrollingModelImpl.access$getScrollModel$p(this.this$0);
            }

            public ScrollingModel getAlternateScreenBufferScrollingModel() {
                return this.this$0.getAlternateScreenBufferScrollingModel();
            }

            public ScrollingModel getNonAlternateScreenBufferScrollingModel() {
                return this;
            }
        };
    }

    @Override
    public boolean isStick() {
        return this.getScrollModel().getStick();
    }

    @Override
    public boolean canVerticalScroll() {
        return this.getMaxVerticalScrollOffset() > 0;
    }

    @NotNull
    protected ScrollModel getScrollModel() {
        return TerminalModelKt.isAlternateScreenBuffer(this.terminal.getTerminalModel()) ? this.screenModel : this.scrollModel;
    }

    @Override
    public void scrollTo(int offset) {
        ScrollModel model2 = this.getScrollModel();
        int maxVerticalScrollOffset = this.getMaxVerticalScrollOffset();
        if (offset > maxVerticalScrollOffset) {
            model2.setOffset(maxVerticalScrollOffset);
        } else {
            model2.setOffset(offset);
        }
        model2.setStick(model2.getOffset() == maxVerticalScrollOffset);
        this.terminal.getTerminalModel().setData(ScrollingModel.Companion.getScroll(), model2.getOffset());
    }

    @Override
    public void scrollToRow(int row) {
        if (this.isInVisibleArea(row)) {
            return;
        }
        int start2 = this.getVerticalScrollOffset();
        int end = start2 + this.terminal.getTerminalModel().getRows();
        if (row - 1 < start2) {
            this.scrollTo(start2 - Math.abs(row - start2 - 1));
        } else {
            this.scrollTo(start2 + Math.abs(row - end));
        }
    }

    @Override
    public boolean isInVisibleArea(int row) {
        int rows = this.terminal.getTerminalModel().getRows();
        int lineCount = Math.max(this.terminal.getDocument().getLineCount(), rows);
        int offset = Math.max(this.getVerticalScrollOffset(), 0);
        int end = Math.min(lineCount, offset + rows);
        return offset + 1 <= row ? row <= end : false;
    }

    public static final /* synthetic */ ScrollModel access$getScreenModel$p(ScrollingModelImpl $this) {
        return $this.screenModel;
    }

    public static final /* synthetic */ ScrollModel access$getScrollModel$p(ScrollingModelImpl $this) {
        return $this.scrollModel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lapp/termora/terminal/ScrollingModelImpl$ScrollModel;", "", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "value", "", "offset", "getOffset", "()I", "setOffset", "(I)V", "stick", "", "getStick", "()Z", "setStick", "(Z)V", "maxVerticalScrollOffset", "getMaxVerticalScrollOffset", "termora"})
    protected static final class ScrollModel {
        @NotNull
        private final Terminal terminal;
        private int offset;
        private boolean stick;

        public ScrollModel(@NotNull Terminal terminal) {
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            this.terminal = terminal;
            this.stick = true;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int value) {
            this.offset = Math.max(value, 0);
        }

        public final boolean getStick() {
            return this.stick;
        }

        public final void setStick(boolean bl) {
            this.stick = bl;
        }

        public final int getMaxVerticalScrollOffset() {
            return this.terminal.getDocument().getCurrentTerminalLineBuffer().getBufferCount();
        }
    }
}

