/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.StreamPtyConnector;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapp/termora/terminal/PtyProcessConnector;", "Lapp/termora/terminal/StreamPtyConnector;", "process", "Lcom/pty4j/PtyProcess;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Lcom/pty4j/PtyProcess;Ljava/nio/charset/Charset;)V", "getProcess", "()Lcom/pty4j/PtyProcess;", "reader", "Ljava/io/InputStreamReader;", "read", "", "buffer", "", "write", "", "", "offset", "len", "resize", "rows", "cols", "waitFor", "close", "getCharset", "termora"})
public final class PtyProcessConnector
extends StreamPtyConnector {
    @NotNull
    private final PtyProcess process;
    @NotNull
    private final Charset charset;
    @NotNull
    private final InputStreamReader reader;

    public PtyProcessConnector(@NotNull PtyProcess process, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        OutputStream outputStream = process.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        super(inputStream, outputStream);
        this.process = process;
        this.charset = charset;
        this.reader = new InputStreamReader(this.getInput());
    }

    public /* synthetic */ PtyProcessConnector(PtyProcess ptyProcess, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        this(ptyProcess, charset);
    }

    @NotNull
    public final PtyProcess getProcess() {
        return this.process;
    }

    @Override
    public int read(@NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.reader.read(buffer, 0, buffer.length);
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.getOutput().write(buffer, offset, len);
        this.getOutput().flush();
    }

    @Override
    public void resize(int rows, int cols) {
        this.process.setWinSize(new WinSize(cols, rows));
    }

    @Override
    public int waitFor() {
        return this.process.waitFor();
    }

    @Override
    public void close() {
        this.process.destroyForcibly();
    }

    @Override
    @NotNull
    public Charset getCharset() {
        return this.charset;
    }
}

