/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.ControlSequenceIntroducerProcessor;
import app.termora.terminal.CursorModel;
import app.termora.terminal.CursorMove;
import app.termora.terminal.DataKey;
import app.termora.terminal.DeviceControlStringProcessor;
import app.termora.terminal.Document;
import app.termora.terminal.EscapeDesignateCharacterSetProcessor;
import app.termora.terminal.EscapeSequenceProcessor;
import app.termora.terminal.Graphic;
import app.termora.terminal.OperatingSystemCommandProcessor;
import app.termora.terminal.Position;
import app.termora.terminal.Processor;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLineBuffer;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import app.termora.terminal.TextProcessor;
import app.termora.terminal.VisualTerminalKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lapp/termora/terminal/MyProcessor;", "", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "state", "Lapp/termora/terminal/ProcessorState;", "document", "Lapp/termora/terminal/Document;", "getDocument", "()Lapp/termora/terminal/Document;", "cursorModel", "Lapp/termora/terminal/CursorModel;", "getCursorModel", "()Lapp/termora/terminal/CursorModel;", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "processors", "", "Lapp/termora/terminal/Processor;", "getProcessors", "()Ljava/util/Map;", "process", "", "ch", "", "Companion", "termora"})
final class MyProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private ProcessorState state;
    @NotNull
    private final Map<ProcessorState, Processor> processors;
    private static final Logger log = LoggerFactory.getLogger(MyProcessor.class);

    public MyProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.terminal = terminal;
        this.state = TerminalState.READY;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TerminalState.EscapeSequence, (Object)new EscapeSequenceProcessor(this.terminal, reader)), TuplesKt.to((Object)TerminalState.CSI, (Object)new ControlSequenceIntroducerProcessor(this.terminal, reader)), TuplesKt.to((Object)TerminalState.OSC, (Object)new OperatingSystemCommandProcessor(this.terminal, reader)), TuplesKt.to((Object)TerminalState.ESC_LPAREN, (Object)new EscapeDesignateCharacterSetProcessor(this.terminal, reader)), TuplesKt.to((Object)TerminalState.DCS, (Object)new DeviceControlStringProcessor(this.terminal, reader)), TuplesKt.to((Object)TerminalState.Text, (Object)new TextProcessor(this.terminal, reader))};
        this.processors = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    private final Document getDocument() {
        return this.terminal.getDocument();
    }

    private final CursorModel getCursorModel() {
        return this.terminal.getCursorModel();
    }

    private final TerminalModel getTerminalModel() {
        return this.terminal.getTerminalModel();
    }

    @NotNull
    public final Map<ProcessorState, Processor> getProcessors() {
        return this.processors;
    }

    public final void process(char ch) {
        Processor processor;
        if (log.isTraceEnabled()) {
            Position position = this.getCursorModel().getPosition();
            log.trace("process [" + VisualTerminalKt.access$printChar(ch) + "]  , state: " + this.state + " , position: " + position);
        }
        if ((processor = this.processors.get(this.state)) != null) {
            this.state = processor.process(ch);
            return;
        }
        this.state = switch (ch) {
            case '\u001b' -> TerminalState.EscapeSequence;
            case '\u0007' -> {
                this.terminal.getTerminalModel().bell();
                yield TerminalState.READY;
            }
            case '\r' -> {
                this.getCursorModel().move(CursorMove.RowHome);
                yield TerminalState.READY;
            }
            case '\t' -> {
                Position position = this.getCursorModel().getPosition();
                int nextTab = this.terminal.getTabulator().nextTab(position.getX() - 1) + 1;
                int length = TerminalModelKt.isAlternateScreenBuffer(this.getTerminalModel()) ? this.getDocument().getCurrentTerminalLineBuffer().getLineAt(position.getY() - 1).getText().length() : TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this.getDocument().getCurrentTerminalLineBuffer(), position.getY() - 1, 0L, 2, null).getText().length();
                int x = Math.max(position.getX() - 1, length);
                if (x < nextTab) {
                    this.getCursorModel().move(position.getY(), position.getX() - 1 + (nextTab - x));
                } else {
                    this.getCursorModel().move(position.getY(), nextTab);
                }
                yield TerminalState.READY;
            }
            case '\n', '\u000b', '\f' -> {
                this.terminal.getDocument().newline();
                yield TerminalState.READY;
            }
            case '\b' -> {
                this.getCursorModel().move(CursorMove.Left);
                yield TerminalState.READY;
            }
            case '\u000f' -> {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).use(Graphic.G0);
                if (log.isDebugEnabled()) {
                    log.debug("Use Graphic.G0");
                }
                yield TerminalState.READY;
            }
            case '\u000e' -> {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).use(Graphic.G1);
                if (log.isDebugEnabled()) {
                    log.debug("Use Graphic.G1");
                }
                yield TerminalState.READY;
            }
            default -> ((Processor)MapsKt.getValue(this.processors, (Object)TerminalState.Text)).process(ch);
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/MyProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

