/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.AbstractProcessor;
import app.termora.terminal.CharacterSet;
import app.termora.terminal.CursorModel;
import app.termora.terminal.CursorMove;
import app.termora.terminal.CursorStoreStores;
import app.termora.terminal.DataKey;
import app.termora.terminal.Document;
import app.termora.terminal.EscapeDesignateCharacterSetProcessor;
import app.termora.terminal.Graphic;
import app.termora.terminal.GraphicCharacterSet;
import app.termora.terminal.Position;
import app.termora.terminal.ProcessorState;
import app.termora.terminal.ScrollingRegion;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TerminalMouseButton;
import app.termora.terminal.TerminalReader;
import app.termora.terminal.TerminalState;
import app.termora.terminal.TextStyle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lapp/termora/terminal/EscapeSequenceProcessor;", "Lapp/termora/terminal/AbstractProcessor;", "terminal", "Lapp/termora/terminal/Terminal;", "reader", "Lapp/termora/terminal/TerminalReader;", "<init>", "(Lapp/termora/terminal/Terminal;Lapp/termora/terminal/TerminalReader;)V", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "getTerminalModel", "()Lapp/termora/terminal/TerminalModel;", "vt52Mode", "", "getVt52Mode", "()Z", "process", "Lapp/termora/terminal/ProcessorState;", "ch", "", "processTwoCharSequence", "", "first", "second", "Companion", "termora"})
public final class EscapeSequenceProcessor
extends AbstractProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(EscapeSequenceProcessor.class);

    public EscapeSequenceProcessor(@NotNull Terminal terminal, @NotNull TerminalReader reader) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        super(terminal, reader);
    }

    private final TerminalModel getTerminalModel() {
        return this.getTerminal().getTerminalModel();
    }

    private final boolean getVt52Mode() {
        return this.getTerminalModel().getData(DataKey.Companion.getVT52Mode(), false);
    }

    @Override
    @NotNull
    public ProcessorState process(char ch) {
        TerminalState state = TerminalState.READY;
        switch (ch) {
            case '[': {
                state = TerminalState.CSI;
                break;
            }
            case ']': {
                state = TerminalState.OSC;
                break;
            }
            case '<': {
                this.getTerminalModel().setData(DataKey.Companion.getVT52Mode(), false);
                if (!log.isDebugEnabled()) break;
                log.debug("Exit VT52 mode (Enter VT100 mode).");
                break;
            }
            case '>': {
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getAlternateKeypad(), false);
                if (!log.isDebugEnabled()) break;
                log.debug("Normal Keypad (DECKPNM) false");
                break;
            }
            case '=': {
                this.getTerminal().getTerminalModel().setData(DataKey.Companion.getAlternateKeypad(), true);
                if (!log.isDebugEnabled()) break;
                log.debug("Application Keypad (DECKPAM) true");
                break;
            }
            case 'A': {
                if (this.getVt52Mode()) {
                    Object[] objectArray = new Character[]{Character.valueOf('\u001b'), Character.valueOf('['), Character.valueOf('1'), Character.valueOf('A')};
                    this.getReader().addFirst(CollectionsKt.listOf((Object[])objectArray));
                    if (!log.isDebugEnabled()) break;
                    log.debug("ESC A     Cursor up.");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("ESC A     Cursor up. (Not VT52 Mode)");
                break;
            }
            case 'B': {
                if (this.getVt52Mode()) {
                    Object[] objectArray = new Character[]{Character.valueOf('\u001b'), Character.valueOf('['), Character.valueOf('1'), Character.valueOf('B')};
                    this.getReader().addFirst(CollectionsKt.listOf((Object[])objectArray));
                    if (!log.isDebugEnabled()) break;
                    log.debug("ESC B     Cursor down.");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("ESC B     Cursor down. (Not VT52 Mode)");
                break;
            }
            case 'C': {
                if (this.getVt52Mode()) {
                    Object[] objectArray = new Character[]{Character.valueOf('\u001b'), Character.valueOf('['), Character.valueOf('1'), Character.valueOf('C')};
                    this.getReader().addFirst(CollectionsKt.listOf((Object[])objectArray));
                    if (!log.isDebugEnabled()) break;
                    log.debug("ESC C     Cursor right.");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("ESC C     Cursor right. (Not VT52 Mode)");
                break;
            }
            case 'M': {
                Position position = this.getTerminal().getCursorModel().getPosition();
                int top = TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getTop();
                if (position.getY() == top) {
                    Document.scroll$default(this.getTerminal().getDocument(), TerminalMouseButton.ScrollUp, 0, 2, null);
                } else {
                    this.getTerminal().getCursorModel().move(CursorMove.Up);
                }
                if (!log.isDebugEnabled()) break;
                log.debug("Reverse Index (RI  is 0x8d).");
                break;
            }
            case 'N': {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).useOnce(Graphic.G2);
                if (!log.isDebugEnabled()) break;
                log.debug("Single Shift Select of G2 Character Set (SS2  is 0x8e), VT220.");
                break;
            }
            case 'O': {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).useOnce(Graphic.G3);
                if (!log.isDebugEnabled()) break;
                log.debug("Single Shift Select of G3 Character Set (SS3  is 0x8f), VT220.");
                break;
            }
            case 'P': {
                state = TerminalState.DCS;
                break;
            }
            case 'V': {
                if (!log.isWarnEnabled()) break;
                log.warn("Start of Guarded Area (SPA  is 0x96).");
                break;
            }
            case 'W': {
                if (!log.isWarnEnabled()) break;
                log.warn("End of Guarded Area (EPA  is 0x97).");
                break;
            }
            case 'I': {
                if (!this.getVt52Mode()) break;
                if (log.isDebugEnabled()) {
                    log.debug("Reverse line feed.");
                }
                this.getTerminal().getCursorModel().move(CursorMove.Up);
                break;
            }
            case 'H': {
                if (this.getVt52Mode()) {
                    Object[] position = new Character[]{Character.valueOf('\u001b'), Character.valueOf('['), Character.valueOf('1'), Character.valueOf(';'), Character.valueOf('1'), Character.valueOf('H')};
                    this.getReader().addFirst(CollectionsKt.listOf((Object[])position));
                    if (!log.isDebugEnabled()) break;
                    log.debug("Move the cursor to the home position.");
                    break;
                }
                int x = this.getTerminal().getCursorModel().getPosition().getX();
                this.getTerminal().getTabulator().setTabStop(x - 1);
                if (!log.isDebugEnabled()) break;
                log.debug("Horizontal Tab Set (HTS). col: " + x);
                break;
            }
            case 'K': {
                if (this.getVt52Mode()) {
                    this.getTerminal().getDocument().eraseInLine(0);
                    if (!log.isDebugEnabled()) break;
                    log.debug("Erase from the cursor to the end of the screen.");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("ESC K     Erase from the cursor to the end of the line. (Not VT52 Mode)");
                break;
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': {
                TerminalModel terminalModel = this.getTerminalModel();
                DataKey<Graphic> dataKey = EscapeDesignateCharacterSetProcessor.Companion.getGraphic$termora();
                terminalModel.setData(dataKey, switch (ch) {
                    case '*' -> Graphic.G2;
                    case '+' -> Graphic.G3;
                    case ')' -> Graphic.G1;
                    case '-' -> Graphic.G1;
                    case '.' -> Graphic.G2;
                    case '/' -> Graphic.G3;
                    case '(' -> Graphic.G0;
                    default -> Graphic.G0;
                });
                state = TerminalState.ESC_LPAREN;
                break;
            }
            case 'D': {
                if (this.getVt52Mode()) {
                    Object[] x = new Character[]{Character.valueOf('\u001b'), Character.valueOf('['), Character.valueOf('1'), Character.valueOf('D')};
                    this.getReader().addFirst(CollectionsKt.listOf((Object[])x));
                    if (!log.isDebugEnabled()) break;
                    log.debug("Index (IND  is 0x84).");
                    break;
                }
                Position oldPosition = this.getTerminal().getCursorModel().getPosition();
                if (oldPosition.getY() == TerminalModelKt.getScrollingRegion(this.getTerminalModel()).getBottom()) {
                    this.getTerminal().getDocument().newline();
                } else {
                    this.getTerminal().getCursorModel().move(CursorMove.Down);
                }
                Position newPosition = this.getTerminal().getCursorModel().getPosition();
                if (!log.isDebugEnabled()) break;
                log.debug("Index (IND  is 0x84). old: " + oldPosition + " , new: " + newPosition);
                break;
            }
            case 'J': {
                if (this.getVt52Mode()) {
                    this.getTerminal().getDocument().eraseInDisplay(0);
                    if (!log.isDebugEnabled()) break;
                    log.debug("Erase from the cursor to the end of the screen.");
                    break;
                }
                if (!log.isWarnEnabled()) break;
                log.warn("ESC J     Erase from the cursor to the end of the screen.. (Not VT52 Mode)");
                break;
            }
            case 'E': {
                Position oldPosition = this.getTerminal().getCursorModel().getPosition();
                this.getTerminal().getDocument().newline();
                this.getTerminal().getCursorModel().move(CursorMove.RowHome);
                Position newPosition = this.getTerminal().getCursorModel().getPosition();
                if (!log.isDebugEnabled()) break;
                log.debug("Next Line (NEL  is 0x85). old: " + oldPosition + " , new: " + newPosition);
                break;
            }
            case 'c': {
                this.getTerminalModel().setData(DataKey.Companion.getGraphicCharacterSet(), new GraphicCharacterSet(null, null, 3, null));
                this.getTerminalModel().setData(DataKey.Companion.getTextStyle(), TextStyle.box-impl(TextStyle.constructor-impl()));
                this.getTerminalModel().setData(DataKey.Companion.getScrollingRegion(), new ScrollingRegion(1, this.getTerminalModel().getRows()));
                this.getTerminalModel().setData(DataKey.Companion.getSGRMouseMode(), false);
                this.getTerminalModel().setData(DataKey.Companion.getAutoNewline(), false);
                this.getTerminalModel().setData(DataKey.Companion.getReverseVideo(), false);
                this.getTerminalModel().setData(DataKey.Companion.getOriginMode(), false);
                this.getTerminalModel().setData(DataKey.Companion.getAutoWrapMode(), false);
                this.getTerminal().getCursorModel().move(1, 1);
                this.getTerminal().getDocument().eraseInDisplay(2);
                this.getTerminal().getScrollingModel().scrollTo(Integer.MAX_VALUE);
                if (!log.isDebugEnabled()) break;
                log.debug("Full Reset (RIS).");
                break;
            }
            case 'n': {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).use(Graphic.G2);
                if (!log.isDebugEnabled()) break;
                log.debug("Use Graphic.G2");
                break;
            }
            case 'o': {
                this.getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet()).use(Graphic.G3);
                if (!log.isDebugEnabled()) break;
                log.debug("Use Graphic.G3");
                break;
            }
            case '7': {
                CursorStoreStores.INSTANCE.store(this.getTerminal());
                break;
            }
            case '8': {
                CursorStoreStores.INSTANCE.restore(this.getTerminal());
                break;
            }
            case ' ': 
            case '#': 
            case '%': {
                this.processTwoCharSequence(ch, this.getReader().read());
                break;
            }
            case '\\': {
                if (!log.isWarnEnabled()) break;
                log.warn("String Terminator (ST  is 0x9c).");
                break;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error("Unexpected ESC character: " + ch);
            }
        }
        return state;
    }

    private final void processTwoCharSequence(char first, char second) {
        block26: {
            block28: {
                block27: {
                    block25: {
                        if (first != '#') break block25;
                        if (CharsKt.digitToInt((char)second) == 8) {
                            CursorModel cursorModel = this.getTerminal().getCursorModel();
                            Document document = this.getTerminal().getDocument();
                            ScrollingRegion region = this.getTerminalModel().getData(DataKey.Companion.getScrollingRegion());
                            Position caretPosition = cursorModel.getPosition();
                            int cols = this.getTerminalModel().getCols();
                            int i = 1;
                            int n = region.getBottom();
                            if (i <= n) {
                                while (true) {
                                    cursorModel.move(i, 1);
                                    document.write(StringsKt.repeat((CharSequence)"E", (int)cols));
                                    if (i == n) break;
                                    ++i;
                                }
                            }
                            cursorModel.move(caretPosition.getY(), caretPosition.getX());
                            if (log.isDebugEnabled()) {
                                log.debug("DEC Screen Alignment Test (DECALN)");
                            }
                        } else if (log.isWarnEnabled()) {
                            log.warn("Escape DEC Screen Alignment Test (WARN). Unknown: " + second);
                        }
                        break block26;
                    }
                    if (first != '%') break block27;
                    if (log.isWarnEnabled()) {
                        switch (second) {
                            case '@': {
                                log.warn("Select default character set.  That is ISO 8859-1 (ISO 2022).");
                                break;
                            }
                            case 'G': {
                                log.warn("Select UTF-8 character set, ISO 2022.");
                            }
                            default: {
                                break;
                            }
                        }
                    }
                    break block26;
                }
                if (first != ' ') break block28;
                GraphicCharacterSet graphicCharacterSet = this.getTerminal().getTerminalModel().getData(DataKey.Companion.getGraphicCharacterSet());
                switch (second) {
                    case 'F': {
                        if (log.isErrorEnabled()) {
                            log.error("7-bit controls (S7C1T), VT220.");
                            break;
                        }
                        break block26;
                    }
                    case 'G': {
                        if (log.isErrorEnabled()) {
                            log.error("8-bit controls (S8C1T), VT220.");
                            break;
                        }
                        break block26;
                    }
                    case 'L': {
                        graphicCharacterSet.designate(Graphic.G1, CharacterSet.USASCII);
                        if (log.isDebugEnabled()) {
                            log.debug("Set ANSI conformance level 1, ECMA-43.");
                            break;
                        }
                        break block26;
                    }
                    case 'M': {
                        graphicCharacterSet.designate(Graphic.G2, CharacterSet.USASCII);
                        if (log.isDebugEnabled()) {
                            log.debug("Set ANSI conformance level 2, ECMA-43.");
                            break;
                        }
                        break block26;
                    }
                    case 'N': {
                        graphicCharacterSet.designate(Graphic.G3, CharacterSet.USASCII);
                        if (log.isDebugEnabled()) {
                            log.debug("Set ANSI conformance level 3, ECMA-43.");
                            break;
                        }
                        break block26;
                    }
                    default: {
                        if (log.isWarnEnabled()) {
                            log.warn("Unknown character set: " + second);
                            break;
                        }
                        break block26;
                    }
                }
                break block26;
            }
            if (log.isErrorEnabled()) {
                log.error("Unexpected ESC character first: " + first + " , second: " + second);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/terminal/EscapeSequenceProcessor$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

