/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.CursorMove;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.Document;
import app.termora.terminal.Position;
import app.termora.terminal.ScrollingModel;
import app.termora.terminal.ScrollingRegion;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalLineBuffer;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TerminalMouseButton;
import app.termora.terminal.TerminalResize;
import app.termora.terminal.TerminalSize;
import app.termora.terminal.TextStyle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClasses;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u0018\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0013H\u0016J\b\u0010%\u001a\u00020\u0011H\u0016J\b\u0010&\u001a\u00020\u0003H\u0016J\u0018\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lapp/termora/terminal/DocumentImpl;", "Lapp/termora/terminal/Document;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "terminalBuffer", "Lapp/termora/terminal/TerminalLineBuffer;", "screenBuffer", "terminalModel", "Lapp/termora/terminal/TerminalModel;", "currentBuffer", "getCurrentBuffer", "()Lapp/termora/terminal/TerminalLineBuffer;", "getText", "", "eraseInDisplay", "", "n", "", "eraseInLine", "getLine", "Lapp/termora/terminal/TerminalLine;", "row", "getScreenLine", "write", "text", "getLineCount", "getCurrentTerminalLineBuffer", "getScreenTerminalLineBuffer", "getTerminalLineBuffer", "scroll", "button", "Lapp/termora/terminal/TerminalMouseButton;", "count", "deleteLines", "offset", "newline", "getTerminal", "resize", "oldSize", "Lapp/termora/terminal/TerminalSize;", "newSize", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nDocumentImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentImpl.kt\napp/termora/terminal/DocumentImpl\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,151:1\n24#2:152\n63#2,3:153\n*S KotlinDebug\n*F\n+ 1 DocumentImpl.kt\napp/termora/terminal/DocumentImpl\n*L\n143#1:152\n143#1:153,3\n*E\n"})
public class DocumentImpl
implements Document {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final TerminalLineBuffer terminalBuffer;
    @NotNull
    private final TerminalLineBuffer screenBuffer;
    @NotNull
    private final TerminalModel terminalModel;
    private static final Logger log = LoggerFactory.getLogger(DocumentImpl.class);
    @NotNull
    private static final DataKey<Integer> OverflowLines = new DataKey(Reflection.getOrCreateKotlinClass(Integer.TYPE));

    public DocumentImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        this.terminalBuffer = new TerminalLineBuffer(this.terminal, false);
        this.screenBuffer = new TerminalLineBuffer(this.terminal, true);
        this.terminalModel = this.terminal.getTerminalModel();
        this.terminal.getTerminalModel().addDataListener(new DataListener(){

            @Override
            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (!Intrinsics.areEqual(key, TerminalModel.Companion.getResize())) {
                    return;
                }
                TerminalResize resize = (TerminalResize)KClasses.cast(TerminalModel.Companion.getResize().getClazz(), (Object)data);
                this.resize(resize.getOldSize(), resize.getNewSize());
            }
        });
    }

    private final TerminalLineBuffer getCurrentBuffer() {
        return TerminalModelKt.isAlternateScreenBuffer(this.terminalModel) ? this.screenBuffer : this.terminalBuffer;
    }

    @Override
    @NotNull
    public String getText() {
        return this.getCurrentBuffer().getText();
    }

    @Override
    public void eraseInDisplay(int n) {
        if (log.isDebugEnabled()) {
            Position position = this.terminal.getCursorModel().getPosition();
            log.debug("Erase In Display " + n + ". rows:" + this.terminalModel.getRows() + " , y: " + position.getY() + " , x: " + position.getX() + " , attr: " + TextStyle.toString-impl(this.terminalModel.getData(DataKey.Companion.getTextStyle()).unbox-impl()));
        }
        this.getCurrentBuffer().eraseInDisplay(n);
    }

    @Override
    public void eraseInLine(int n) {
        this.getCurrentBuffer().eraseInLine(n);
    }

    @Override
    @NotNull
    public TerminalLine getLine(int row) {
        return this.getCurrentBuffer().getLineAt(row - 1);
    }

    @Override
    @NotNull
    public TerminalLine getScreenLine(int row) {
        return TerminalLineBuffer.getScreenLineAt-QwXzuJw$default(this.getCurrentBuffer(), row - 1, 0L, 2, null);
    }

    @Override
    public void write(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.getCurrentBuffer().write(text);
        ScrollingModel scrollingModel = this.terminal.getScrollingModel();
        if (scrollingModel.isStick()) {
            scrollingModel.scrollTo(Integer.MAX_VALUE);
        }
    }

    @Override
    public int getLineCount() {
        return this.getCurrentBuffer().getLineCount();
    }

    @Override
    @NotNull
    public TerminalLineBuffer getCurrentTerminalLineBuffer() {
        return this.getCurrentBuffer();
    }

    @Override
    @NotNull
    public TerminalLineBuffer getScreenTerminalLineBuffer() {
        return this.screenBuffer;
    }

    @Override
    @NotNull
    public TerminalLineBuffer getTerminalLineBuffer() {
        return this.terminalBuffer;
    }

    @Override
    public void scroll(@NotNull TerminalMouseButton button, int count) {
        Intrinsics.checkNotNullParameter((Object)((Object)button), (String)"button");
        ScrollingRegion scrollingRegion = this.terminal.getTerminalModel().getData(DataKey.Companion.getScrollingRegion());
        int top = scrollingRegion.getTop();
        int bottom = scrollingRegion.getBottom();
        if (button == TerminalMouseButton.ScrollUp) {
            this.getCurrentBuffer().insertLines(top, bottom, count);
        } else if (button == TerminalMouseButton.ScrollDown) {
            this.getCurrentBuffer().deleteLines(top, bottom, count);
        }
    }

    @Override
    public void deleteLines(int offset, int count) {
        ScrollingRegion scrollingRegion = this.terminal.getTerminalModel().getData(DataKey.Companion.getScrollingRegion());
        this.getCurrentBuffer().deleteLines(offset, scrollingRegion.getBottom(), count);
    }

    @Override
    public void newline() {
        this.terminal.getCursorModel().move(CursorMove.Down);
        if (this.terminal.getTerminalModel().getData(DataKey.Companion.getAutoNewline(), false).booleanValue()) {
            this.terminal.getCursorModel().move(CursorMove.RowHome);
        }
        ScrollingRegion scrollingRegion = TerminalModelKt.getScrollingRegion(this.terminalModel);
        Position caret = this.terminal.getCursorModel().getPosition();
        if (caret.getY() > scrollingRegion.getBottom()) {
            int n = Math.abs(caret.getY() - scrollingRegion.getBottom());
            for (int i = 0; i < n; ++i) {
                Document.scroll$default(this, TerminalMouseButton.ScrollDown, 0, 2, null);
            }
            this.terminal.getCursorModel().move(scrollingRegion.getBottom(), caret.getX());
        } else if (caret.getY() < scrollingRegion.getTop()) {
            this.terminal.getCursorModel().move(scrollingRegion.getTop(), caret.getX());
        }
        if (this.terminal.getScrollingModel().isStick()) {
            this.terminal.getScrollingModel().scrollTo(Integer.MAX_VALUE);
        }
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    private final void resize(TerminalSize oldSize, TerminalSize newSize) {
        if (Intrinsics.areEqual((Object)oldSize, (Object)newSize)) {
            return;
        }
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.terminalBuffer.resize(oldSize, newSize);
        long it = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        boolean bl2 = false;
        if (log.isDebugEnabled()) {
            log.debug("resize(" + this.getLineCount() + "): " + Duration.getInWholeMilliseconds-impl((long)it) + "ms");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/DocumentImpl$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "OverflowLines", "Lapp/termora/terminal/DataKey;", "", "getOverflowLines", "()Lapp/termora/terminal/DataKey;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Integer> getOverflowLines() {
            return OverflowLines;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

