/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal;

import app.termora.terminal.ColorPalette;
import app.termora.terminal.ColorTheme;
import app.termora.terminal.DefaultColorTheme;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lapp/termora/terminal/ColorPaletteImpl;", "Lapp/termora/terminal/ColorPalette;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "xterm256Colors", "", "", "[Ljava/lang/Integer;", "theme", "Lapp/termora/terminal/DefaultColorTheme;", "getTheme", "()Lapp/termora/terminal/DefaultColorTheme;", "theme$delegate", "Lkotlin/Lazy;", "getTerminal", "getColor", "color", "Lapp/termora/terminal/TerminalColor;", "Lapp/termora/terminal/ColorTheme;", "index", "getCubeColorValue", "value", "getXTerm256Color", "termora"})
@SourceDebugExtension(value={"SMAP\nColorPaletteImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorPaletteImpl.kt\napp/termora/terminal/ColorPaletteImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public class ColorPaletteImpl
implements ColorPalette {
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final Integer[] xterm256Colors;
    @NotNull
    private final Lazy theme$delegate;

    public ColorPaletteImpl(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminal = terminal;
        int n = 0;
        Integer[] integerArray = new Integer[240];
        ColorPaletteImpl colorPaletteImpl = this;
        while (n < 240) {
            int n2 = n++;
            integerArray[n2] = 0;
        }
        colorPaletteImpl.xterm256Colors = integerArray;
        this.theme$delegate = LazyKt.lazy(ColorPaletteImpl::theme_delegate$lambda$0);
        for (int r = 0; r < 6; ++r) {
            for (int g = 0; g < 6; ++g) {
                for (int b = 0; b < 6; ++b) {
                    int idx = 36 * r + 6 * g + b;
                    int x = this.getCubeColorValue(r);
                    int y = this.getCubeColorValue(g);
                    int z = this.getCubeColorValue(b);
                    this.xterm256Colors[idx] = 65536 * x + 256 * y + z;
                }
            }
        }
        for (int gray = 0; gray < 24; ++gray) {
            int a = 10 * gray + 8;
            int idx = 216 + gray;
            this.xterm256Colors[idx] = 65536 * a + 256 * a + a;
        }
    }

    private final DefaultColorTheme getTheme() {
        Lazy lazy = this.theme$delegate;
        return (DefaultColorTheme)lazy.getValue();
    }

    @Override
    @NotNull
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public int getColor(@NotNull TerminalColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return this.getTheme().getColor(color);
    }

    @NotNull
    public ColorTheme getTheme() {
        return this.getTheme();
    }

    private final int getColor(int index) {
        return switch (index) {
            case 0, 1 -> this.getColor(TerminalColor.Normal.INSTANCE.getBLACK());
            case 2 -> this.getColor(TerminalColor.Normal.INSTANCE.getRED());
            case 3 -> this.getColor(TerminalColor.Normal.INSTANCE.getGREEN());
            case 4 -> this.getColor(TerminalColor.Normal.INSTANCE.getYELLOW());
            case 5 -> this.getColor(TerminalColor.Normal.INSTANCE.getBLUE());
            case 6 -> this.getColor(TerminalColor.Normal.INSTANCE.getMAGENTA());
            case 7 -> this.getColor(TerminalColor.Normal.INSTANCE.getCYAN());
            case 8 -> this.getColor(TerminalColor.Normal.INSTANCE.getWHITE());
            case 9 -> this.getColor(TerminalColor.Bright.INSTANCE.getBLACK());
            case 10 -> this.getColor(TerminalColor.Bright.INSTANCE.getRED());
            case 11 -> this.getColor(TerminalColor.Bright.INSTANCE.getGREEN());
            case 12 -> this.getColor(TerminalColor.Bright.INSTANCE.getYELLOW());
            case 13 -> this.getColor(TerminalColor.Bright.INSTANCE.getBLUE());
            case 14 -> this.getColor(TerminalColor.Bright.INSTANCE.getMAGENTA());
            case 15 -> this.getColor(TerminalColor.Bright.INSTANCE.getCYAN());
            case 16 -> this.getColor(TerminalColor.Bright.INSTANCE.getWHITE());
            default -> {
                Integer v2;
                Integer[] var2_2 = this.xterm256Colors;
                int var3_3 = index - 16;
                boolean v1 = 0 <= var3_3 ? var3_3 < var2_2.length : false;
                if (v1) {
                    v2 = var2_2[var3_3];
                } else {
                    int it = var3_3;
                    boolean $i$a$-getOrElse-ColorPaletteImpl$getColor$1 = false;
                    v2 = this.getColor(TerminalColor.Normal.INSTANCE.getWHITE());
                }
                yield ((Number)v2).intValue();
            }
        };
    }

    private final int getCubeColorValue(int value) {
        return value == 0 ? 0 : 40 * value + 55;
    }

    @Override
    public int getXTerm256Color(int index) {
        Integer n;
        if (index <= 16) {
            return this.getColor(index);
        }
        Integer[] integerArray = this.xterm256Colors;
        int n2 = index - 17;
        boolean bl = 0 <= n2 ? n2 < integerArray.length : false;
        if (bl) {
            n = integerArray[n2];
        } else {
            int it = n2;
            boolean bl2 = false;
            n = this.getColor(TerminalColor.Normal.INSTANCE.getWHITE());
        }
        return ((Number)n).intValue();
    }

    private static final DefaultColorTheme theme_delegate$lambda$0() {
        return new DefaultColorTheme();
    }
}

