/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.marketplace;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.ResponseException;
import app.termora.ScopeKt;
import app.termora.plugin.PluginDescription;
import app.termora.plugin.internal.plugin.PluginRepositoryManager;
import app.termora.plugin.internal.plugin.PluginSVGIcon;
import app.termora.plugin.marketplace.MarketplacePlugin;
import app.termora.plugin.marketplace.MarketplacePluginVersion;
import app.termora.plugin.marketplace.PluginVendor;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jetbrains.annotations.NotNull;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/termora/plugin/marketplace/MarketplaceManager;", "", "<init>", "()V", "isLoading", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "plugins", "", "Lapp/termora/plugin/marketplace/MarketplacePlugin;", "exceptionReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getPlugins", "", "clear", "", "refreshPlugins", "doGetPlugins", "url", "", "version", "Lorg/semver4j/Semver;", "Companion", "MarketplaceManagerReady", "termora"})
@SourceDebugExtension(value={"SMAP\nMarketplaceManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceManager.kt\napp/termora/plugin/marketplace/MarketplaceManager\n+ 2 -JvmPlatform.kt\nokio/_JvmPlatformKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,266:1\n40#2:267\n1563#3:268\n1634#3,3:269\n1491#3:272\n1516#3,3:273\n1519#3,3:283\n1969#3,14:286\n1056#3:300\n1021#3,2:302\n382#4,7:276\n1#5:301\n*S KotlinDebug\n*F\n+ 1 MarketplaceManager.kt\napp/termora/plugin/marketplace/MarketplaceManager\n*L\n72#1:267\n106#1:268\n106#1:269,3\n141#1:272\n141#1:273,3\n141#1:283,3\n144#1:286,14\n147#1:300\n204#1:302,2\n141#1:276,7\n*E\n"})
public final class MarketplaceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isLoading = new AtomicBoolean(false);
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    @NotNull
    private final List<MarketplacePlugin> plugins = new ArrayList();
    @NotNull
    private final AtomicReference<Exception> exceptionReference = new AtomicReference<Object>(null);
    private static final Logger log = LoggerFactory.getLogger(MarketplaceManager.class);

    private MarketplaceManager() {
    }

    @NotNull
    public final List<MarketplacePlugin> getPlugins() {
        if (!((Collection)this.plugins).isEmpty()) {
            return this.plugins;
        }
        this.refreshPlugins();
        return this.plugins;
    }

    public final void clear() {
        this.plugins.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void refreshPlugins() {
        if (this.isLoading.compareAndSet(false, true)) {
            Object pls;
            try {
                this.exceptionReference.set(null);
                pls = this.doGetPlugins();
                this.plugins.clear();
                pls = this.plugins.addAll((Collection)pls);
            }
            catch (Exception e) {
                this.exceptionReference.set(e);
                if (log.isErrorEnabled()) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                pls = Unit.INSTANCE;
            }
            finally {
                ReentrantLock $this$withLock$iv = this.lock;
                boolean $i$f$withLock = false;
                Lock lock = $this$withLock$iv;
                lock.lock();
                try {
                    boolean bl = false;
                    this.isLoading.set(false);
                    this.condition.signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        } else {
            this.lock.lock();
            try {
                this.condition.await();
            }
            finally {
                this.lock.unlock();
            }
        }
        Exception exception = this.exceptionReference.get();
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<MarketplacePlugin> doGetPlugins() {
        Iterable $this$groupByTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterator $this$map$iv;
        Semver semver = Semver.parse((String)Application.INSTANCE.getVersion());
        if (semver == null) {
            return CollectionsKt.emptyList();
        }
        Semver version = semver;
        List repositories = CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)PluginRepositoryManager.Companion.getInstance().getRepositories()));
        if (I18n.INSTANCE.isChinaMainland()) {
            repositories.addFirst("https://plugins.termora.cn/plugins.xml");
        } else {
            repositories.addFirst("https://github.com/TermoraDev/termora-marketplace/releases/latest/download/plugins.xml");
        }
        List plugins = new ArrayList();
        ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();
        Iterable iterable = repositories;
        Object object = executorService;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            String string = (String)item$iv$iv;
            Collection collection2 = collection;
            boolean bl = false;
            collection2.add(() -> MarketplaceManager.doGetPlugins$lambda$0$0(this, (String)((Object)it), version));
        }
        List futures = object.invokeAll((List)collection, 30L, TimeUnit.SECONDS);
        for (Future future2 : futures) {
            try {
                if (!future2.isDone()) continue;
                Object t = future2.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                plugins.addAll((Collection)t);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        executorService.shutdown();
        if (plugins.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List matchedPlugins = new ArrayList();
        block4: for (MarketplacePlugin e : plugins) {
            for (MarketplacePluginVersion plugin : e.getVersions()) {
                if (!version.satisfies(plugin.getSince()) || !StringsKt.isBlank((CharSequence)plugin.getUntil()) && !version.satisfies(plugin.getUntil())) continue;
                Object[] objectArray = new MarketplacePluginVersion[]{plugin};
                matchedPlugins.add(MarketplacePlugin.copy$default(e, null, null, false, null, CollectionsKt.mutableListOf((Object[])objectArray), null, null, 111, null));
                continue block4;
            }
        }
        Iterable $this$groupBy$iv = matchedPlugins;
        boolean bl = false;
        Iterable plugin = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            MarketplacePlugin it = (MarketplacePlugin)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = it.getId();
            Map map = destination$iv$iv2;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map map = destination$iv$iv2;
        matchedPlugins.clear();
        for (Map.Entry entry : map.entrySet()) {
            Object t;
            void $this$maxBy$iv;
            $this$groupByTo$iv$iv = (Iterable)entry.getValue();
            object = matchedPlugins;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                MarketplacePlugin it = (MarketplacePlugin)maxElem$iv;
                boolean bl3 = false;
                Comparable maxValue$iv = (Comparable)((MarketplacePluginVersion)CollectionsKt.first(it.getVersions())).getVersion();
                do {
                    Object e$iv = iterator$iv.next();
                    MarketplacePlugin it2 = (MarketplacePlugin)e$iv;
                    boolean bl4 = false;
                    Comparable v$iv = (Comparable)((MarketplacePluginVersion)CollectionsKt.first(it2.getVersions())).getVersion();
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            object.add(t);
        }
        Iterable $this$sortedBy$iv = matchedPlugins;
        boolean bl5 = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                MarketplacePlugin it = (MarketplacePlugin)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getName().length());
                it = (MarketplacePlugin)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getName().length()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<MarketplacePlugin> getPlugins(String url, Semver version) {
        ResponseBody responseBody;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string = I18n.INSTANCE.containsLanguage(locale);
        if (string == null) {
            string = "en_US";
        }
        String language = string;
        Request.Builder builder2 = new Request.Builder().get();
        String string2 = version.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Request.Builder builder3 = builder2.header("X-Version", string2).header("X-Language", language);
        String string3 = SystemUtils.OS_NAME;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"OS_NAME");
        Request.Builder builder4 = builder3.header("X-OS", string3);
        String string4 = SystemUtils.OS_ARCH;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"OS_ARCH");
        Request request = builder4.header("X-Arch", string4).url(url).build();
        Response response = Application.INSTANCE.getHttpClient().newCall(request).execute();
        if (!response.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            throw new ResponseException(response.code(), response);
        }
        Object object = (Closeable)response;
        Throwable throwable = null;
        try {
            Object object2;
            Response res = (Response)object;
            boolean bl = false;
            ResponseBody responseBody2 = res.body();
            if (responseBody2 != null) {
                Closeable closeable = (Closeable)responseBody2;
                Throwable throwable2 = null;
                try {
                    Object it = (ResponseBody)closeable;
                    boolean bl2 = false;
                    it = it.string();
                    object2 = it;
                }
                catch (Throwable bl2) {
                    throwable2 = bl2;
                    throw bl2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
            } else {
                object2 = null;
            }
            responseBody = object2;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Object text = responseBody;
        object = (CharSequence)text;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            throw new ResponseException(response.code(), response);
        }
        Element root = new SAXReader().read(new InputSource(new StringReader((String)text))).getRootElement();
        List plugins = new ArrayList();
        for (Element pluginElement : root.elements("plugin")) {
            Object object3;
            Object object4;
            Object object5;
            Object icon;
            Object object6 = pluginElement.element("id");
            if (object6 == null || (object6 = object6.getTextTrim()) == null) continue;
            Object id = object6;
            Object object7 = pluginElement.element("name");
            if (object7 == null || (object7 = object7.getTextTrim()) == null) continue;
            Object name = object7;
            boolean paid = pluginElement.element("paid") != null;
            Object object8 = pluginElement.element("icon");
            if (object8 == null || (object8 = object8.getTextTrim()) == null) {
                object8 = icon = "";
            }
            if ((object5 = pluginElement.element("dark-icon")) == null || (object5 = object5.getTextTrim()) == null) {
                object5 = "";
            }
            Object darkIcon = object5;
            List descriptions = new ArrayList();
            List versions = new ArrayList();
            PluginVendor vendor = new PluginVendor("", "");
            Object object9 = pluginElement.element("versions");
            if (object9 == null || (object9 = object9.elements("version")) == null) {
                object9 = CollectionsKt.emptyList();
            }
            Iterator iterator2 = object9.iterator();
            while (iterator2.hasNext()) {
                Semver version2;
                Object object10;
                Object until;
                Object object11;
                Element versionElement = (Element)iterator2.next();
                Object object12 = versionElement.element("version");
                if (object12 == null) continue;
                if ((object12 = object12.getTextTrim()) == null || Semver.parse((String)object12) == null || (object11 = versionElement.element("since")) == null || (object11 = object11.getTextTrim()) == null) continue;
                Object since = object11;
                Object object13 = versionElement.element("until");
                if (object13 == null || (object13 = object13.getTextTrim()) == null) {
                    object13 = until = "";
                }
                if ((object10 = versionElement.element("download-url")) == null || (object10 = object10.getTextTrim()) == null) continue;
                Object downloadUrl = object10;
                Object object14 = versionElement.element("signature");
                if (object14 == null || (object14 = object14.getTextTrim()) == null) continue;
                Object signature = object14;
                versions.add(new MarketplacePluginVersion(version2, (String)since, (String)until, (String)downloadUrl, (String)signature));
            }
            Object $this$sortByDescending$iv = versions;
            boolean $i$f$sortByDescending = false;
            if ($this$sortByDescending$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        MarketplacePluginVersion it = (MarketplacePluginVersion)b;
                        boolean bl = false;
                        Comparable comparable = (Comparable)it.getVersion();
                        it = (MarketplacePluginVersion)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)it.getVersion()));
                    }
                });
            }
            if ((object4 = pluginElement.element("descriptions")) == null || (object4 = object4.elements("description")) == null) {
                object4 = CollectionsKt.emptyList();
            }
            $this$sortByDescending$iv = object4.iterator();
            while ($this$sortByDescending$iv.hasNext()) {
                Element elementDescription = (Element)$this$sortByDescending$iv.next();
                String string5 = elementDescription.attributeValue("language");
                if (string5 == null) {
                    string5 = "";
                }
                String string6 = elementDescription.getTextTrim();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getTextTrim(...)");
                descriptions.add(new PluginDescription(string5, string6));
            }
            Element vendorElement = pluginElement.element("vendor");
            if (vendorElement != null) {
                String string7 = vendorElement.getTextTrim();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getTextTrim(...)");
                vendor = PluginVendor.copy$default(vendor, string7, null, 2, null);
                String url2 = vendorElement.attributeValue("url");
                object3 = url2;
                if (!(object3 == null || StringsKt.isBlank((CharSequence)object3))) {
                    vendor = PluginVendor.copy$default(vendor, null, url2, 1, null);
                }
            }
            Icon myIcon = (Icon)((Object)Icons.INSTANCE.getPlugin());
            if (!StringsKt.isBlank((CharSequence)((CharSequence)icon)) && !StringsKt.isBlank((CharSequence)((CharSequence)darkIcon))) {
                object3 = icon;
                byte[] byArray = ((String)object3).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object3 = byArray;
                InputStream inputStream = new ByteArrayInputStream((byte[])object3);
                object3 = darkIcon;
                byte[] byArray2 = ((String)object3).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                object3 = byArray2;
                myIcon = new PluginSVGIcon(inputStream, new ByteArrayInputStream((byte[])object3));
            } else if (!StringsKt.isBlank((CharSequence)((CharSequence)icon))) {
                object3 = icon;
                byte[] byArray = ((String)object3).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object3 = byArray;
                myIcon = new PluginSVGIcon(new ByteArrayInputStream((byte[])object3), null, 2, null);
            }
            plugins.add(new MarketplacePlugin((String)id, (String)name, paid, myIcon, versions, descriptions, vendor));
        }
        return plugins;
    }

    private static final List doGetPlugins$lambda$0$0(MarketplaceManager this$0, String $it, Semver $version) {
        return this$0.getPlugins($it, $version);
    }

    public /* synthetic */ MarketplaceManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$refreshPlugins(MarketplaceManager $this) {
        $this.refreshPlugins();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugin/marketplace/MarketplaceManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugin/marketplace/MarketplaceManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MarketplaceManager getInstance() {
            return (MarketplaceManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(MarketplaceManager.class), Companion::getInstance$lambda$0);
        }

        private static final MarketplaceManager getInstance$lambda$0() {
            return new MarketplaceManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lapp/termora/plugin/marketplace/MarketplaceManager$MarketplaceManagerReady;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "ready", "", "Companion", "termora"})
    public static final class MarketplaceManagerReady
    implements ApplicationRunnerExtension {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final MarketplaceManagerReady instance = new MarketplaceManagerReady();

        private MarketplaceManagerReady() {
        }

        @Override
        public void ready() {
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var6_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                            if (v0 == var6_3) {
                                return var6_3;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 4 sources

                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                var3_4 = $this$launch;
                                try {
                                    $this$invokeSuspend_u24lambda_u240 = var3_4;
                                    $i$a$-runCatching-MarketplaceManager$MarketplaceManagerReady$ready$1$1 = false;
                                    MarketplaceManager.access$refreshPlugins(MarketplaceManager.Companion.getInstance());
                                    var4_5 = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable var5_7) {
                                    var4_5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_7));
                                }
                                this.L$0 = $this$launch;
                                this.label = 2;
                                v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS), (Continuation)((Continuation)this));
                                if (v1 != var6_3) continue;
                                return var6_3;
                            }
                            break;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl16
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/plugin/marketplace/MarketplaceManager$MarketplaceManagerReady$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/plugin/marketplace/MarketplaceManager$MarketplaceManagerReady;", "getInstance", "()Lapp/termora/plugin/marketplace/MarketplaceManager$MarketplaceManagerReady;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MarketplaceManagerReady getInstance() {
                return instance;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

