/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.wsl;

import app.termora.plugin.internal.wsl.WSLDistribution;
import com.formdev.flatlaf.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\bH\u0002J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugin/internal/wsl/WSLSupport;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "isSupported", "", "()Z", "isSupported$delegate", "Lkotlin/Lazy;", "checkSupported", "getDistributions", "", "Lapp/termora/plugin/internal/wsl/WSLDistribution;", "termora"})
public final class WSLSupport {
    @NotNull
    public static final WSLSupport INSTANCE = new WSLSupport();
    private static final Logger log = LoggerFactory.getLogger(INSTANCE.getClass());
    @NotNull
    private static final Lazy isSupported$delegate = LazyKt.lazy(WSLSupport::isSupported_delegate$lambda$0);

    private WSLSupport() {
    }

    public final boolean isSupported() {
        Lazy lazy = isSupported$delegate;
        return (Boolean)lazy.getValue();
    }

    private final boolean checkSupported() {
        if (!SystemInfo.isWindows) {
            return false;
        }
        String string = System.getenv("SystemRoot");
        if (string == null) {
            return false;
        }
        String drive = string;
        String[] stringArray = new String[]{drive, "System32", "wsl.exe"};
        File wsl = FileUtils.getFile((String[])stringArray);
        return wsl.exists();
    }

    @NotNull
    public final List<WSLDistribution> getDistributions() {
        List distributions;
        block6: {
            if (!this.isSupported()) {
                return CollectionsKt.emptyList();
            }
            distributions = new ArrayList();
            try {
                String baseKeyPath = "Software\\Microsoft\\Windows\\CurrentVersion\\Lxss";
                String[] guids = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)baseKeyPath);
                Intrinsics.checkNotNull((Object)guids);
                for (String guid : guids) {
                    String key = baseKeyPath + "\\" + guid;
                    try {
                        if (!Advapi32Util.registryKeyExists((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key)) continue;
                        String distroName = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)"DistributionName");
                        String basePath = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)"BasePath");
                        String flavor = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)key, (String)"Flavor");
                        Object object = new CharSequence[]{distroName, guid, basePath, flavor};
                        if (StringUtils.isAnyBlank((CharSequence[])object)) continue;
                        Intrinsics.checkNotNull((Object)guid);
                        object = guid;
                        Intrinsics.checkNotNull((Object)flavor);
                        String string = flavor;
                        Intrinsics.checkNotNull((Object)basePath);
                        String string2 = basePath;
                        Intrinsics.checkNotNull((Object)distroName);
                        String string3 = distroName;
                        distributions.add(new WSLDistribution((String)object, string3, string, string2));
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return distributions;
    }

    private static final boolean isSupported_delegate$lambda$0() {
        return INSTANCE.checkSupported();
    }
}

