/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.wsl;

import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlineComboBox;
import app.termora.OutlineTextField;
import app.termora.highlight.KeywordHighlight;
import app.termora.plugin.internal.AltKeyModifier;
import app.termora.plugin.internal.BasicTerminalOption;
import app.termora.plugin.internal.wsl.WSLDistribution;
import app.termora.plugin.internal.wsl.WSLHostOptionsPane;
import app.termora.plugin.internal.wsl.WSLSupport;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u0017\u001a\u00020\u00162\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lapp/termora/plugin/internal/wsl/WSLHostOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "generalOption", "Lapp/termora/plugin/internal/wsl/WSLHostOptionsPane$GeneralOption;", "getGeneralOption", "()Lapp/termora/plugin/internal/wsl/WSLHostOptionsPane$GeneralOption;", "terminalOption", "Lapp/termora/plugin/internal/BasicTerminalOption;", "getTerminalOption", "()Lapp/termora/plugin/internal/BasicTerminalOption;", "owner", "Ljava/awt/Window;", "getOwner", "()Ljava/awt/Window;", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "", "validateField", "textField", "Ljavax/swing/JTextField;", "comboBox", "Ljavax/swing/JComboBox;", "setOutlineError", "GeneralOption", "termora"})
@SourceDebugExtension(value={"SMAP\nWSLHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WSLHostOptionsPane.kt\napp/termora/plugin/internal/wsl/WSLHostOptionsPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
public class WSLHostOptionsPane
extends OptionsPane {
    @NotNull
    private final GeneralOption generalOption = new GeneralOption();
    @NotNull
    private final BasicTerminalOption terminalOption;

    /*
     * WARNING - void declaration
     */
    public WSLHostOptionsPane() {
        void $this$terminalOption_u24lambda_u240;
        BasicTerminalOption basicTerminalOption;
        BasicTerminalOption basicTerminalOption2 = basicTerminalOption = new BasicTerminalOption();
        WSLHostOptionsPane wSLHostOptionsPane = this;
        boolean bl = false;
        $this$terminalOption_u24lambda_u240.setShowCharsetComboBox(true);
        $this$terminalOption_u24lambda_u240.setShowStartupCommandTextField(true);
        $this$terminalOption_u24lambda_u240.setShowEnvironmentTextArea(true);
        $this$terminalOption_u24lambda_u240.init();
        wSLHostOptionsPane.terminalOption = basicTerminalOption;
        this.addOption(this.generalOption);
        this.addOption(this.terminalOption);
    }

    @NotNull
    protected final GeneralOption getGeneralOption() {
        return this.generalOption;
    }

    @NotNull
    protected final BasicTerminalOption getTerminalOption() {
        return this.terminalOption;
    }

    @NotNull
    protected final Window getOwner() {
        Window window = SwingUtilities.getWindowAncestor(this);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        return window;
    }

    @NotNull
    public Host getHost() {
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "WSL";
        Object object = this.generalOption.getHostComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.plugin.internal.wsl.WSLDistribution");
        WSLDistribution wsl = (WSLDistribution)object;
        String host = wsl.getDistributionName();
        Options options = Options.Companion.getDefault();
        Object object2 = this.terminalOption.getCharsetComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object2;
        String string2 = this.terminalOption.getEnvironmentTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = this.terminalOption.getStartupCommandTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        Object object3 = new Pair[4];
        object3[0] = TuplesKt.to((Object)"wsl-guid", (Object)wsl.getGuid());
        object3[1] = TuplesKt.to((Object)"wsl-flavor", (Object)wsl.getFlavor());
        Object object4 = this.terminalOption.getAltModifierComboBox().getSelectedItem();
        if (object4 == null || (object4 = object4.toString()) == null) {
            object4 = "EightBit";
        }
        object3[2] = TuplesKt.to((Object)"altModifier", (Object)object4);
        Object object5 = this.terminalOption.getHighlightSetComboBox().getSelectedItem();
        Object object6 = object5 instanceof KeywordHighlight ? (KeywordHighlight)object5 : null;
        if (object6 == null || (object6 = ((KeywordHighlight)object6).getId()) == null) {
            object6 = "-1";
        }
        object3[3] = TuplesKt.to((Object)"keywordHighlightSetId", (Object)object6);
        Options options2 = Options.copy$default(options, null, null, string, string2, string3, 0, null, null, false, null, null, MapsKt.mutableMapOf((Pair[])object3), 2019, null);
        Intrinsics.checkNotNull((Object)name);
        object3 = name;
        long l = System.currentTimeMillis();
        String string4 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String string5 = string4;
        return new Host(null, (String)object3, protocol, host, 0, null, string5, null, null, options2, null, l, null, null, null, null, false, 0L, 0L, 521649, null);
    }

    public final void setHost(@NotNull Host host) {
        Object object;
        String string;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getHostComboBox().setSelectedItem(host.getHost());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getHostComboBox().setSelectedItem(null);
        this.terminalOption.getStartupCommandTextField().setText(host.getOptions().getStartupCommand());
        this.terminalOption.getEnvironmentTextArea().setText(host.getOptions().getEnv());
        this.terminalOption.getCharsetComboBox().setSelectedItem(host.getOptions().getEncoding());
        int n = this.generalOption.getHostComboBox().getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)((WSLDistribution)this.generalOption.getHostComboBox().getItemAt(i)).getDistributionName(), (Object)host.getHost())) continue;
            this.generalOption.getHostComboBox().setSelectedIndex(i);
            break;
        }
        if ((string = host.getOptions().getExtras().get("altModifier")) == null) {
            string = "EightBit";
        }
        String altModifier = string;
        Object object2 = this;
        JComboBox<AltKeyModifier> jComboBox = this.terminalOption.getAltModifierComboBox();
        try {
            WSLHostOptionsPane $this$setHost_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((Object)AltKeyModifier.valueOf(altModifier)));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        AltKeyModifier altKeyModifier = (AltKeyModifier)((Object)(Result.isFailure-impl((Object)object2) ? null : object2));
        if (altKeyModifier == null) {
            altKeyModifier = AltKeyModifier.EightBit;
        }
        jComboBox.setSelectedItem((Object)altKeyModifier);
        String keywordHighlightSetId = host.getOptions().getExtras().get("keywordHighlightSetId");
        int n2 = this.terminalOption.getHighlightSetComboBox().getItemCount();
        for (int i = 0; i < n2; ++i) {
            KeywordHighlight item = this.terminalOption.getHighlightSetComboBox().getItemAt(i);
            if (!Intrinsics.areEqual((Object)item.getId(), (Object)keywordHighlightSetId)) continue;
            this.terminalOption.getHighlightSetComboBox().setSelectedItem(item);
            break;
        }
    }

    public final boolean validateFields() {
        return !this.validateField((JTextField)((Object)this.generalOption.getNameTextField())) && !this.validateField((JComboBox)((Object)this.generalOption.getHostComboBox()));
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final boolean validateField(JComboBox<?> comboBox2) {
        Object selectedItem = comboBox2.getSelectedItem();
        if (comboBox2.isEnabled() && (selectedItem == null || selectedItem instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)selectedItem)))) {
            this.selectOptionJComponent(comboBox2);
            comboBox2.putClientProperty("JComponent.outline", "error");
            comboBox2.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private final void setOutlineError(JTextField textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lapp/termora/plugin/internal/wsl/WSLHostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/wsl/WSLHostOptionsPane;)V", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "hostComboBox", "Lapp/termora/OutlineComboBox;", "Lapp/termora/plugin/internal/wsl/WSLDistribution;", "getHostComboBox", "()Lapp/termora/OutlineComboBox;", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nWSLHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WSLHostOptionsPane.kt\napp/termora/plugin/internal/wsl/WSLHostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n1#2:247\n*E\n"})
    protected final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineComboBox<WSLDistribution> hostComboBox;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;

        public GeneralOption() {
            super(new BorderLayout());
            this.nameTextField = new OutlineTextField(128);
            this.hostComboBox = new OutlineComboBox();
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineComboBox<WSLDistribution> getHostComboBox() {
            return this.hostComboBox;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        private final void initView() {
            this.hostComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object text = value instanceof WSLDistribution ? ((WSLDistribution)value).getDistributionName() : value;
                    Component c = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    this.setIcon(null);
                    if (value instanceof WSLDistribution) {
                        this.setIcon(StringUtils.containsIgnoreCase((CharSequence)((WSLDistribution)value).getFlavor(), (CharSequence)"debian") ? (Icon)((Object)Icons.INSTANCE.getDebian()) : (StringUtils.containsIgnoreCase((CharSequence)((WSLDistribution)value).getFlavor(), (CharSequence)"ubuntu") ? (Icon)((Object)Icons.INSTANCE.getUbuntu()) : (StringUtils.containsIgnoreCase((CharSequence)((WSLDistribution)value).getFlavor(), (CharSequence)"fedora") ? (Icon)((Object)Icons.INSTANCE.getFedora()) : (StringUtils.containsIgnoreCase((CharSequence)((WSLDistribution)value).getFlavor(), (CharSequence)"alma") ? (Icon)((Object)Icons.INSTANCE.getAlmalinux()) : (Icon)((Object)Icons.INSTANCE.getLinux())))));
                    }
                    return c;
                }
            });
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
            for (WSLDistribution distribution : WSLSupport.INSTANCE.getDistributions()) {
                this.hostComboBox.addItem(distribution);
            }
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.1.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getSettings());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u242;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = object = FormBuilder.create().layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.nameTextField)).xy(3, rows);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = object.add(I18n.INSTANCE.getString("termora.new-host.wsl.distribution") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.hostComboBox)).xy(3, rows);
            boolean bl2 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u241 = object = new JScrollPane((Component)((Object)this.remarkTextArea));
            FormBuilder formBuilder2 = formBuilder;
            boolean bl3 = false;
            $this$getCenterComponent_u24lambda_u242.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u243 = object = formBuilder2.add((Component)object).xy(3, rows);
            boolean bl4 = false;
            rows += step;
            JPanel panel2 = object.build();
            Intrinsics.checkNotNull((Object)panel2);
            return panel2;
        }
    }
}

