/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.updater;

import app.termora.AppLayout;
import app.termora.Application;
import app.termora.ApplicationKt;
import app.termora.DialogWrapper;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.TermoraRestarter;
import app.termora.UpdaterManager;
import app.termora.plugin.internal.updater.UpdaterDialog;
import com.formdev.flatlaf.util.SystemInfo;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.WinReg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal._UtilCommonKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.Util;
import org.jdesktop.swingx.JXEditorPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 22\u00020\u0001:\u0003234B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0014J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0014J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020!H\u0014J\u000e\u0010-\u001a\u00020!H\u0082@\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020!H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n \u0012*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lapp/termora/plugin/internal/updater/UpdaterDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "latestVersion", "Lapp/termora/UpdaterManager$LatestVersion;", "<init>", "(Ljava/awt/Window;Lapp/termora/UpdaterManager$LatestVersion;)V", "progressBar", "Ljavax/swing/JProgressBar;", "okAction", "Lapp/termora/DialogWrapper$OkAction;", "okButton", "Ljavax/swing/JButton;", "state", "Lapp/termora/plugin/internal/updater/UpdaterDialog$State;", "westSourcePanel", "Ljavax/swing/Box;", "kotlin.jvm.PlatformType", "glue", "Ljava/awt/Component;", "layout", "Lapp/termora/AppLayout;", "dialog", "getDialog", "()Lapp/termora/plugin/internal/updater/UpdaterDialog;", "executorService", "Ljava/util/concurrent/ExecutorService;", "coroutineDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initView", "", "initEvents", "createCenterPanel", "Ljavax/swing/JComponent;", "createWestSourcePanel", "createActions", "", "Ljavax/swing/AbstractAction;", "createJButtonForAction", "action", "Ljavax/swing/Action;", "doOKAction", "downloadPkg", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isAppInstalled", "", "addNotify", "Companion", "State", "LatestReleaseException", "termora"})
@SourceDebugExtension(value={"SMAP\nUpdaterDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdaterDialog.kt\napp/termora/plugin/internal/updater/UpdaterDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,317:1\n1#2:318\n*E\n"})
public final class UpdaterDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpdaterManager.LatestVersion latestVersion;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final DialogWrapper.OkAction okAction;
    @NotNull
    private final JButton okButton;
    @NotNull
    private State state;
    private final Box westSourcePanel;
    private final Component glue;
    @NotNull
    private final AppLayout layout;
    private final ExecutorService executorService;
    @NotNull
    private final ExecutorCoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final CoroutineScope coroutineScope;
    private static final Logger log = LoggerFactory.getLogger(UpdaterDialog.class);

    public UpdaterDialog(@NotNull Window owner, @NotNull UpdaterManager.LatestVersion latestVersion) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)latestVersion, (String)"latestVersion");
        super(owner);
        this.latestVersion = latestVersion;
        this.progressBar = new JProgressBar();
        this.okAction = new DialogWrapper.OkAction(this, I18n.INSTANCE.getString("termora.update.update"));
        this.okButton = new JButton((Action)((Object)this.okAction));
        this.state = State.Ready;
        this.westSourcePanel = Box.createHorizontalBox();
        this.glue = Box.createHorizontalGlue();
        this.layout = Application.INSTANCE.getLayout();
        ExecutorService executorService = this.executorService = Executors.newVirtualThreadPerTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"executorService");
        this.coroutineDispatcher = ExecutorsKt.from((ExecutorService)executorService);
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.coroutineDispatcher));
        this.setSize(new Dimension(UIManager.getInt("Dialog.width"), UIManager.getInt("Dialog.height")));
        this.setModal(true);
        this.setControlsVisible(false);
        this.setResizable(false);
        this.setEscapeDispose(false);
        this.setTitle(I18n.INSTANCE.getString("termora.update.title"));
        this.setLocationRelativeTo(owner);
        this.init();
        this.initView();
        this.initEvents();
    }

    private final UpdaterDialog getDialog() {
        return this;
    }

    private final void initView() {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.westSourcePanel.add(this.glue);
        this.westSourcePanel.add(this.progressBar);
        this.westSourcePanel.add(Box.createHorizontalStrut(20));
        this.progressBar.setVisible(false);
    }

    private final void initEvents() {
        Disposer.register(this.getDisposable(), new Disposable(this){
            final /* synthetic */ UpdaterDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                CoroutineScopeKt.cancel$default((CoroutineScope)UpdaterDialog.access$getCoroutineScope$p(this.this$0), null, (int)1, null);
                UpdaterDialog.access$getCoroutineDispatcher$p(this.this$0).close();
                UpdaterDialog.access$getExecutorService$p(this.this$0).shutdownNow();
            }
        });
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JXEditorPane editorPane = new JXEditorPane();
        editorPane.setContentType("text/html");
        editorPane.setText(this.latestVersion.getHtmlBody());
        editorPane.setEditable(false);
        editorPane.addHyperlinkListener(UpdaterDialog::createCenterPanel$lambda$0);
        editorPane.setBackground((Color)new DynamicColor("window"));
        JScrollPane scrollPane = new JScrollPane((Component)editorPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        return scrollPane;
    }

    @Override
    @NotNull
    protected JComponent createWestSourcePanel() {
        Box box = this.westSourcePanel;
        Intrinsics.checkNotNullExpressionValue((Object)box, (String)"westSourcePanel");
        return box;
    }

    @Override
    @NotNull
    protected List<AbstractAction> createActions() {
        Object[] objectArray = new AbstractAction[]{this.okAction, this.createCancelAction()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    protected JButton createJButtonForAction(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        if (Intrinsics.areEqual((Object)action2, (Object)((Object)this.okAction))) {
            this.rootPane.setDefaultButton(this.okButton);
            return this.okButton;
        }
        return super.createJButtonForAction(action2);
    }

    @Override
    protected void doOKAction() {
        if (this.state == State.Ready) {
            this.okButton.setText(this.okButton.getText() + "...");
            this.okButton.setEnabled(false);
            this.progressBar.setVisible(true);
            this.glue.setVisible(false);
            this.state = State.Downloading;
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                int label;
                final /* synthetic */ UpdaterDialog this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final Object invokeSuspend(Object $result) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = UpdaterDialog.access$downloadPkg(this.this$0, (Continuation)this);
                            ** if (v0 != var3_2) goto lbl11
lbl10:
                            // 1 sources

                            return var3_2;
lbl11:
                            // 1 sources

                            ** GOTO lbl17
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ UpdaterDialog this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            UpdaterDialog.access$getProgressBar$p(this.this$0).setVisible(false);
                                            UpdaterDialog.access$getGlue$p(this.this$0).setVisible(true);
                                            UpdaterDialog.access$getOkButton$p(this.this$0).setEnabled(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            v2 = v1;
                            if (v1 != var3_2) return Unit.INSTANCE;
                            return var3_2;
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (LatestReleaseException <unused var>) {
                            v3 = URI.create("https://github.com/TermoraDev/termora/releases/latest");
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"create(...)");
                            Application.browse$default(Application.INSTANCE, v3, false, 2, null);
                            SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, invokeSuspend$lambda$0(app.termora.plugin.internal.updater.UpdaterDialog ), ()V)((UpdaterDialog)this.this$0));
                            this.label = 3;
                            {
                                catch (Throwable var2_6) {
                                    this.L$0 = var2_6;
                                    this.label = 6;
                                    v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                                    v5 = v4;
                                    if (v4 != var3_2) throw var2_7;
                                    return var3_2;
                                }
                            }
                            v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                            v7 = v6;
                            if (v6 != var3_2) return Unit.INSTANCE;
                            return var3_2;
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                if (UpdaterDialog.access$getLog$cp().isErrorEnabled()) {
                                    UpdaterDialog.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                                this.label = 4;
                                v8 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, e, null){
                                    int label;
                                    final /* synthetic */ UpdaterDialog this$0;
                                    final /* synthetic */ Exception $e;
                                    {
                                        this.this$0 = $receiver;
                                        this.$e = $e;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                UpdaterDialog.access$setState$p(this.this$0, State.Ready);
                                                UpdaterDialog.access$getOkButton$p(this.this$0).setEnabled(true);
                                                UpdaterDialog.access$getOkButton$p(this.this$0).setText(UpdaterDialog.access$getOkAction$p(this.this$0).getName());
                                                UpdaterDialog.access$getProgressBar$p(this.this$0).setVisible(false);
                                                UpdaterDialog.access$getGlue$p(this.this$0).setVisible(true);
                                                OptionPane.showMessageDialog$default(OptionPane.INSTANCE, UpdaterDialog.access$getDialog(this.this$0), String.valueOf(StringUtils.defaultIfBlank((CharSequence)this.$e.getMessage(), (CharSequence)ExceptionUtils.getRootCauseMessage((Throwable)this.$e))), null, 0, null, 20, null);
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                ** if (v8 != var3_2) goto lbl57
lbl56:
                                // 1 sources

                                return var3_2;
lbl57:
                                // 1 sources

                                ** GOTO lbl64
                                case 4: {
                                    e = (Exception)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v8 = $result;
lbl64:
                                    // 2 sources

                                    this.L$0 = null;
                                    this.label = 5;
                                    v9 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                                    v10 = v9;
                                    if (v9 != var3_2) return Unit.INSTANCE;
                                    return var3_2;
                                }
                                case 5: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v10 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                        }
                        case 6: {
                            var2_7 = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
                            throw var2_7;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final void invokeSuspend$lambda$0(UpdaterDialog this$0) {
                    UpdaterDialog.access$doCancelAction(this$0);
                }
            }), (int)3, null);
            return;
        }
        if (this.state == State.Downloading) {
            return;
        }
        if (this.state == State.Downloaded) {
            super.doOKAction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object downloadPkg(Continuation<? super Unit> $completion) {
        if (!($completion instanceof downloadPkg.1)) ** GOTO lbl-1000
        var27_2 = $completion;
        if ((var27_2.label & -2147483648) != 0) {
            var27_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                /* synthetic */ Object result;
                final /* synthetic */ UpdaterDialog this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return UpdaterDialog.access$downloadPkg(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var28_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = arch = SystemInfo.isAARCH64 != false ? "aarch64" : "x86-64";
                osName = SystemInfo.isWindows != false ? "windows" : (SystemInfo.isLinux != false ? "linux" : "osx");
                switch (WhenMappings.$EnumSwitchMapping$0[this.layout.ordinal()]) {
                    case 1: {
                        v1 = "zip";
                        break;
                    }
                    case 2: {
                        v1 = "exe";
                        break;
                    }
                    case 3: {
                        v1 = "dmg";
                        break;
                    }
                    case 4: {
                        v1 = "tar.gz";
                        break;
                    }
                    case 5: {
                        v1 = "AppImage";
                        break;
                    }
                    case 6: {
                        v1 = "deb";
                        break;
                    }
                    default: {
                        throw new LatestReleaseException();
                    }
                }
                suffix = v1;
                filename = "termora-" + this.latestVersion.getVersion() + "-" + osName + "-" + arch + "." + suffix;
                var9_13 = this.latestVersion.getAssets();
                for (T var11_16 : var9_13) {
                    it = (UpdaterManager.Asset)var11_16 /* !! */ ;
                    $i$a$-find-UpdaterDialog$downloadPkg$asset$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)filename)) continue;
                    v2 = var11_16 /* !! */ ;
                    ** GOTO lbl45
                }
                v2 = null;
lbl45:
                // 2 sources

                v3 = v2;
                if (v3 == null) {
                    throw new LatestReleaseException();
                }
                asset = v3;
                url = asset.getDownloadUrl();
                if (I18n.INSTANCE.isChinaMainland()) {
                    v4 = Strings.CI.replace(url, "https://github.com/TermoraDev/termora/releases/download/", "https://dl.termora.cn/termora/");
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"replace(...)");
                    url = v4;
                }
                if (!(response = Application.INSTANCE.getHttpClient().newCall(new Request.Builder().url(url).get().build()).execute()).isSuccessful()) {
                    _UtilCommonKt.closeQuietly((Closeable)((Closeable)response));
                    throw new IllegalStateException("Failed to download asset " + (String)filename);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)arch);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)osName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)suffix);
                $continuation.L$3 = filename;
                $continuation.L$4 = asset;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$6 = response;
                $continuation.label = 1;
                v5 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ UpdaterDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                UpdaterDialog.access$getProgressBar$p(this.this$0).setIndeterminate(false);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v5 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl79
            }
            case 1: {
                response = (Response)$continuation.L$6;
                url = (String)$continuation.L$5;
                asset = (UpdaterManager.Asset)$continuation.L$4;
                filename = (String)$continuation.L$3;
                suffix = (String)$continuation.L$2;
                osName = (String)$continuation.L$1;
                arch = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl79:
                // 2 sources

                listener = new CopyStreamListener(asset, this){
                    final /* synthetic */ UpdaterManager.Asset $asset;
                    final /* synthetic */ UpdaterDialog this$0;
                    {
                        this.$asset = $asset;
                        this.this$0 = $receiver;
                    }

                    public void bytesTransferred(CopyStreamEvent event) {
                        String string = "Not yet implemented";
                        throw new NotImplementedError("An operation is not implemented: " + string);
                    }

                    public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                        SwingUtilities.invokeLater(() -> downloadPkg.listener.1.bytesTransferred$lambda$0(totalBytesTransferred, this.$asset, this.this$0));
                    }

                    private static final void bytesTransferred$lambda$0(long $totalBytesTransferred, UpdaterManager.Asset $asset, UpdaterDialog this$0) {
                        double progress = 1.0 * (double)$totalBytesTransferred / (double)$asset.getSize() * (double)100;
                        UpdaterDialog.access$getProgressBar$p(this$0).setValue((int)Math.floor(progress));
                        UpdaterDialog.access$getProgressBar$p(this$0).setString(ApplicationKt.formatBytes($totalBytesTransferred) + " / " + ApplicationKt.formatBytes($asset.getSize()));
                    }
                };
                var11_16 /* !! */  = new String[]{UUID.randomUUID() + "-" + (String)filename};
                file = FileUtils.getFile((File)Application.INSTANCE.getTemporaryDir(), var11_16 /* !! */ );
                var11_16 /* !! */  = (Closeable)response;
                var12_17 = null;
                try {
                    it = (Response)var11_16 /* !! */ ;
                    $i$a$-use-UpdaterDialog$downloadPkg$3 = false;
                    var16_30 = response.body().byteStream();
                    var17_31 = null;
                    try {
                        input = (InputStream)var16_30;
                        $i$a$-use-UpdaterDialog$downloadPkg$3$1 = false;
                        Intrinsics.checkNotNull((Object)file);
                        var21_37 = new FileOutputStream(file);
                        var22_38 = null;
                        try {
                            output = (FileOutputStream)var21_37;
                            $i$a$-use-UpdaterDialog$downloadPkg$3$1$1 = false;
                            var23_40 = Util.copyStream((InputStream)input, (OutputStream)output, (int)1024, (long)asset.getSize(), (CopyStreamListener)listener);
                        }
                        catch (Throwable var25_42) {
                            var22_38 = var25_42;
                            throw var25_42;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var21_37, (Throwable)var22_38);
                        }
                        var18_33 = var23_40;
                    }
                    catch (Throwable var20_35) {
                        var17_31 = var20_35;
                        throw var20_35;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)var16_30, (Throwable)var17_31);
                    }
                    var13_20 = var18_33;
                }
                catch (Throwable var15_28) {
                    var12_17 = var15_28;
                    throw var15_28;
                }
                finally {
                    CloseableKt.closeFinally(var11_16 /* !! */ , (Throwable)var12_17);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)arch);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)osName);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)suffix);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)filename);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)asset);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)url);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)response);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)listener);
                $continuation.L$8 = file;
                $continuation.label = 2;
                v6 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ UpdaterDialog this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                UpdaterDialog.access$setState$p(this.this$0, State.Downloaded);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v6 == var28_4) {
                    return var28_4;
                }
                ** GOTO lbl152
            }
            case 2: {
                file = (File)$continuation.L$8;
                listener = $continuation.L$7;
                response = (Response)$continuation.L$6;
                url = (String)$continuation.L$5;
                asset = (UpdaterManager.Asset)$continuation.L$4;
                filename = (String)$continuation.L$3;
                suffix = (String)$continuation.L$2;
                osName = (String)$continuation.L$1;
                arch = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl152:
                // 2 sources

                commands = new ArrayList<E>();
                if (SystemInfo.isMacOS) {
                    var12_17 = new String[]{"open", "-n", file.getAbsolutePath()};
                    commands.addAll(CollectionsKt.listOf((Object[])var12_17));
                } else if (this.layout == AppLayout.Zip) {
                    var12_17 = new String[]{"explorer", "/select," + file.getAbsolutePath()};
                    commands.addAll(CollectionsKt.listOf((Object[])var12_17));
                } else if (this.layout == AppLayout.Exe) {
                    if (this.isAppInstalled()) {
                        var12_17 = new String[]{file.getAbsolutePath(), "/SILENT", "/AUTOSTART", "/NORESTART", "/FORCECLOSEAPPLICATIONS"};
                        v7 = commands.addAll(CollectionsKt.listOf((Object[])var12_17));
                    } else {
                        v7 = commands.addAll(CollectionsKt.listOf((Object)file.getAbsolutePath()));
                    }
                } else if (SystemInfo.isLinux) {
                    var12_17 = new String[]{"xdg-open", file.getParentFile().getAbsolutePath()};
                    commands.addAll(CollectionsKt.listOf((Object[])var12_17));
                }
                if (UpdaterDialog.log.isInfoEnabled()) {
                    UpdaterDialog.log.info("commands: {}", (Object)CollectionsKt.joinToString$default((Iterable)commands, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                }
                SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, downloadPkg$lambda$2(app.termora.plugin.internal.updater.UpdaterDialog java.util.List ), ()V)((UpdaterDialog)this, (List)commands));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isAppInstalled() {
        try {
            String keyPath = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\" + Application.INSTANCE.getName() + "_is1";
            WinReg.HKEYByReference phkKey = new WinReg.HKEYByReference();
            int result2 = Advapi32.INSTANCE.RegOpenKeyEx(WinReg.HKEY_LOCAL_MACHINE, keyPath, 0, 131097, phkKey);
            if (result2 == 0) {
                Advapi32.INSTANCE.RegCloseKey(phkKey.getValue());
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private static final void createCenterPanel$lambda$0(HyperlinkEvent it) {
        if (Intrinsics.areEqual((Object)it.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            URI uRI = it.getURL().toURI();
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toURI(...)");
            Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
        }
    }

    private static final void downloadPkg$lambda$2(UpdaterDialog this$0, List $commands) {
        super.doOKAction();
        TermoraRestarter.Companion.getInstance().scheduleRestart(this$0.getOwner(), true, $commands);
    }

    public static final /* synthetic */ CoroutineScope access$getCoroutineScope$p(UpdaterDialog $this) {
        return $this.coroutineScope;
    }

    public static final /* synthetic */ ExecutorCoroutineDispatcher access$getCoroutineDispatcher$p(UpdaterDialog $this) {
        return $this.coroutineDispatcher;
    }

    public static final /* synthetic */ ExecutorService access$getExecutorService$p(UpdaterDialog $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ Object access$downloadPkg(UpdaterDialog $this, Continuation $completion) {
        return $this.downloadPkg((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    public static final /* synthetic */ void access$setState$p(UpdaterDialog $this, State state) {
        $this.state = state;
    }

    public static final /* synthetic */ JButton access$getOkButton$p(UpdaterDialog $this) {
        return $this.okButton;
    }

    public static final /* synthetic */ DialogWrapper.OkAction access$getOkAction$p(UpdaterDialog $this) {
        return $this.okAction;
    }

    public static final /* synthetic */ JProgressBar access$getProgressBar$p(UpdaterDialog $this) {
        return $this.progressBar;
    }

    public static final /* synthetic */ Component access$getGlue$p(UpdaterDialog $this) {
        return $this.glue;
    }

    public static final /* synthetic */ UpdaterDialog access$getDialog(UpdaterDialog $this) {
        return $this.getDialog();
    }

    public static final /* synthetic */ void access$doCancelAction(UpdaterDialog $this) {
        $this.doCancelAction();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/plugin/internal/updater/UpdaterDialog$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lapp/termora/plugin/internal/updater/UpdaterDialog$LatestReleaseException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "<init>", "()V", "termora"})
    private static final class LatestReleaseException
    extends RuntimeException {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lapp/termora/plugin/internal/updater/UpdaterDialog$State;", "", "<init>", "(Ljava/lang/String;I)V", "Ready", "Downloading", "Downloaded", "termora"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Ready = new State();
        public static final /* enum */ State Downloading = new State();
        public static final /* enum */ State Downloaded = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Ready, State.Downloading, State.Downloaded};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppLayout.values().length];
            try {
                nArray[AppLayout.Zip.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppLayout.Exe.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppLayout.App.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppLayout.TarGz.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppLayout.AppImage.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppLayout.Deb.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

