/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.telnet;

import app.termora.terminal.StreamPtyConnector;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.WindowSizeOptionHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0002\b\t\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lapp/termora/plugin/internal/telnet/TelnetStreamPtyConnector;", "Lapp/termora/terminal/StreamPtyConnector;", "telnet", "Lorg/apache/commons/net/telnet/TelnetClient;", "charset", "Ljava/nio/charset/Charset;", "characterMode", "", "<init>", "(Lorg/apache/commons/net/telnet/TelnetClient;Ljava/nio/charset/Charset;Z)V", "reader", "Ljava/io/InputStreamReader;", "read", "", "buffer", "", "write", "", "", "offset", "len", "resize", "rows", "cols", "waitFor", "close", "getCharset", "termora"})
public final class TelnetStreamPtyConnector
extends StreamPtyConnector {
    @NotNull
    private final TelnetClient telnet;
    @NotNull
    private final Charset charset;
    private final boolean characterMode;
    @NotNull
    private final InputStreamReader reader;

    public TelnetStreamPtyConnector(@NotNull TelnetClient telnet, @NotNull Charset charset, boolean characterMode) {
        Intrinsics.checkNotNullParameter((Object)telnet, (String)"telnet");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        InputStream inputStream = telnet.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        OutputStream outputStream = telnet.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        super(inputStream, outputStream);
        this.telnet = telnet;
        this.charset = charset;
        this.characterMode = characterMode;
        this.reader = new InputStreamReader(this.telnet.getInputStream(), this.charset);
    }

    @Override
    public int read(@NotNull char[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.reader.read(buffer);
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.characterMode) {
            int n = len + offset;
            for (int i = offset; i < n; ++i) {
                byte[] byArray = new byte[]{buffer[i]};
                this.getOutput().write(byArray);
                this.getOutput().flush();
            }
        } else {
            this.getOutput().write(buffer, offset, len);
            this.getOutput().flush();
        }
    }

    @Override
    public void resize(int rows, int cols) {
        this.telnet.deleteOptionHandler(31);
        this.telnet.addOptionHandler((TelnetOptionHandler)new WindowSizeOptionHandler(cols, rows, true, false, true, false));
    }

    @Override
    public int waitFor() {
        return -1;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((InputStream)this.getInput());
        IOUtils.closeQuietly((OutputStream)this.getOutput());
        this.telnet.disconnect();
    }

    @Override
    @NotNull
    public Charset getCharset() {
        return this.charset;
    }
}

