/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.plugin;

import app.termora.Application;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.EnableManager;
import app.termora.FileChooser;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.OptionsPane;
import app.termora.SwingUtils;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.plugin.Extension;
import app.termora.plugin.PluginDescriptor;
import app.termora.plugin.PluginManager;
import app.termora.plugin.PluginOrigin;
import app.termora.plugin.PluginXmlParser;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import app.termora.plugin.internal.plugin.InstalledPanel;
import app.termora.plugin.internal.plugin.MarketplacePanel;
import app.termora.plugin.internal.plugin.PluginPanel;
import app.termora.plugin.internal.plugin.PluginPluginDescriptor;
import app.termora.plugin.internal.plugin.PluginRepositoryDialog;
import app.termora.plugin.marketplace.MarketplaceManager;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001<B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001eH\u0016J\b\u0010)\u001a\u00020\u001eH\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0016J\b\u00109\u001a\u00020%H\u0016J\b\u0010:\u001a\u00020;H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006="}, d2={"Lapp/termora/plugin/internal/plugin/PluginOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "Lapp/termora/Disposable;", "Lapp/termora/account/AccountExtension;", "<init>", "()V", "installButtons", "", "Ljavax/swing/JButton;", "tabbed", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "toolbar", "Lcom/formdev/flatlaf/extras/components/FlatToolBar;", "settingsButton", "refreshButton", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "marketplacePanel", "Lapp/termora/plugin/internal/plugin/MarketplacePanel;", "installedPanel", "Lapp/termora/plugin/internal/plugin/InstalledPanel;", "marketplaceManager", "Lapp/termora/plugin/marketplace/MarketplaceManager;", "getMarketplaceManager", "()Lapp/termora/plugin/marketplace/MarketplaceManager;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "dispose", "showContextMenu", "installPluginFromDisk", "file", "Ljava/io/File;", "installPlugin", "folder", "pluginDescriptor", "Lapp/termora/plugin/PluginDescriptor;", "parseJarFile", "Lapp/termora/plugin/PluginXmlParser$MyPluginDescriptor;", "jarFile", "Ljava/util/jar/JarFile;", "onAccountChanged", "oldAccount", "Lapp/termora/account/Account;", "newAccount", "getIdentifier", "getAnchor", "Lapp/termora/OptionsPane$Anchor;", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nPluginOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginOption.kt\napp/termora/plugin/internal/plugin/PluginOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n1#2:254\n*E\n"})
public final class PluginOption
extends JPanel
implements OptionsPane.Option,
Disposable,
AccountExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JButton> installButtons = new ArrayList();
    @NotNull
    private final FlatTabbedPane tabbed = new FlatTabbedPane();
    @NotNull
    private final FlatToolBar toolbar = new FlatToolBar();
    @NotNull
    private final JButton settingsButton = new JButton((Icon)((Object)Icons.INSTANCE.getSettings()));
    @NotNull
    private final JButton refreshButton = new JButton((Icon)((Object)Icons.INSTANCE.getRefresh()));
    @NotNull
    private final MarketplacePanel marketplacePanel = new MarketplacePanel();
    @NotNull
    private final InstalledPanel installedPanel = new InstalledPanel();
    @NotNull
    private static final List<PluginPluginDescriptor> installedFromDisk = new ArrayList();

    public PluginOption() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final MarketplaceManager getMarketplaceManager() {
        return MarketplaceManager.Companion.getInstance();
    }

    private final void initView() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"hoverColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"inactiveUnderlineColor", (Object)new DynamicColor("TabbedPane.underlineColor"))};
        this.tabbed.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        this.tabbed.setHasFullBorder(false);
        this.tabbed.setTabPlacement(1);
        Disposer.register(this, this.marketplacePanel);
        Disposer.register(this, this.installedPanel);
        this.tabbed.addTab(I18n.INSTANCE.getString("termora.settings.plugin.marketplace"), (Component)this.marketplacePanel);
        this.tabbed.addTab(I18n.INSTANCE.getString("termora.settings.plugin.installed"), (Component)this.installedPanel);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add((Component)this.refreshButton);
        this.toolbar.add((Component)this.settingsButton);
        this.tabbed.setTrailingComponent((Component)this.toolbar);
        this.tabbed.setSelectedIndex(EnableManager.Companion.getInstance().getFlag("PluginOption.defaultTab", 0));
        this.refreshButton.setVisible(this.tabbed.getSelectedIndex() == 0);
        this.add((Component)this.tabbed, "Center");
        this.putClientProperty("ContentPanelBorder", BorderFactory.createEmptyBorder());
    }

    private final void initEvents() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)this);
        boolean bl = false;
        Disposer.register(this, it);
        this.settingsButton.addActionListener(arg_0 -> PluginOption.initEvents$lambda$1(this, arg_0));
        this.refreshButton.addActionListener(arg_0 -> PluginOption.initEvents$lambda$2(this, arg_0));
        this.tabbed.addChangeListener(arg_0 -> PluginOption.initEvents$lambda$3(this, arg_0));
    }

    @Override
    @NotNull
    public Icon getIcon(boolean isSelected) {
        return (Icon)((Object)Icons.INSTANCE.getPlugin());
    }

    @Override
    @NotNull
    public String getTitle() {
        return I18n.INSTANCE.getString("termora.settings.plugin");
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void dispose() {
        DynamicExtensionHandler.Companion.getInstance().unregister((Extension)this);
        EnableManager.Companion.getInstance().setFlag("PluginOption.defaultTab", this.tabbed.getSelectedIndex());
    }

    private final void showContextMenu() {
        FlatPopupMenu popupMenu = new FlatPopupMenu();
        JMenuItem managePluginRepositoryMenu = popupMenu.add(I18n.INSTANCE.getString("termora.settings.plugin.manage-plugin-repository"));
        managePluginRepositoryMenu.addActionListener(arg_0 -> PluginOption.showContextMenu$lambda$0(this, arg_0));
        popupMenu.addSeparator();
        JMenuItem installPluginFromDiskMenu = popupMenu.add(I18n.INSTANCE.getString("termora.settings.plugin.install-from-disk"));
        installPluginFromDiskMenu.addActionListener(arg_0 -> PluginOption.showContextMenu$lambda$1(this, arg_0));
        popupMenu.show((Component)this.settingsButton, 0, this.settingsButton.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void installPluginFromDisk(File file) {
        Object object;
        Object object2;
        File dir = Application.INSTANCE.createSubTemporaryDir("plugin").toFile();
        Closeable closeable = new FileInputStream(file);
        String[] stringArray = null;
        try {
            FileInputStream input2 = (FileInputStream)closeable;
            boolean bl = false;
            object2 = new ZipInputStream(input2);
            object = null;
            try {
                ZipInputStream zis = (ZipInputStream)object2;
                boolean bl2 = false;
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        File entryFile = new File(dir, entry.getName());
                        FileUtils.forceMkdirParent((File)entryFile);
                        Closeable closeable2 = new FileOutputStream(entryFile);
                        Throwable throwable = null;
                        try {
                            FileOutputStream os = (FileOutputStream)closeable2;
                            boolean bl3 = false;
                            int n = IOUtils.copy((InputStream)zis, (OutputStream)os);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                        }
                    }
                    entry = zis.getNextEntry();
                }
                zis = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
            input2 = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            stringArray = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)stringArray);
        }
        stringArray = new String[]{"jar"};
        for (File item : FileUtils.listFiles((File)dir, (String[])stringArray, (boolean)true)) {
            try {
                Closeable bl = new JarFile(item);
                object2 = null;
                try {
                    JarFile it = (JarFile)bl;
                    boolean bl4 = false;
                    object = this.parseJarFile(it);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)bl, (Throwable)object2);
                }
                Object pluginDescriptor = object;
                SwingUtilities.invokeLater(() -> PluginOption.installPluginFromDisk$lambda$2(this, item, (PluginXmlParser.MyPluginDescriptor)pluginDescriptor));
                return;
            }
            catch (Exception exception) {
            }
        }
        SwingUtilities.invokeLater(() -> PluginOption.installPluginFromDisk$lambda$3(this));
    }

    private final void installPlugin(File folder, PluginDescriptor pluginDescriptor) {
        Object[] objectArray = new Object[]{pluginDescriptor.getPlugin().getName()};
        String string = I18n.INSTANCE.getString("termora.settings.plugin.install-from-disk-warning", objectArray);
        objectArray = new Object[]{I18n.INSTANCE.getString("termora.settings.plugin.install"), I18n.INSTANCE.getString("termora.cancel")};
        if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, this.getOwner(), string, null, 2, 2, null, objectArray, I18n.INSTANCE.getString("termora.settings.plugin.install"), null, 292, null) != 0) {
            return;
        }
        Object[] objectArray2 = new String[]{pluginDescriptor.getId()};
        File pluginDirectory = FileUtils.getFile((File)PluginManager.Companion.getInstance().getPluginDirectory(), (String[])objectArray2);
        if (pluginDirectory.exists() && pluginDirectory.isDirectory() && (pluginDirectory = FileUtils.getFile((File)pluginDirectory, (String[])(objectArray2 = new String[]{"updated"}))).exists()) {
            FileUtils.deleteQuietly((File)pluginDirectory);
        }
        FileUtils.forceMkdir((File)pluginDirectory);
        File[] fileArray = folder.listFiles(PluginOption::installPlugin$lambda$0);
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File file : fileArray) {
            FileUtils.moveFileToDirectory((File)file, (File)pluginDirectory, (boolean)false);
        }
        PluginPluginDescriptor descriptor = new PluginPluginDescriptor(pluginDescriptor.getPlugin(), pluginDescriptor.getId(), pluginDescriptor.getIcon(), PluginOrigin.Memory, pluginDescriptor.getVersion(), pluginDescriptor.getDescriptions(), null, false, null, null, 832, null);
        installedFromDisk.add(descriptor);
        for (PluginPanel c : SwingUtils.getDescendantsOfClass(PluginPanel.class, this.installedPanel)) {
            if (!Intrinsics.areEqual((Object)c.getDescriptor().getId(), (Object)pluginDescriptor.getId())) continue;
            c.refreshButtons();
        }
    }

    private final PluginXmlParser.MyPluginDescriptor parseJarFile(JarFile jarFile) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream2;
        ZipEntry zipEntry = jarFile.getEntry("META-INF/plugin.xml");
        if (zipEntry == null) {
            throw new IllegalStateException("META-INF/plugin.xml not found");
        }
        ZipEntry plugin = zipEntry;
        ZipEntry icon = jarFile.getEntry("META-INF/pluginIcon.svg");
        ZipEntry darkIcon = jarFile.getEntry("META-INF/pluginIcon_dark.svg");
        byte[] byArray = jarFile.getInputStream(plugin).readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
        byte[] byArray2 = byArray;
        ByteArrayInputStream pluginInputSteam = new ByteArrayInputStream(byArray2);
        ZipEntry zipEntry2 = icon;
        if (zipEntry2 != null) {
            ZipEntry it = zipEntry2;
            boolean bl = false;
            byte[] byArray3 = jarFile.getInputStream(it).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"readAllBytes(...)");
            byte[] byArray4 = byArray3;
            byteArrayInputStream2 = new ByteArrayInputStream(byArray4);
        } else {
            byteArrayInputStream2 = null;
        }
        ByteArrayInputStream iconStream = byteArrayInputStream2;
        ZipEntry zipEntry3 = darkIcon;
        if (zipEntry3 != null) {
            ZipEntry it = zipEntry3;
            boolean bl = false;
            byte[] byArray5 = jarFile.getInputStream(it).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"readAllBytes(...)");
            byte[] byArray6 = byArray5;
            byteArrayInputStream = new ByteArrayInputStream(byArray6);
        } else {
            byteArrayInputStream = null;
        }
        ByteArrayInputStream darkIconStream = byteArrayInputStream;
        return PluginXmlParser.INSTANCE.parse(pluginInputSteam, iconStream, darkIconStream);
    }

    @Override
    public void onAccountChanged(@NotNull Account oldAccount, @NotNull Account newAccount) {
        Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
        Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
        boolean isFreePlan = AccountManager.Companion.getInstance().isFreePlan();
        for (JButton button : this.installButtons) {
            button.setIcon(isFreePlan ? (Icon)((Object)Icons.INSTANCE.getLocked()) : null);
        }
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "Plugin";
    }

    @Override
    @NotNull
    public OptionsPane.Anchor getAnchor() {
        return new OptionsPane.Anchor.Before("About");
    }

    private static final void initEvents$lambda$1(PluginOption this$0, ActionEvent it) {
        this$0.showContextMenu();
    }

    private static final void initEvents$lambda$2(PluginOption this$0, ActionEvent it) {
        if (!this$0.marketplacePanel.isLoading().get()) {
            this$0.getMarketplaceManager().clear();
            this$0.marketplacePanel.reload();
        }
    }

    private static final void initEvents$lambda$3(PluginOption this$0, ChangeEvent it) {
        this$0.refreshButton.setVisible(this$0.tabbed.getSelectedIndex() == 0);
    }

    private static final void showContextMenu$lambda$0(PluginOption this$0, ActionEvent it) {
        Window window = this$0.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"<get-owner>(...)");
        PluginRepositoryDialog dialog2 = new PluginRepositoryDialog(window);
        dialog2.setVisible(true);
        if (dialog2.getChanged()) {
            MarketplaceManager.Companion.getInstance().clear();
            this$0.marketplacePanel.reload();
        }
    }

    private static final void showContextMenu$lambda$1(PluginOption this$0, ActionEvent it) {
        FileChooser chooser = new FileChooser();
        chooser.setOsxAllowedFileTypes(CollectionsKt.listOf((Object)"zip"));
        chooser.setAllowsMultiSelection(false);
        chooser.getWin32Filters().add((Pair<String, List<String>>)new Pair((Object)"Zip files", (Object)CollectionsKt.listOf((Object)"zip")));
        chooser.setFileSelectionMode(0);
        chooser.showOpenDialog(this$0.getOwner()).thenAccept(arg_0 -> PluginOption.showContextMenu$lambda$1$1(arg_0 -> PluginOption.showContextMenu$lambda$1$0(this$0, arg_0), arg_0));
    }

    private static final Unit showContextMenu$lambda$1$0(PluginOption this$0, List it) {
        Intrinsics.checkNotNull((Object)it);
        if (!((Collection)it).isEmpty()) {
            this$0.installPluginFromDisk((File)CollectionsKt.first((List)it));
        }
        return Unit.INSTANCE;
    }

    private static final void showContextMenu$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void installPluginFromDisk$lambda$2(PluginOption this$0, File $item, PluginXmlParser.MyPluginDescriptor $pluginDescriptor) {
        File file = $item.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        this$0.installPlugin(file, $pluginDescriptor);
    }

    private static final void installPluginFromDisk$lambda$3(PluginOption this$0) {
        OptionPane.showMessageDialog$default(OptionPane.INSTANCE, this$0.getOwner(), I18n.INSTANCE.getString("termora.settings.plugin.install-failed"), null, 0, null, 20, null);
    }

    private static final boolean installPlugin$lambda$0(File it) {
        return it.isFile();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lapp/termora/plugin/internal/plugin/PluginOption$Companion;", "", "<init>", "()V", "installedFromDisk", "", "Lapp/termora/plugin/internal/plugin/PluginPluginDescriptor;", "getInstalledFromDisk", "()Ljava/util/List;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PluginPluginDescriptor> getInstalledFromDisk() {
            return installedFromDisk;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

