/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin;

import app.termora.Application;
import app.termora.Icons;
import app.termora.plugin.Extension;
import app.termora.plugin.Plugin;
import app.termora.plugin.PluginDescription;
import app.termora.plugin.PluginDescriptor;
import app.termora.plugin.PluginOrigin;
import app.termora.plugin.internal.plugin.PluginSVGIcon;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Semver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\"\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lapp/termora/plugin/PluginXmlParser;", "", "<init>", "()V", "xPath", "Ljavax/xml/xpath/XPath;", "kotlin.jvm.PlatformType", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDocumentBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "documentBuilder$delegate", "Lkotlin/Lazy;", "parse", "Lorg/w3c/dom/Document;", "input", "Ljava/io/InputStream;", "Lapp/termora/plugin/PluginXmlParser$MyPluginDescriptor;", "plugin", "icon", "darkIcon", "MyPluginDescriptor", "termora"})
public final class PluginXmlParser {
    @NotNull
    public static final PluginXmlParser INSTANCE = new PluginXmlParser();
    private static final XPath xPath = XPathFactory.newInstance().newXPath();
    @NotNull
    private static final Lazy documentBuilder$delegate = LazyKt.lazy(PluginXmlParser::documentBuilder_delegate$lambda$0);

    private PluginXmlParser() {
    }

    private final DocumentBuilder getDocumentBuilder() {
        Lazy lazy = documentBuilder$delegate;
        return (DocumentBuilder)lazy.getValue();
    }

    @NotNull
    public final Document parse(@NotNull InputStream input2) {
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Document document = this.getDocumentBuilder().parse(new InputSource(input2));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        return document;
    }

    @NotNull
    public final MyPluginDescriptor parse(@NotNull InputStream plugin, @Nullable InputStream icon, @Nullable InputStream darkIcon) {
        int n;
        int i;
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Semver semver = Semver.parse((String)Application.INSTANCE.getVersion());
        if (semver == null) {
            throw new IllegalStateException("illegal version " + Application.INSTANCE.getVersion());
        }
        Semver version = semver;
        Document document = this.parse(plugin);
        Element root = document.getDocumentElement();
        if (!Intrinsics.areEqual((Object)root.getTagName(), (Object)"termora-plugin")) {
            throw new IllegalStateException();
        }
        boolean paid = xPath.compile("/termora-plugin/paid").evaluate(document, XPathConstants.NODE) != null;
        String pluginVersion = xPath.compile("/termora-plugin/version/text()").evaluate(document);
        String pluginId = xPath.compile("/termora-plugin/id/text()").evaluate(document);
        String pluginName = xPath.compile("/termora-plugin/name/text()").evaluate(document);
        String pluginEntry = xPath.compile("/termora-plugin/entry/text()").evaluate(document);
        String since = xPath.compile("/termora-plugin/termora-version/@since").evaluate(document);
        String until = xPath.compile("/termora-plugin/termora-version/@until").evaluate(document);
        Object object = new CharSequence[]{pluginVersion, pluginName, pluginId, pluginEntry, since};
        if (StringUtils.isAnyBlank((CharSequence[])object)) {
            throw new IllegalStateException("illegal plugin");
        }
        if (!version.satisfies(since)) {
            throw new IllegalStateException("version mismatch");
        }
        object = until;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && !version.satisfies(until)) {
            throw new IllegalStateException("version mismatch");
        }
        Object descriptionNodeset = xPath.compile("/termora-plugin/descriptions/description").evaluate(document, XPathConstants.NODESET);
        List descriptions = new ArrayList();
        if (descriptionNodeset instanceof NodeList && (i = 1) <= (n = ((NodeList)descriptionNodeset).getLength())) {
            while (true) {
                String language = xPath.compile("/termora-plugin/descriptions/description[" + i + "]/@language").evaluate(document);
                String description = xPath.compile("/termora-plugin/descriptions/description[" + i + "]/text()").evaluate(document);
                Intrinsics.checkNotNull((Object)language);
                Intrinsics.checkNotNull((Object)description);
                descriptions.add(new PluginDescription(language, description));
                if (i == n) break;
                ++i;
            }
        }
        Icon myIcon = (Icon)((Object)Icons.INSTANCE.getPlugin());
        if (icon != null && darkIcon != null) {
            myIcon = new PluginSVGIcon(icon, darkIcon);
        } else if (icon != null) {
            myIcon = new PluginSVGIcon(icon, null, 2, null);
        }
        Plugin plugin2 = new Plugin(pluginName, paid){
            final /* synthetic */ String $pluginName;
            final /* synthetic */ boolean $paid;
            {
                this.$pluginName = $pluginName;
                this.$paid = $paid;
            }

            public String getAuthor() {
                return "";
            }

            public String getName() {
                String string = this.$pluginName;
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public boolean isPaid() {
                return this.$paid;
            }

            public <T extends Extension> List<T> getExtensions(Class<T> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                return CollectionsKt.emptyList();
            }
        };
        Intrinsics.checkNotNull((Object)pluginId);
        Semver semver2 = Semver.parse((String)pluginVersion);
        if (semver2 == null) {
            throw new IllegalStateException("illegal version " + pluginVersion);
        }
        Intrinsics.checkNotNull((Object)pluginEntry);
        return new MyPluginDescriptor(plugin2, pluginId, myIcon, PluginOrigin.Memory, semver2, (List<PluginDescription>)descriptions, pluginEntry);
    }

    private static final DocumentBuilder documentBuilder_delegate$lambda$0() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setXIncludeAware(false);
        factory.setNamespaceAware(false);
        return factory.newDocumentBuilder();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lapp/termora/plugin/PluginXmlParser$MyPluginDescriptor;", "Lapp/termora/plugin/PluginDescriptor;", "plugin", "Lapp/termora/plugin/Plugin;", "id", "", "icon", "Ljavax/swing/Icon;", "origin", "Lapp/termora/plugin/PluginOrigin;", "version", "Lorg/semver4j/Semver;", "descriptions", "", "Lapp/termora/plugin/PluginDescription;", "entry", "<init>", "(Lapp/termora/plugin/Plugin;Ljava/lang/String;Ljavax/swing/Icon;Lapp/termora/plugin/PluginOrigin;Lorg/semver4j/Semver;Ljava/util/List;Ljava/lang/String;)V", "getEntry", "()Ljava/lang/String;", "termora"})
    public static final class MyPluginDescriptor
    extends PluginDescriptor {
        @NotNull
        private final String entry;

        public MyPluginDescriptor(@NotNull Plugin plugin, @NotNull String id, @NotNull Icon icon, @NotNull PluginOrigin origin, @NotNull Semver version, @NotNull List<PluginDescription> descriptions, @NotNull String entry) {
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            Intrinsics.checkNotNullParameter((Object)((Object)origin), (String)"origin");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter(descriptions, (String)"descriptions");
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            super(plugin, id, icon, origin, version, descriptions, null);
            this.entry = entry;
        }

        public /* synthetic */ MyPluginDescriptor(Plugin plugin, String string, Icon icon, PluginOrigin pluginOrigin, Semver semver, List list, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string = plugin.getName();
            }
            if ((n & 4) != 0) {
                icon = PluginDescriptor.Companion.getDefaultIcon();
            }
            if ((n & 0x20) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(plugin, string, icon, pluginOrigin, semver, (List<PluginDescription>)list, string2);
        }

        @NotNull
        public final String getEntry() {
            return this.entry;
        }
    }
}

