/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin;

import app.termora.ApplicationScope;
import app.termora.plugin.Extension;
import app.termora.plugin.ExtensionProxy;
import app.termora.plugin.Plugin;
import app.termora.plugin.PluginManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\b\b\u0000\u0010\t*\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lapp/termora/plugin/ExtensionManager;", "", "<init>", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "Lapp/termora/plugin/Extension;", "getExtensions", "", "T", "clazz", "Ljava/lang/Class;", "isExtension", "", "extension", "Lkotlin/reflect/KClass;", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nExtensionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionManager.kt\napp/termora/plugin/ExtensionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1056#2:59\n*S KotlinDebug\n*F\n+ 1 ExtensionManager.kt\napp/termora/plugin/ExtensionManager\n*L\n41#1:59\n*E\n"})
public final class ExtensionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<Extension, Object> map = new ConcurrentHashMap();
    private static final Logger log = LoggerFactory.getLogger(ExtensionManager.class);

    private ExtensionManager() {
    }

    @NotNull
    public final <T extends Extension> List<T> getExtensions(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List extensions = new ArrayList();
        for (Plugin plugin : PluginManager.Companion.getInstance().getLoadedPlugins()) {
            try {
                for (Extension extension : plugin.getExtensions(clazz)) {
                    Object proxy;
                    if (!clazz.isInstance(extension)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)this.map.computeIfAbsent(extension, arg_0 -> ExtensionManager.getExtensions$lambda$1(arg_0 -> ExtensionManager.getExtensions$lambda$0(plugin, extension, arg_0), arg_0)), (String)"computeIfAbsent(...)");
                    T t = clazz.cast(proxy);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
                    extensions.add(t);
                }
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) continue;
                Object[] objectArray = new Object[]{plugin.getName(), e.getMessage(), e};
                log.error("Plugin {} getExtensions: {}", objectArray);
            }
        }
        Iterable $this$sortedBy$iv = extensions;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Extension it = (Extension)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.ordered());
                it = (Extension)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.ordered()));
            }
        });
    }

    public final boolean isExtension(@NotNull Extension extension, @NotNull KClass<?> clazz) {
        InvocationHandler invocationHandler;
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (clazz.isInstance((Object)extension)) {
            return true;
        }
        if (Proxy.isProxyClass(extension.getClass()) && (invocationHandler = Proxy.getInvocationHandler(extension)) instanceof ExtensionProxy) {
            return clazz.isInstance((Object)((ExtensionProxy)invocationHandler).extension());
        }
        return false;
    }

    private static final Object getExtensions$lambda$0(Plugin $plugin, Extension $extension, Extension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ExtensionProxy($plugin, $extension).getProxy();
    }

    private static final Object getExtensions$lambda$1(Function1 $tmp0, Object p0) {
        return $tmp0.invoke(p0);
    }

    public /* synthetic */ ExtensionManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/plugin/ExtensionManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/plugin/ExtensionManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionManager getInstance() {
            return (ExtensionManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(ExtensionManager.class), Companion::getInstance$lambda$0);
        }

        private static final ExtensionManager getInstance$lambda$0() {
            return new ExtensionManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

