/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.HostTerminalTab;
import app.termora.TermoraFrameKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.database.DatabaseChangedExtension;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.highlight.KeywordHighlightType;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import app.termora.terminal.CharArraySubstr;
import app.termora.terminal.Document;
import app.termora.terminal.FindKind;
import app.termora.terminal.HighlighterRange;
import app.termora.terminal.KTermKt;
import app.termora.terminal.Position;
import app.termora.terminal.SubstrFinder;
import app.termora.terminal.TagHighlighter;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalLine;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelKt;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalPaintListener;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0003 !\"B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J8\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener;", "Lapp/termora/terminal/panel/TerminalPaintListener;", "Lapp/termora/Disposable;", "<init>", "()V", "keywordHighlightManager", "Lapp/termora/highlight/KeywordHighlightManager;", "getKeywordHighlightManager", "()Lapp/termora/highlight/KeywordHighlightManager;", "keywordHighlights", "", "Lapp/termora/highlight/KeywordHighlight;", "isFirst", "Ljava/util/concurrent/atomic/AtomicBoolean;", "reload", "", "before", "offset", "", "count", "g", "Ljava/awt/Graphics;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "terminal", "Lapp/termora/terminal/Terminal;", "doFind", "keywordHighlightSetId", "", "after", "Companion", "RegexFinder", "KeywordHighlightHighlighter", "termora"})
@SourceDebugExtension(value={"SMAP\nKeywordHighlightPaintListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeywordHighlightPaintListener.kt\napp/termora/highlight/KeywordHighlightPaintListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,264:1\n1#2:265\n*E\n"})
public final class KeywordHighlightPaintListener
implements TerminalPaintListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<KeywordHighlight> keywordHighlights = new ArrayList();
    @NotNull
    private final AtomicBoolean isFirst = new AtomicBoolean(true);
    private static final int tag = Random.Default.nextInt();
    private static final Logger log = LoggerFactory.getLogger(KeywordHighlightPaintListener.class);

    private KeywordHighlightPaintListener() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(DatabaseChangedExtension.class, (Extension)new DatabaseChangedExtension(){

            @Override
            public void onDataChanged(String id, String type, DatabaseChangedExtension.Action action2, DatabaseChangedExtension.Source source) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
                Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
                if (Intrinsics.areEqual((Object)type, (Object)"KeywordHighlight") || StringsKt.isBlank((CharSequence)id) && StringsKt.isBlank((CharSequence)type)) {
                    this.reload();
                }
            }
        });
        boolean bl = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountExtension(){

            @Override
            public void onAccountChanged(Account oldAccount, Account newAccount) {
                Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                this.reload();
            }
        });
        boolean bl2 = false;
        Disposer.register(this, it);
    }

    private final KeywordHighlightManager getKeywordHighlightManager() {
        return KeywordHighlightManager.Companion.getInstance();
    }

    private final void reload() {
        TermoraFrameKt.assertEventDispatchThread();
        this.keywordHighlights.clear();
        for (String ownerId : AccountManager.Companion.getInstance().getOwnerIds()) {
            this.keywordHighlights.addAll((Collection<KeywordHighlight>)this.getKeywordHighlightManager().getKeywordHighlights(ownerId));
        }
    }

    @Override
    public void before(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        block6: {
            Host host;
            String string;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
            Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            if (TerminalModelKt.isAlternateScreenBuffer(terminal.getTerminalModel())) {
                return;
            }
            if (this.isFirst.get() && this.isFirst.compareAndSet(true, false)) {
                this.reload();
            }
            String keywordHighlightSetId = "0";
            TerminalModel terminalModel = terminal.getTerminalModel();
            if (terminalModel.hasData(HostTerminalTab.Companion.getHost()) && (string = (host = terminalModel.getData(HostTerminalTab.Companion.getHost())).getOptions().getExtras().get("keywordHighlightSetId")) == null) {
                string = keywordHighlightSetId = keywordHighlightSetId;
            }
            if (Intrinsics.areEqual((Object)keywordHighlightSetId, (Object)"-1")) {
                return;
            }
            try {
                this.doFind(offset, count, terminal, keywordHighlightSetId);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private final void doFind(int offset, int count, Terminal terminal, String keywordHighlightSetId) {
        for (KeywordHighlight highlight : this.keywordHighlights) {
            Object object;
            if (!highlight.getEnabled() || highlight.getType() != KeywordHighlightType.Highlight || !Intrinsics.areEqual((Object)keywordHighlightSetId, (Object)highlight.getParentId())) continue;
            Document document = terminal.getDocument();
            List kinds = new ArrayList();
            Iterator<TerminalLine> iterator2 = new Iterator<TerminalLine>(offset, count, document){
                private int index;
                private final int maxCount;
                final /* synthetic */ Document $document;
                {
                    this.$document = $document;
                    this.index = $offset + 1;
                    this.maxCount = Math.min(this.index + $count, $document.getLineCount());
                }

                public boolean hasNext() {
                    return this.index <= this.maxCount;
                }

                public TerminalLine next() {
                    int n = this.index;
                    this.index = n + 1;
                    return this.$document.getLine(n);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
            if (highlight.getRegex()) {
                try {
                    List<FindKind> list;
                    Regex regex = highlight.getMatchCase() ? new Regex(highlight.getKeyword()) : new Regex(highlight.getKeyword(), RegexOption.IGNORE_CASE);
                    List<FindKind> $this$doFind_u24lambda_u240 = list = new RegexFinder(regex, iterator2).find();
                    boolean bl = false;
                    kinds.addAll((Collection)$this$doFind_u24lambda_u240);
                    object = list;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    object = Unit.INSTANCE;
                }
            } else {
                Iterator iterator3 = iterator2;
                char[] cArray = highlight.getKeyword().toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                Object $this$doFind_u24lambda_u241 = object = new SubstrFinder(iterator3, new CharArraySubstr(cArray), null, 4, null).find(!highlight.getMatchCase());
                boolean bl = false;
                kinds.addAll((Collection)$this$doFind_u24lambda_u241);
            }
            object = kinds.iterator();
            while (object.hasNext()) {
                FindKind kind = (FindKind)object.next();
                terminal.getMarkupModel().addHighlighter(new KeywordHighlightHighlighter(new HighlighterRange(Position.copy$default(kind.getStartPosition(), kind.getStartPosition().getY() + offset, 0, 2, null), Position.copy$default(kind.getEndPosition(), kind.getEndPosition().getY() + offset, 0, 2, null)), terminal, highlight));
            }
        }
    }

    @Override
    public void after(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        terminal.getMarkupModel().removeAllHighlighters(tag);
    }

    public /* synthetic */ KeywordHighlightPaintListener(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/highlight/KeywordHighlightPaintListener;", "tag", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeywordHighlightPaintListener getInstance() {
            return (KeywordHighlightPaintListener)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(KeywordHighlightPaintListener.class), Companion::getInstance$lambda$0);
        }

        private static final KeywordHighlightPaintListener getInstance$lambda$0() {
            return new KeywordHighlightPaintListener(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener$KeywordHighlightHighlighter;", "Lapp/termora/terminal/TagHighlighter;", "range", "Lapp/termora/terminal/HighlighterRange;", "terminal", "Lapp/termora/terminal/Terminal;", "keywordHighlight", "Lapp/termora/highlight/KeywordHighlight;", "<init>", "(Lapp/termora/terminal/HighlighterRange;Lapp/termora/terminal/Terminal;Lapp/termora/highlight/KeywordHighlight;)V", "getKeywordHighlight", "()Lapp/termora/highlight/KeywordHighlight;", "getTextStyle", "Lapp/termora/terminal/TextStyle;", "position", "Lapp/termora/terminal/Position;", "textStyle", "getTextStyle-mA23jlo", "(Lapp/termora/terminal/Position;J)J", "termora"})
    private static final class KeywordHighlightHighlighter
    extends TagHighlighter {
        @NotNull
        private final KeywordHighlight keywordHighlight;

        public KeywordHighlightHighlighter(@NotNull HighlighterRange range, @NotNull Terminal terminal, @NotNull KeywordHighlight keywordHighlight) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            Intrinsics.checkNotNullParameter((Object)keywordHighlight, (String)"keywordHighlight");
            super(range, terminal, tag);
            this.keywordHighlight = keywordHighlight;
        }

        @NotNull
        public final KeywordHighlight getKeywordHighlight() {
            return this.keywordHighlight;
        }

        @Override
        public long getTextStyle-mA23jlo(@NotNull Position position, long l) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return TextStyle.copy-dS5fxWA$default(l, this.keywordHighlight.getTextColor(), this.keywordHighlight.getBackgroundColor(), this.keywordHighlight.getBold(), this.keywordHighlight.getItalic(), this.keywordHighlight.getUnderline(), this.keywordHighlight.getLineThrough(), false, false, false, false, 960, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\n0\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener$RegexFinder;", "", "regex", "Lkotlin/text/Regex;", "iterator", "", "Lapp/termora/terminal/TerminalLine;", "<init>", "(Lkotlin/text/Regex;Ljava/util/Iterator;)V", "find", "", "Lapp/termora/terminal/FindKind;", "findMatchesWithCoords", "Lapp/termora/highlight/KeywordHighlightPaintListener$RegexFinder$MatchResultWithCoords;", "data", "", "Coords", "MatchResultWithCoords", "termora"})
    private static final class RegexFinder {
        @NotNull
        private final Regex regex;
        @NotNull
        private final Iterator<TerminalLine> iterator;

        public RegexFinder(@NotNull Regex regex, @NotNull Iterator<TerminalLine> iterator2) {
            Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
            Intrinsics.checkNotNullParameter(iterator2, (String)"iterator");
            this.regex = regex;
            this.iterator = iterator2;
        }

        @NotNull
        public final List<FindKind> find() {
            List lines = new ArrayList();
            List kinds = new ArrayList();
            Iterator iterator2 = CollectionsKt.withIndex(this.iterator);
            while (iterator2.hasNext()) {
                IndexedValue indexedValue = (IndexedValue)iterator2.next();
                int index = indexedValue.component1();
                TerminalLine line = (TerminalLine)indexedValue.component2();
                lines.add(line);
                if (line.getWrapped()) continue;
                List data = new ArrayList();
                for (TerminalLine e : lines) {
                    data.add((List)new ArrayList());
                    for (Pair<Character, TextStyle> c : e.chars()) {
                        if (KTermKt.isNull(((Character)c.getFirst()).charValue())) break;
                        ((List)CollectionsKt.last((List)data)).add(c.getFirst());
                    }
                }
                lines.clear();
                List<MatchResultWithCoords> resultWithCoords = this.findMatchesWithCoords(data);
                if (resultWithCoords.isEmpty()) continue;
                int offset = index - data.size() + 1;
                for (MatchResultWithCoords e : resultWithCoords) {
                    List<Coords> coords = e.getCoords();
                    if (coords.isEmpty()) continue;
                    kinds.add(new FindKind(new Position(((Coords)CollectionsKt.first(coords)).getRow() + offset + 1, ((Coords)CollectionsKt.first(coords)).getCol() + 1), new Position(((Coords)CollectionsKt.last(coords)).getRow() + offset + 1, ((Coords)CollectionsKt.last(coords)).getCol() + 1)));
                }
            }
            return kinds;
        }

        private final List<MatchResultWithCoords> findMatchesWithCoords(List<? extends List<Character>> data) {
            StringBuilder flatChars = new StringBuilder();
            List indexMap = new ArrayList();
            Iterator iterator2 = ((Iterable)data).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int rowIndex = n++;
                List row = (List)iterator2.next();
                Iterator iterator3 = ((Iterable)row).iterator();
                int n2 = 0;
                while (iterator3.hasNext()) {
                    int colIndex = n2++;
                    char c = ((Character)iterator3.next()).charValue();
                    flatChars.append(c);
                    indexMap.add(new Coords(rowIndex, colIndex));
                }
            }
            String string = flatChars.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.regex, (CharSequence)string, (int)0, (int)2, null), arg_0 -> RegexFinder.findMatchesWithCoords$lambda$0(indexMap, arg_0)));
        }

        private static final MatchResultWithCoords findMatchesWithCoords$lambda$0(List $indexMap, MatchResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new MatchResultWithCoords(it.getValue(), $indexMap.subList(it.getRange().getFirst(), it.getRange().getLast() + 1));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener$RegexFinder$Coords;", "", "row", "", "col", "<init>", "(II)V", "getRow", "()I", "getCol", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "termora"})
        private static final class Coords {
            private final int row;
            private final int col;

            public Coords(int row, int col) {
                this.row = row;
                this.col = col;
            }

            public final int getRow() {
                return this.row;
            }

            public final int getCol() {
                return this.col;
            }

            public final int component1() {
                return this.row;
            }

            public final int component2() {
                return this.col;
            }

            @NotNull
            public final Coords copy(int row, int col) {
                return new Coords(row, col);
            }

            public static /* synthetic */ Coords copy$default(Coords coords, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = coords.row;
                }
                if ((n3 & 2) != 0) {
                    n2 = coords.col;
                }
                return coords.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Coords(row=" + this.row + ", col=" + this.col + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.row);
                result2 = result2 * 31 + Integer.hashCode(this.col);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Coords)) {
                    return false;
                }
                Coords coords = (Coords)other;
                if (this.row != coords.row) {
                    return false;
                }
                return this.col == coords.col;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lapp/termora/highlight/KeywordHighlightPaintListener$RegexFinder$MatchResultWithCoords;", "", "match", "", "coords", "", "Lapp/termora/highlight/KeywordHighlightPaintListener$RegexFinder$Coords;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getMatch", "()Ljava/lang/String;", "getCoords", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "termora"})
        private static final class MatchResultWithCoords {
            @NotNull
            private final String match;
            @NotNull
            private final List<Coords> coords;

            public MatchResultWithCoords(@NotNull String match, @NotNull List<Coords> coords) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter(coords, (String)"coords");
                this.match = match;
                this.coords = coords;
            }

            @NotNull
            public final String getMatch() {
                return this.match;
            }

            @NotNull
            public final List<Coords> getCoords() {
                return this.coords;
            }

            @NotNull
            public final String component1() {
                return this.match;
            }

            @NotNull
            public final List<Coords> component2() {
                return this.coords;
            }

            @NotNull
            public final MatchResultWithCoords copy(@NotNull String match, @NotNull List<Coords> coords) {
                Intrinsics.checkNotNullParameter((Object)match, (String)"match");
                Intrinsics.checkNotNullParameter(coords, (String)"coords");
                return new MatchResultWithCoords(match, coords);
            }

            public static /* synthetic */ MatchResultWithCoords copy$default(MatchResultWithCoords matchResultWithCoords, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = matchResultWithCoords.match;
                }
                if ((n & 2) != 0) {
                    list = matchResultWithCoords.coords;
                }
                return matchResultWithCoords.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "MatchResultWithCoords(match=" + this.match + ", coords=" + this.coords + ")";
            }

            public int hashCode() {
                int result2 = this.match.hashCode();
                result2 = result2 * 31 + ((Object)this.coords).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MatchResultWithCoords)) {
                    return false;
                }
                MatchResultWithCoords matchResultWithCoords = (MatchResultWithCoords)other;
                if (!Intrinsics.areEqual((Object)this.match, (Object)matchResultWithCoords.match)) {
                    return false;
                }
                return Intrinsics.areEqual(this.coords, matchResultWithCoords.coords);
            }
        }
    }
}

