/*
 * Decompiled with CFR 0.152.
 */
package app.termora.actions;

import app.termora.I18n;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\n"}, d2={"Lapp/termora/actions/TerminalCopyAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "Companion", "EmptyTransferable", "termora"})
public final class TerminalCopyAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String COPY = "TerminalCopy";
    private static final Logger log = LoggerFactory.getLogger(TerminalCopyAction.class);

    public TerminalCopyAction() {
        this.putValue("ShortDescription", I18n.INSTANCE.getString("termora.actions.copy-from-terminal"));
        this.putValue("ActionCommandKey", COPY);
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        TerminalPanel terminalPanel = evt.getData(DataProviders.INSTANCE.getTerminalPanel());
        if (terminalPanel == null) {
            return;
        }
        TerminalPanel terminalPanel2 = terminalPanel;
        String text = terminalPanel2.copy();
        Clipboard systemClipboard = terminalPanel2.getToolkit().getSystemClipboard();
        evt.consume();
        if (((CharSequence)text).length() == 0) {
            systemClipboard.setContents(new EmptyTransferable(), null);
            return;
        }
        systemClipboard.setContents(new StringSelection(text), null);
        if (log.isTraceEnabled()) {
            log.trace("Copy to clipboard. {}", (Object)text);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/actions/TerminalCopyAction$Companion;", "", "<init>", "()V", "COPY", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/actions/TerminalCopyAction$EmptyTransferable;", "Ljava/awt/datatransfer/Transferable;", "<init>", "()V", "getTransferDataFlavors", "", "Ljava/awt/datatransfer/DataFlavor;", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "flavor", "getTransferData", "", "termora"})
    private static final class EmptyTransferable
    implements Transferable {
        @Override
        @NotNull
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[0];
        }

        @Override
        public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
            return false;
        }

        @Override
        @NotNull
        public Object getTransferData(@Nullable DataFlavor flavor) {
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

