/*
 * Decompiled with CFR 0.152.
 */
package app.termora.actions;

import app.termora.Application;
import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.DialogWrapper;
import app.termora.Host;
import app.termora.Host$;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OpenHostActionEvent;
import app.termora.OptionPane;
import app.termora.Options;
import app.termora.OutlineComboBox;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.WindowScope;
import app.termora.actions.ActionManager;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.actions.OpenHostAction;
import app.termora.actions.QuickConnectAction$HistoryHost$;
import app.termora.database.DatabaseManager;
import app.termora.protocol.ProtocolProvider;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u000b"}, d2={"Lapp/termora/actions/QuickConnectAction;", "Lapp/termora/actions/AnAction;", "<init>", "()V", "actionPerformed", "", "evt", "Lapp/termora/actions/AnActionEvent;", "Companion", "QuickConnectDialog", "HistoryHost", "termora"})
public final class QuickConnectAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String QUICK_CONNECT = "QuickConnectAction";
    @NotNull
    private static final QuickConnectAction instance = new QuickConnectAction();

    private QuickConnectAction() {
        super(I18n.INSTANCE.getString("termora.actions.quick-connect"), (Icon)((Object)Icons.INSTANCE.getFind()));
        this.putValue("ShortDescription", I18n.INSTANCE.getString("termora.actions.quick-connect"));
    }

    @Override
    protected void actionPerformed(@NotNull AnActionEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        WindowScope windowScope = evt.getData(DataProviders.INSTANCE.getWindowScope());
        if (windowScope == null) {
            return;
        }
        WindowScope scope = windowScope;
        QuickConnectDialog dialog2 = new QuickConnectDialog(scope.getWindow());
        dialog2.setVisible(true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lapp/termora/actions/QuickConnectAction$Companion;", "", "<init>", "()V", "QUICK_CONNECT", "", "instance", "Lapp/termora/actions/QuickConnectAction;", "getInstance", "()Lapp/termora/actions/QuickConnectAction;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final QuickConnectAction getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B/\b\u0010\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lapp/termora/actions/QuickConnectAction$HistoryHost;", "", "url", "", "host", "Lapp/termora/Host;", "<init>", "(Ljava/lang/String;Lapp/termora/Host;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lapp/termora/Host;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getUrl", "()Ljava/lang/String;", "getHost", "()Lapp/termora/Host;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    private static final class HistoryHost {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String url;
        @NotNull
        private final Host host;

        public HistoryHost(@NotNull String url, @NotNull Host host) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.url = url;
            this.host = host;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Host getHost() {
            return this.host;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final Host component2() {
            return this.host;
        }

        @NotNull
        public final HistoryHost copy(@NotNull String url, @NotNull Host host) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new HistoryHost(url, host);
        }

        public static /* synthetic */ HistoryHost copy$default(HistoryHost historyHost, String string, Host host, int n, Object object) {
            if ((n & 1) != 0) {
                string = historyHost.url;
            }
            if ((n & 2) != 0) {
                host = historyHost.host;
            }
            return historyHost.copy(string, host);
        }

        @NotNull
        public String toString() {
            return "HistoryHost(url=" + this.url + ", host=" + this.host + ")";
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + this.host.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HistoryHost)) {
                return false;
            }
            HistoryHost historyHost = (HistoryHost)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)historyHost.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.host, (Object)historyHost.host);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(HistoryHost self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.url);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)Host$.serializer.INSTANCE, (Object)self.host);
        }

        public /* synthetic */ HistoryHost(int seen0, String url, Host host, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)HistoryHost$$serializer.INSTANCE.getDescriptor());
            }
            this.url = url;
            this.host = host;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/actions/QuickConnectAction$HistoryHost$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/actions/QuickConnectAction$HistoryHost;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<HistoryHost> serializer() {
                return (KSerializer)HistoryHost$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/termora/actions/QuickConnectAction$QuickConnectDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "hostComboBox", "Lapp/termora/OutlineComboBox;", "", "usernameTextField", "Lapp/termora/OutlineTextField;", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "", "createOkAction", "Ljavax/swing/AbstractAction;", "getHistoryHost", "Lapp/termora/actions/QuickConnectAction$HistoryHost;", "host", "getHistories", "", "addNotify", "termora"})
    @SourceDebugExtension(value={"SMAP\nQuickConnectAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickConnectAction.kt\napp/termora/actions/QuickConnectAction$QuickConnectDialog\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n205#2:179\n222#2:181\n1#3:180\n*S KotlinDebug\n*F\n+ 1 QuickConnectAction.kt\napp/termora/actions/QuickConnectAction$QuickConnectDialog\n*L\n154#1:179\n161#1:181\n*E\n"})
    private static final class QuickConnectDialog
    extends DialogWrapper {
        @NotNull
        private final OutlineComboBox<String> hostComboBox;
        @NotNull
        private final OutlineTextField usernameTextField;
        @NotNull
        private final OutlinePasswordField passwordTextField;

        public QuickConnectDialog(@NotNull Window owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            super(owner);
            this.hostComboBox = new OutlineComboBox();
            this.usernameTextField = new OutlineTextField(256);
            this.passwordTextField = new OutlinePasswordField(256, false, 2, null);
            this.setModal(true);
            this.setTitle(I18n.INSTANCE.getString("termora.actions.quick-connect"));
            this.setResizable(false);
            this.init();
            this.pack();
            this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 250, this.getPreferredSize().height));
            this.setLocationRelativeTo(owner);
        }

        private final DatabaseManager.Properties getProperties() {
            return DatabaseManager.Companion.getInstance().getProperties();
        }

        @Override
        @NotNull
        protected JComponent createCenterPanel() {
            this.hostComboBox.setEditable(true);
            this.hostComboBox.setPlaceholderText("ssh://127.0.0.1:22");
            List<HistoryHost> histories = this.getHistories();
            for (HistoryHost history : histories) {
                if (Intrinsics.areEqual((Object)CollectionsKt.first(histories), (Object)history)) {
                    this.usernameTextField.setText(history.getHost().getUsername());
                    this.passwordTextField.setText(history.getHost().getAuthentication().getPassword());
                }
                this.hostComboBox.addItem(history.getUrl());
            }
            this.usernameTextField.setPlaceholderText(I18n.INSTANCE.getString("termora.new-host.general.username"));
            this.passwordTextField.setPlaceholderText(I18n.INSTANCE.getString("termora.new-host.general.password"));
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref");
            JPanel jPanel = FormBuilder.create().layout(layout).border(BorderFactory.createEmptyBorder(0, 8, 8, 8)).add(I18n.INSTANCE.getString("termora.new-host.general.protocol") + ":", new Object[0]).xy(1, 1).add((Component)((Object)this.hostComboBox)).xy(3, 1).add(I18n.INSTANCE.getString("termora.new-host.general.username") + ":", new Object[0]).xy(1, 3).add((Component)((Object)this.usernameTextField)).xy(3, 3).add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, 5).add((Component)((Object)this.passwordTextField)).xy(3, 5).build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        @Override
        protected void doOKAction() {
            Object object = this.hostComboBox.getSelectedItem();
            String host = object instanceof String ? (String)object : null;
            object = host;
            if (object == null || StringsKt.isBlank((CharSequence)object)) {
                this.hostComboBox.requestFocusInWindow();
                return;
            }
            HistoryHost historyHost = null;
            try {
                historyHost = this.getHistoryHost(((Object)StringsKt.trim((CharSequence)host)).toString());
            }
            catch (Exception e) {
                this.hostComboBox.requestFocusInWindow();
                Component component = this;
                String string = e.getMessage();
                if (string == null) {
                    string = ExceptionUtils.getRootCauseMessage((Throwable)e);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                OptionPane.showMessageDialog$default(OptionPane.INSTANCE, component, string2, null, 0, null, 20, null);
                return;
            }
            Action action2 = ActionManager.Companion.getInstance().getAction("OpenHostAction");
            if (action2 instanceof OpenHostAction) {
                SwingUtilities.invokeLater(() -> QuickConnectDialog.doOKAction$lambda$0(action2, this, historyHost));
            }
            super.doOKAction();
        }

        @Override
        @NotNull
        protected AbstractAction createOkAction() {
            return (AbstractAction)((Object)new DialogWrapper.OkAction(this, I18n.INSTANCE.getString("termora.welcome.contextmenu.connect")));
        }

        /*
         * WARNING - void declaration
         */
        private final HistoryHost getHistoryHost(String host) {
            void this_$iv;
            URI uri = URI.create(host);
            String string = uri.getScheme();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
            ProtocolProvider protocolProvider = ProtocolProvider.Companion.valueOf(string);
            if (protocolProvider == null) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)uri.getScheme(), (String)"getScheme(...)");
                throw new UnsupportedOperationException(I18n.INSTANCE.getString("termora.protocol.not-supported", objectArray));
            }
            String string2 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            String string3 = uri.getScheme();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getScheme(...)");
            String string4 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getHost(...)");
            int n = uri.getPort();
            String string5 = this.usernameTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
            String string6 = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            Authentication authentication = Authentication.Companion.getNo();
            char[] cArray = this.passwordTextField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            Object[] objectArray = cArray;
            String string7 = new String((char[])objectArray);
            objectArray = new Pair[1];
            objectArray[0] = (char)TuplesKt.to((Object)"Temporary", (Object)"true");
            HistoryHost historyHost = new HistoryHost(host, new Host(null, string2, string3, string4, n, string6, null, authentication.copy(AuthenticationType.Password, string7), null, Options.copy$default(Options.Companion.getDefault(), null, null, null, null, null, 0, null, null, false, null, null, MapsKt.mutableMapOf((Pair[])objectArray), 2047, null), null, 0L, null, null, null, null, false, 0L, 0L, 523585, null));
            List histories = CollectionsKt.toMutableList((Collection)this.getHistories());
            histories.removeIf(arg_0 -> QuickConnectDialog.getHistoryHost$lambda$1(arg_0 -> QuickConnectDialog.getHistoryHost$lambda$0(host, arg_0), arg_0));
            histories.addFirst(historyHost);
            if (histories.size() > 20) {
                histories.removeLast();
            }
            DatabaseManager.Properties properties = this.getProperties();
            Json json = Application.INSTANCE.getOhMyJson();
            List value$iv = histories;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            properties.putString("QuickConnect.historyHosts", this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(HistoryHost.Companion.serializer()), (Object)value$iv));
            return historyHost;
        }

        /*
         * WARNING - void declaration
         */
        private final List<HistoryHost> getHistories() {
            Object object;
            String text = this.getProperties().getString("QuickConnect.historyHosts", "[]");
            Object object2 = Application.INSTANCE.getOhMyJson();
            try {
                void this_$iv;
                Json $this$getHistories_u24lambda_u240 = object2;
                boolean bl = false;
                Json json = Application.INSTANCE.getOhMyJson();
                String string$iv = text;
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                object = Result.constructor-impl((Object)((List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(HistoryHost.Companion.serializer()), string$iv)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            List list = (List)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.setControlsVisible(false);
        }

        private static final void doOKAction$lambda$0(Action $action, QuickConnectDialog this$0, HistoryHost $historyHost) {
            ((OpenHostAction)((Object)$action)).actionPerformed((ActionEvent)new OpenHostActionEvent((Object)this$0, $historyHost.getHost(), new EventObject(this$0)));
        }

        private static final boolean getHistoryHost$lambda$0(String $host, HistoryHost it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getUrl(), (Object)$host);
        }

        private static final boolean getHistoryHost$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

