/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.AES;
import app.termora.account.AccountManager;
import app.termora.account.PullService;
import app.termora.account.Team;
import app.termora.database.Data;
import app.termora.database.DataEntity;
import app.termora.database.DatabaseChangedExtension;
import app.termora.database.DatabaseManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J9\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0015H\u0004\u00a2\u0006\u0002\u0010#J \u0010$\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0004J\u0010\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u001cH\u0004J \u0010)\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001cH\u0004R\u0014\u0010\u0004\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006+"}, d2={"Lapp/termora/account/SyncService;", "", "<init>", "()V", "databaseManager", "Lapp/termora/database/DatabaseManager;", "getDatabaseManager", "()Lapp/termora/database/DatabaseManager;", "database", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDatabase", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "databaseLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getDatabaseLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "isFreePlan", "", "()Z", "syncLock", "getSyncLock", "getData", "Lapp/termora/database/Data;", "id", "", "updateData", "", "synced", "version", "", "deleted", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Long;Ljava/lang/Boolean;)V", "encryptData", "data", "ownerId", "getSecretKey", "", "decryptData", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nSyncService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncService.kt\napp/termora/account/SyncService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n295#2,2:101\n*S KotlinDebug\n*F\n+ 1 SyncService.kt\napp/termora/account/SyncService\n*L\n90#1:101,2\n*E\n"})
public abstract class SyncService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ReentrantLock syncLock = new ReentrantLock();

    @NotNull
    protected final DatabaseManager getDatabaseManager() {
        return DatabaseManager.Companion.getInstance();
    }

    private final Database getDatabase() {
        return this.getDatabaseManager().getDatabase();
    }

    private final ReentrantLock getDatabaseLock() {
        return this.getDatabaseManager().getLock();
    }

    @NotNull
    protected final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    protected final boolean isFreePlan() {
        return this.getAccountManager().isFreePlan();
    }

    @NotNull
    protected final ReentrantLock getSyncLock() {
        return syncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final Data getData(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List list = new ArrayList();
        Lock lock = this.getDatabaseLock();
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.getDatabase(), arg_0 -> SyncService.getData$lambda$0$0(list, id, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return (Data)CollectionsKt.firstOrNull((List)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateData(@NotNull String id, @Nullable Boolean synced, @Nullable Long version, @Nullable Boolean deleted) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object object = new Object[]{version, deleted, synced};
        if (ObjectUtils.allNull((Object[])object)) {
            return;
        }
        object = this.getDatabaseLock();
        object.lock();
        try {
            boolean bl = false;
            int n = ((Number)TransactionManagerKt.transaction((Database)this.getDatabase(), arg_0 -> SyncService.updateData$lambda$0$0(id, version, synced, deleted, arg_0))).intValue();
        }
        finally {
            object.unlock();
        }
        if (this instanceof PullService) {
            DatabaseChangedExtension.Companion.fireDataChanged(id, "Host", DatabaseChangedExtension.Action.Changed, DatabaseChangedExtension.Source.Sync);
        }
    }

    public static /* synthetic */ void updateData$default(SyncService syncService, String string, Boolean bl, Long l, Boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateData");
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            l = null;
        }
        if ((n & 8) != 0) {
            bl2 = null;
        }
        syncService.updateData(string, bl, l, bl2);
    }

    @NotNull
    protected final String encryptData(@NotNull String id, @NotNull String data, @NotNull String ownerId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        byte[] byArray = DigestUtils.sha256((String)id);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha256(...)");
        byte[] byArray2 = byArray;
        int n = 12;
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        byte[] iv = byArray3;
        byte[] secretKey = this.getSecretKey(ownerId);
        if (secretKey.length == 0) {
            return "";
        }
        String string = data;
        byte[] byArray4 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getBytes(...)");
        String string2 = Base64.encodeBase64String((byte[])AES.GCM.INSTANCE.encrypt(secretKey, iv, byArray4));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeBase64String(...)");
        return string2;
    }

    @NotNull
    protected final byte[] getSecretKey(@NotNull String ownerId) {
        Object object;
        block7: {
            block6: {
                Team team;
                Object v0;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
                    if (Intrinsics.areEqual((Object)ownerId, (Object)this.getAccountManager().getAccountId())) {
                        return this.getAccountManager().getSecretKey();
                    }
                    Iterable $this$firstOrNull$iv = this.getAccountManager().getTeams();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Team it = (Team)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)ownerId)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                if ((object = (team = (Team)v0)) == null) break block6;
                byte[] byArray = ((Team)object).getSecretKey();
                object = byArray;
                if (byArray != null) break block7;
            }
            object = new byte[0];
        }
        return object;
    }

    @NotNull
    protected final String decryptData(@NotNull String id, @NotNull String data, @NotNull String ownerId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        byte[] byArray = DigestUtils.sha256((String)id);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha256(...)");
        byte[] byArray2 = byArray;
        int n = 12;
        byte[] byArray3 = Arrays.copyOf(byArray2, n);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(...)");
        byte[] iv = byArray3;
        byte[] secretKey = this.getSecretKey(ownerId);
        if (secretKey.length == 0) {
            throw new IllegalStateException("\u6839\u636e ownerId \u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u5bc6\u94a5");
        }
        byte[] byArray4 = Base64.decodeBase64((String)data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decodeBase64(...)");
        byte[] byArray5 = AES.GCM.INSTANCE.decrypt(secretKey, iv, byArray4);
        return new String(byArray5, Charsets.UTF_8);
    }

    private static final Unit getData$lambda$0$0(List $list, String $id, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        List rows = CollectionsKt.toList((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)DataEntity.INSTANCE)).where(() -> SyncService.getData$lambda$0$0$0($id))));
        for (ResultRow row : rows) {
            $list.add(Data.Companion.toData(row));
        }
        return Unit.INSTANCE;
    }

    private static final Op getData$lambda$0$0$0(String $id) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id);
    }

    private static final int updateData$lambda$0$0(String $id, Long $version, Boolean $synced, Boolean $deleted, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.update$default((Table)DataEntity.INSTANCE, () -> SyncService.updateData$lambda$0$0$0($id), null, (arg_0, arg_1) -> SyncService.updateData$lambda$0$0$1($version, $synced, $deleted, arg_0, arg_1), (int)2, null);
    }

    private static final Op updateData$lambda$0$0$0(String $id) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id);
    }

    private static final Unit updateData$lambda$0$0$1(Long $version, Boolean $synced, Boolean $deleted, DataEntity $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($version != null) {
            it.set(DataEntity.INSTANCE.getVersion(), (Object)$version);
        }
        if ($synced != null) {
            it.set(DataEntity.INSTANCE.getSynced(), (Object)$synced);
        }
        if ($deleted != null) {
            it.set(DataEntity.INSTANCE.getDeleted(), (Object)$deleted);
            it.set(DataEntity.INSTANCE.getData(), (Object)"");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lapp/termora/account/SyncService$Companion;", "", "<init>", "()V", "syncLock", "Ljava/util/concurrent/locks/ReentrantLock;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

